/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public abstract class AbstractCanvas
extends EventEnabledPanel
implements Printable {
    public static final int DEFAULT_COLOR_SCHEME = 0;
    public static final int PRINTER_COLOR_SCHEME = 1;
    public static boolean usePrinterColorSchemeForPrint = true;
    protected boolean screenPaint = true;
    public int currentColorScheme;
    private int prevColorScheme = this.currentColorScheme = 0;

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        double scaleFactorX = pf.getImageableWidth() / (double)this.getWidth();
        double scaleFactorY = pf.getImageableHeight() / (double)this.getHeight();
        double scaleFactor = Math.min(scaleFactorX, scaleFactorY);
        g2d.scale(scaleFactor, scaleFactor);
        this.paintComponent(g);
        return 0;
    }

    public void setPrintPaint() {
        this.screenPaint = false;
        this.prevColorScheme = this.currentColorScheme;
        if (usePrinterColorSchemeForPrint) {
            this.setPrinterColorScheme();
            this.currentColorScheme = 1;
        } else {
            this.currentColorScheme = 0;
        }
    }

    public void setScreenPaint() {
        this.screenPaint = true;
        this.changeColorScheme(this.prevColorScheme);
    }

    public void changeColorScheme(int newColorScheme) {
        this.changeColorScheme(newColorScheme, false);
    }

    public void changeColorScheme(int newColorScheme, boolean force) {
        if (force || newColorScheme != this.currentColorScheme) {
            if (newColorScheme == 0) {
                this.setDefaultColorScheme();
                this.currentColorScheme = 0;
            } else {
                this.setPrinterColorScheme();
                this.currentColorScheme = 1;
            }
        }
        this.prevColorScheme = this.currentColorScheme = newColorScheme;
    }

    public int getColorScheme() {
        return this.currentColorScheme;
    }

    public abstract void setPrinterColorScheme();

    public abstract void setDefaultColorScheme();
}

