/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.project.settings.ApplicationProperties;
import java.awt.Rectangle;

public abstract class AbstractLayoutOptions {
    private static final String STR_WIDTH = "_Width";
    private static final String STR_HEIGHT = "_Height";
    private static final String STR_X = "_X";
    private static final String STR_Y = "_Y";
    protected String prefix = "";

    public AbstractLayoutOptions(String prefix) {
        this.prefix = prefix;
        this.setDefaults();
    }

    protected abstract void setDefaults();

    public abstract void get(ApplicationProperties var1);

    public abstract void put(ApplicationProperties var1);

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected Rectangle setDefaults(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.setRect(-1.0, -1.0, -1.0, -1.0);
        return rectangle;
    }

    protected Rectangle[] setDefaults(Rectangle[] rectangles) {
        int i = 0;
        while (i < rectangles.length) {
            rectangles[i] = this.setDefaults(rectangles[i]);
            ++i;
        }
        return rectangles;
    }

    protected void get(ApplicationProperties properties, String frameName, Rectangle rectangle) {
        int w = properties.get(String.valueOf(this.prefix) + frameName + STR_WIDTH, rectangle.width);
        int h = properties.get(String.valueOf(this.prefix) + frameName + STR_HEIGHT, rectangle.height);
        int x = properties.get(String.valueOf(this.prefix) + frameName + STR_X, rectangle.x);
        int y = properties.get(String.valueOf(this.prefix) + frameName + STR_Y, rectangle.y);
        rectangle.setRect(x, y, w, h);
    }

    protected void get(ApplicationProperties properties, String frameName, Rectangle[] rectangles) {
        int i = 0;
        while (i < rectangles.length) {
            String s = "[" + i + "]";
            int w = properties.get(String.valueOf(this.prefix) + frameName + STR_WIDTH + s, rectangles[i].width);
            int h = properties.get(String.valueOf(this.prefix) + frameName + STR_HEIGHT + s, rectangles[i].height);
            int x = properties.get(String.valueOf(this.prefix) + frameName + STR_X + s, rectangles[i].x);
            int y = properties.get(String.valueOf(this.prefix) + frameName + STR_Y + s, rectangles[i].y);
            rectangles[i].setRect(x, y, w, h);
            ++i;
        }
    }

    protected void put(ApplicationProperties properties, String frameName, Rectangle rectangle) {
        properties.put(String.valueOf(this.prefix) + frameName + STR_WIDTH, rectangle.width);
        properties.put(String.valueOf(this.prefix) + frameName + STR_HEIGHT, rectangle.height);
        properties.put(String.valueOf(this.prefix) + frameName + STR_X, rectangle.x);
        properties.put(String.valueOf(this.prefix) + frameName + STR_Y, rectangle.y);
    }

    protected void put(ApplicationProperties properties, String frameName, Rectangle[] rectangles) {
        int i = 0;
        while (i < rectangles.length) {
            String s = "[" + i + "]";
            properties.put(String.valueOf(this.prefix) + frameName + STR_WIDTH + s, rectangles[i].width);
            properties.put(String.valueOf(this.prefix) + frameName + STR_HEIGHT + s, rectangles[i].height);
            properties.put(String.valueOf(this.prefix) + frameName + STR_X + s, rectangles[i].x);
            properties.put(String.valueOf(this.prefix) + frameName + STR_Y + s, rectangles[i].y);
            ++i;
        }
    }

    protected void copy(Rectangle source, Rectangle dest) {
        dest.setRect(source);
    }

    protected void copy(Rectangle[] source, Rectangle[] dest) {
        int i = 0;
        while (i < dest.length) {
            dest[i].setRect(source[i]);
            ++i;
        }
    }

    protected boolean equals(Rectangle r1, Rectangle r2) {
        return r1.equals(r2);
    }

    protected boolean equals(Rectangle[] r1, Rectangle[] r2) {
        int i = 0;
        while (i < r1.length) {
            if (!r1.equals(r2)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

