/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import edu.uml.lgdc.gui.LookAndFeelEvent;
import edu.uml.lgdc.gui.LookAndFeelEventListener;
import edu.uml.lgdc.project.Console;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LookAndFeelMgr {
    private static List<LookAndFeelEventListener> listeners = new ArrayList<LookAndFeelEventListener>();

    public static boolean install(String name, boolean doNotIssueMessages) {
        int n;
        boolean found = false;
        LookAndFeel prevLookAndFeel = UIManager.getLookAndFeel();
        UIManager.LookAndFeelInfo[] installedLookAndFeel = UIManager.getInstalledLookAndFeels();
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = installedLookAndFeel;
            n = installedLookAndFeel.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if (name.equals(info.getName())) {
                    found = true;
                    UIManager.setLookAndFeel(info.getClassName());
                    if (name.equals("Nimbus")) {
                        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
                        defaults.put("Table.gridColor", new Color(214, 217, 223));
                        defaults.put("Table.disabled", (Object)false);
                        defaults.put("Table.showGrid", (Object)true);
                        defaults.put("Table.intercellSpacing", new Dimension(1, 1));
                    }
                    if (!doNotIssueMessages) {
                        Console.showMsg(String.valueOf(name) + " Look and Feel is your current L&F");
                    }
                    Window[] windowArray = Window.getWindows();
                    int n3 = windowArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Window window = windowArray[n4];
                        SwingUtilities.updateComponentTreeUI(window);
                        window.pack();
                        ++n4;
                    }
                    LookAndFeelEvent ev = new LookAndFeelEvent(LookAndFeelMgr.class, prevLookAndFeel, UIManager.getLookAndFeel());
                    LookAndFeelMgr.fire(ev);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Console.printThreadStackTrace(ex);
        }
        if (!found && !doNotIssueMessages) {
            Console.showWarn(String.valueOf(name) + " Look and Feel is not installed");
            String msg = "You have the following Look&Feel installed on your system:";
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = installedLookAndFeel;
            int n5 = installedLookAndFeel.length;
            n = 0;
            while (n < n5) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n];
                msg = String.valueOf(msg) + "\n  " + info.getName();
                ++n;
            }
            Console.showMsg(msg);
            Console.showMsg("your current L&F is " + UIManager.getLookAndFeel().getName());
        }
        return found;
    }

    public static synchronized void addListener(LookAndFeelEventListener l) {
        listeners.add(l);
    }

    public static synchronized void removeListener(LookAndFeelEventListener l) {
        listeners.remove(l);
    }

    private static synchronized void fire(LookAndFeelEvent ev) {
        for (LookAndFeelEventListener l : listeners) {
            l.installed(ev);
        }
    }
}

