/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui;

import java.awt.Color;
import java.util.Enumeration;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;

public class UIDef {
    public static void setUIFont(FontUIResource fontUIResource) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            UIManager.put(key, fontUIResource);
        }
    }

    public static void increaseFont() {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            FontUIResource fontUIResource = (FontUIResource)value;
            UIManager.put(key, new FontUIResource(fontUIResource.getFontName(), fontUIResource.getStyle(), (int)(1.5 * (double)fontUIResource.getSize())));
        }
    }

    public static void decreaseFont() {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            FontUIResource fontUIResource;
            int newSize;
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource) || (newSize = (int)((double)(fontUIResource = (FontUIResource)value).getSize() / 1.5)) < 7) continue;
            UIManager.put(key, new FontUIResource(fontUIResource.getFontName(), fontUIResource.getStyle(), newSize));
        }
    }

    public static Color getPanelBackground(Color defColor) {
        Color color = UIManager.getColor("Panel.background");
        if (color != null) {
            return color;
        }
        return defColor;
    }

    public static Color getButtonForeground(Color defColor) {
        Color color = UIManager.getColor("Button.foreground");
        if (color != null) {
            return color;
        }
        return defColor;
    }

    public static Color getButtonDisabledTextColor(Color defColor) {
        Color color = null;
        String lafName = UIManager.getLookAndFeel().getName();
        if (lafName.equals("Metal") || lafName.equals("Nimbus") || lafName.equals("Mac OS X")) {
            color = UIManager.getColor("Button.disabledText");
        } else if (lafName.startsWith("Windows")) {
            color = UIManager.getColor("Button.disabledForeground");
        } else if (lafName.equals("CDE/Motif")) {
            color = UIManager.getColor("Button.foreground");
        }
        if (color != null) {
            return color;
        }
        return defColor;
    }

    public static Color getTextFieldSelectionForeground(Color defColor) {
        Color color = null;
        String lafName = UIManager.getLookAndFeel().getName();
        color = lafName.equals("Nimbus") ? UIManager.getColor("TextField[Selected].textForeground") : UIManager.getColor("TextField.selectionForeground");
        if (color != null) {
            return color;
        }
        return defColor;
    }

    public static Color getTextFieldSelectionBackground(Color defColor) {
        Color color = null;
        String lafName = UIManager.getLookAndFeel().getName();
        color = lafName.equals("Nimbus") ? defColor : UIManager.getColor("TextField.selectionBackground");
        if (color != null) {
            return color;
        }
        return defColor;
    }

    public static Color getTableSelectionForeground(Color defColor) {
        Color color = null;
        String lafName = UIManager.getLookAndFeel().getName();
        color = lafName.equals("Nimbus") ? UIManager.getColor("Table[Enabled+Selected].textForeground") : UIManager.getColor("Table.selectionForeground");
        if (color != null) {
            return color;
        }
        return defColor;
    }

    public static Color getTableSelectionBackground(Color defColor) {
        Color color = null;
        String lafName = UIManager.getLookAndFeel().getName();
        color = lafName.equals("Nimbus") ? UIManager.getColor("Table[Enabled+Selected].textBackground") : UIManager.getColor("Table.selectionBackground");
        if (color != null) {
            return color;
        }
        return defColor;
    }

    public static Color getTableFocusCellForeground(Color defColor) {
        Color color = null;
        String lafName = UIManager.getLookAndFeel().getName();
        color = lafName.equals("Nimbus") ? UIManager.getColor("Table[Enabled+Selected].textForeground") : UIManager.getColor("Table.focusCellForeground");
        if (color != null) {
            return color;
        }
        return defColor;
    }

    public static Color getTableFocusCellBackground(Color defColor) {
        Color color = null;
        String lafName = UIManager.getLookAndFeel().getName();
        color = lafName.equals("Nimbus") ? UIManager.getColor("Table[Enabled+Selected].textBackground") : UIManager.getColor("Table.focusCellBackground");
        if (color != null) {
            return color;
        }
        return defColor;
    }

    public static Border getTableHeaderCellBorder(Border defBorder) {
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        if (border != null) {
            return border;
        }
        return defBorder;
    }

    public static Border getTableFocusCellHighlightBorder(Border defBorder) {
        Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
        if (border != null) {
            return border;
        }
        return defBorder;
    }
}

