/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.controls;

import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.graph.ColorUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JLabel;

public class PadLabel
extends JLabel {
    private char padChar = (char)183;
    private Color padCharColor;

    public PadLabel(String text) {
        super(text);
    }

    public PadLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.setOpaque(true);
    }

    public void setPadChar(char padChar) {
        this.padChar = padChar;
    }

    public void setPadCharColor(Color color) {
        this.padCharColor = color;
    }

    @Override
    public void paintComponent(Graphics g) {
        FontMetrics m = g.getFontMetrics();
        int charWidth = m.charWidth(this.padChar);
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        Insets insets = this.getInsets();
        int y = insets.top + m.getAscent();
        g.setColor(this.getForeground());
        if (this.padCharColor == null) {
            this.padCharColor = ColorUtils.mixColors(this.getBackground(), this.getForeground(), 3.0, 1.0);
        }
        if (this.getHorizontalAlignment() == 2) {
            g.drawString(this.getText(), insets.left, y);
            int x = insets.left + m.stringWidth(this.getText()) + 5;
            int qty = (width - insets.right - x) / charWidth;
            if (qty > 0) {
                g.setColor(this.padCharColor);
                g.drawString(StrUtil.repeat(this.padChar, qty), x, y);
            }
        } else if (this.getHorizontalAlignment() == 4) {
            int x = width - insets.right - m.stringWidth(this.getText());
            g.drawString(this.getText(), x, y);
            int qty = (x - 5 - insets.left) / charWidth;
            if (qty > 0) {
                g.setColor(this.padCharColor);
                g.drawString(StrUtil.repeat(this.padChar, qty), insets.left, y);
            }
        } else if (this.getHorizontalAlignment() == 0) {
            int textWidth = m.stringWidth(this.getText());
            int x = insets.left + (width - insets.right - insets.left - m.stringWidth(this.getText())) / 2;
            g.drawString(this.getText(), x, y);
            int qty = (x - 5 - insets.left) / charWidth;
            if (qty > 0) {
                g.setColor(this.padCharColor);
                g.drawString(StrUtil.repeat(this.padChar, qty), insets.left, y);
            }
            if ((qty = (width - insets.right - x - textWidth - 5) / charWidth) > 0) {
                g.setColor(this.padCharColor);
                g.drawString(StrUtil.repeat(this.padChar, qty), x + textWidth + 5, y);
            }
        } else {
            super.paintComponent(g);
        }
    }
}

