/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.dialogs;

import edu.uml.lgdc.project.CommonConst;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class AboutBox
extends Dialog {
    private int buildNumber;
    private BorderLayout borderLayoutMain = new BorderLayout();
    private FlowLayout flowLayoutButtons = new FlowLayout();
    private GridLayout gridLayoutInfo = new GridLayout();
    private JPanel pnlInfo = new JPanel();
    private JLabel lblApplication = new JLabel();
    private JLabel lblCopyright = new JLabel();
    private JLabel lblFullName = new JLabel();
    private JPanel pnlButtons = new JPanel();
    private JButton btnClose = new JButton();

    public AboutBox(Frame parent) {
        this(parent, 0);
    }

    public AboutBox(Frame parent, int buildNumber) {
        super(parent);
        this.buildNumber = buildNumber;
        this.enableEvents(64L);
        this.guiInit();
        this.pack();
    }

    private void guiInit() {
        this.setTitle("About");
        this.setResizable(false);
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutBox.this.cancel();
            }
        });
        this.btnClose.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AboutBox.this.btnClose_KeyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                AboutBox.this.keyPressed(e);
            }
        });
        this.pnlButtons.setLayout(this.flowLayoutButtons);
        this.pnlButtons.add((Component)this.btnClose, null);
        this.lblApplication.setText(String.valueOf(CommonConst.getApplicationName()) + "  " + CommonConst.getApplicationVersion() + (this.buildNumber > 0 ? "." + this.buildNumber : ""));
        this.lblCopyright.setText(CommonConst.getApplicationCopyright());
        this.lblFullName.setText(CommonConst.getApplicationFullName());
        this.gridLayoutInfo.setRows(3);
        this.gridLayoutInfo.setColumns(1);
        this.pnlInfo.setLayout(this.gridLayoutInfo);
        this.pnlInfo.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.pnlInfo.add((Component)this.lblApplication, null);
        this.pnlInfo.add((Component)this.lblCopyright, null);
        this.pnlInfo.add((Component)this.lblFullName, null);
        this.setLayout(this.borderLayoutMain);
        this.add((Component)this.pnlInfo, "North");
        this.add((Component)this.pnlButtons, "South");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AboutBox.this.keyPressed(e);
            }
        });
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    private void btnClose_KeyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.cancel();
        }
    }

    private void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.cancel();
        }
    }
}

