/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.dialogs;

import edu.uml.lgdc.fileio.ExtFilter;
import edu.uml.lgdc.gui.dialogs.CommonDialogs;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;

public class ChooseFile {
    private String[] ext;
    private String extList;
    private String whereToAddText = "";
    private String extListText = "";
    private Frame parent;
    private String directory;
    private String filename;
    private boolean directoryMode;
    private String title;
    private boolean customTitle;

    public ChooseFile() {
        this(null);
    }

    public ChooseFile(Frame parent) {
        this(parent, null);
    }

    public ChooseFile(Frame parent, String[] ext) {
        this(parent, ext, null);
    }

    public ChooseFile(Frame parent, String[] ext, String whereToAdd) {
        this.parent = parent;
        this.ext = ext;
        if (whereToAdd != null && whereToAdd.trim().length() != 0) {
            this.whereToAddText = " to the " + whereToAdd;
        }
        this.extList = ChooseFile.getExtList(ext);
        if (!this.extList.equals("")) {
            this.extListText = " (" + this.extList + ")";
        }
    }

    public void setDirectoryMode() {
        this.directoryMode = true;
    }

    public void setPath(String directory) {
        this.directory = directory;
    }

    public String getPath() {
        return this.directory;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setTitle(String title) {
        this.title = title;
        this.customTitle = true;
    }

    public String choose(boolean add) {
        return this.chooseIt(false, add);
    }

    public String saveTo(boolean deleteExisted) {
        return this.chooseIt(true, deleteExisted);
    }

    private String chooseIt(boolean save, boolean add) {
        JFileChooser cf;
        block19: {
            File file;
            String currentTitle = this.title;
            boolean deleteExisted = add;
            if (!save) {
                if (!this.customTitle) {
                    currentTitle = !this.directoryMode ? (add ? "Add file" + this.extListText + this.whereToAddText : "Open file" + this.extListText) : (add ? "Add directory" : "Choose directory");
                }
            } else if (!this.customTitle) {
                currentTitle = "Choose file to save to";
            }
            cf = new JFileChooser();
            cf.setDialogTitle(currentTitle);
            if (this.directoryMode && !save) {
                cf.setFileSelectionMode(1);
            } else {
                cf.setFileSelectionMode(0);
            }
            cf.setMultiSelectionEnabled(false);
            if (!save) {
                cf.setDialogType(0);
            } else {
                cf.setDialogType(1);
            }
            if (this.directory != null) {
                cf.setCurrentDirectory(new File(this.directory));
            } else if (this.filename != null) {
                file = new File(this.filename).getParentFile();
                cf.setCurrentDirectory(file);
            }
            if (this.filename != null) {
                file = new File(new File(this.filename).getName());
                cf.setSelectedFile(file);
            }
            if (this.ext != null) {
                cf.setFileFilter(new ExtFilter(this.ext));
            }
            if (!save) {
                int answer;
                do {
                    if (cf.showOpenDialog(this.parent) != 0) {
                        return null;
                    }
                    answer = CommonDialogs.askOpenFile(cf.getSelectedFile().getPath());
                    if (answer != 3) continue;
                    return null;
                } while (answer != 0 && answer != 2);
            } else {
                int answer;
                do {
                    if (cf.showDialog(this.parent, "Save to") != 0) {
                        return null;
                    }
                    if (!new File(cf.getSelectedFile().getPath()).exists() || (answer = CommonDialogs.askFileOverwrite(cf.getSelectedFile().getPath(), deleteExisted)) == 0) break block19;
                } while (answer != 2);
                return null;
            }
        }
        this.directory = cf.getCurrentDirectory().getPath();
        this.filename = cf.getSelectedFile().getPath();
        return this.filename;
    }

    private static String getExtList(String[] ext) {
        String extList = "";
        if (ext != null && ext.length > 0) {
            extList = "*." + ext[0];
            int i = 1;
            while (i < ext.length) {
                extList = String.valueOf(extList) + ",*." + ext[i];
                ++i;
            }
        }
        return extList;
    }
}

