/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.dialogs;

import edu.uml.lgdc.graph.Draw;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class PasswordDB
extends JDialog {
    private String user = null;
    private String password = null;
    private JPanel pnlFields = new JPanel();
    private JPanel pnlButtons = new JPanel();
    private BorderLayout borderLayout = new BorderLayout(10, 10);
    private GridLayout gridLayout = new GridLayout(6, 1);
    private JLabel lblDatabaseURL = new JLabel();
    private JTextField tfDatabaseURL = new JTextField();
    private JLabel lblUserName = new JLabel();
    private JTextField tfUserName = new JTextField();
    private JLabel lblPassword = new JLabel();
    private JPasswordField pfPassword = new JPasswordField();
    private JButton btnOK = new JButton();
    private JLabel lblPadBetweenButtons = new JLabel();
    private JButton btnCancel = new JButton();

    public PasswordDB(String databaseURL, String userName) {
        super((Dialog)null, "Login window");
        this.setDatabaseURL(databaseURL);
        this.setUserName(userName);
        this.guiInit();
        this.pack();
        Draw.centerPosition(this);
        this.tfUserName.requestFocus();
    }

    private void guiInit() {
        this.lblDatabaseURL.setText(" Database URL:");
        this.tfDatabaseURL.setEditable(false);
        this.tfDatabaseURL.setRequestFocusEnabled(false);
        this.lblUserName.setText(" User name:");
        this.tfUserName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PasswordDB.this.tfUserName_keyPressed(e);
            }
        });
        this.lblPassword.setText(" Enter password:");
        this.pfPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PasswordDB.this.pfPassword_keyPressed(e);
            }
        });
        this.pnlFields.setLayout(this.gridLayout);
        this.pnlFields.add(this.lblDatabaseURL);
        this.pnlFields.add(this.tfDatabaseURL);
        this.pnlFields.add(this.lblUserName);
        this.pnlFields.add(this.tfUserName);
        this.pnlFields.add(this.lblPassword);
        this.pnlFields.add(this.pfPassword);
        this.btnOK.setText("OK");
        this.btnOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PasswordDB.this.btnOK_keyPressed(e);
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordDB.this.btnOK_actionPerformed(e);
            }
        });
        this.lblPadBetweenButtons.setText("              ");
        this.btnCancel.setText("Cancel");
        this.btnCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PasswordDB.this.btnCancel_keyPressed(e);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordDB.this.btnCancel_actionPerformed(e);
            }
        });
        this.pnlButtons.add(this.btnOK);
        this.pnlButtons.add(this.lblPadBetweenButtons);
        this.pnlButtons.add(this.btnCancel);
        this.getRootPane().setLayout(this.borderLayout);
        this.getRootPane().setBorder(new EmptyBorder(15, 15, 15, 15));
        this.getRootPane().add((Component)this.pnlFields, "North");
        this.getRootPane().add((Component)this.pnlButtons, "Center");
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.user = null;
            this.password = null;
        }
        super.setVisible(visible);
    }

    private void setDatabaseURL(String databaseURL) {
        this.tfDatabaseURL.setText(databaseURL);
    }

    private void setUserName(String userName) {
        if (userName != null) {
            this.tfUserName.setText(userName);
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    private void btnOK_actionPerformed(ActionEvent e) {
        this.user = this.tfUserName.getText().trim();
        this.password = new String(this.pfPassword.getPassword()).trim();
        this.setVisible(false);
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        this.user = null;
        this.password = null;
        this.setVisible(false);
    }

    private void btnOK_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 10) {
            this.btnOK_actionPerformed(null);
        } else if (key == 27) {
            this.btnCancel_actionPerformed(null);
        }
    }

    private void btnCancel_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 10 || key == 27) {
            this.btnCancel_actionPerformed(null);
        }
    }

    private void tfUserName_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 10) {
            this.tfUserName.transferFocus();
        } else if (key == 27) {
            this.btnCancel_actionPerformed(null);
        }
    }

    private void pfPassword_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 10) {
            this.pfPassword.transferFocus();
        } else if (key == 27) {
            this.btnCancel_actionPerformed(null);
        }
    }
}

