/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.dialogs;

import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.graph.WindowDisposerProcess;
import edu.uml.lgdc.gui.KeyboardEventDispatcher;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ThreeBtnMsgWin
extends JDialog {
    public static final int BTN_YES = 0;
    public static final int BTN_NO = 1;
    public static final int BTN_CANCEL = 2;
    private int exitState = 2;
    private int defaultExitState = 0;
    private int durationSec = 0;
    private final KeyEventDispatcher keyEventDispatcher;
    private final Frame frame;
    private JButton btnDefault;
    private WindowDisposerProcess disposerProcess;
    private final BorderLayout mainBorderLayout = new BorderLayout();
    private final FlowLayout flowLayoutButtonPanel = new FlowLayout();
    private final BorderLayout borderLayoutPanelMessage = new BorderLayout();
    private final JTextArea message = new JTextArea();
    private final JScrollPane scrollPaneMessage = new JScrollPane();
    private final JPanel panelMessage = new JPanel();
    private final JButton btnYes = new JButton();
    private final JButton btnNo = new JButton();
    private final JButton btnCancel = new JButton();
    private final JPanel panelButtons = new JPanel();
    private transient String procName;

    public ThreeBtnMsgWin(String textStr) {
        this(null, "Message window", true, textStr);
    }

    public ThreeBtnMsgWin(Frame frame, String textStr) {
        this(frame, "Message window", true, textStr);
    }

    public ThreeBtnMsgWin(Frame frame, String title, boolean modal, String textStr) {
        this(frame, title, modal, textStr, 0, 0);
    }

    public ThreeBtnMsgWin(Frame frame, String title, boolean modal, String textStr, int defaultExitState, int durationSec) {
        super(frame, title, modal);
        if (defaultExitState != 0 && defaultExitState != 1 && defaultExitState != 2) {
            throw new IllegalArgumentException("defaultExitState is illegal, " + defaultExitState + ", but must be " + 0 + ", " + 1 + " or " + 2);
        }
        Font font = new Font("SansSerif", 0, 14);
        this.message.setFont(font);
        if (textStr.length() > 0) {
            this.message.append(textStr);
        }
        this.guiInit();
        this.frame = frame;
        this.defaultExitState = defaultExitState;
        this.durationSec = durationSec;
        this.setDefaultButton();
        this.keyEventDispatcher = new KeyboardEventDispatcher(this, true, new int[]{9, 39, 37});
        this.setFocusTraversalKeys();
    }

    private void guiInit() {
        this.message.setLineWrap(true);
        this.message.setWrapStyleWord(true);
        this.message.setEditable(false);
        this.message.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ThreeBtnMsgWin.this.message_keyPressed(e);
            }
        });
        this.scrollPaneMessage.getViewport().add((Component)this.message, null);
        this.panelMessage.setLayout(this.borderLayoutPanelMessage);
        this.panelMessage.add((Component)this.scrollPaneMessage, "Center");
        this.btnYes.setText("Yes");
        this.btnYes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ThreeBtnMsgWin.this.btnYes_keyTyped(e);
            }
        });
        this.btnYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreeBtnMsgWin.this.btnYes_actionPerformed(e);
            }
        });
        this.btnNo.setText("No");
        this.btnNo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ThreeBtnMsgWin.this.btnNo_keyTyped(e);
            }
        });
        this.btnNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreeBtnMsgWin.this.btnNo_actionPerformed(e);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.setToolTipText("<HTML>Cancel action and exit window, <b>Esc</b></HTML>");
        this.btnCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ThreeBtnMsgWin.this.btnCancel_keyTyped(e);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreeBtnMsgWin.this.btnCancel_actionPerformed(e);
            }
        });
        this.panelButtons.setLayout(this.flowLayoutButtonPanel);
        this.panelButtons.add(this.btnYes);
        this.panelButtons.add(this.btnNo);
        this.panelButtons.add(this.btnCancel);
        this.getContentPane().setLayout(this.mainBorderLayout);
        this.getContentPane().add((Component)this.panelMessage, "Center");
        this.getContentPane().add((Component)this.panelButtons, "South");
        this.getContentPane().setLayout(this.mainBorderLayout);
        this.getContentPane().add((Component)this.panelMessage, "Center");
        this.getContentPane().add((Component)this.panelButtons, "South");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ThreeBtnMsgWin.this.keyPressed(e);
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
            this.panelMessage.setPreferredSize(Draw.rebuildTextArea(this.message));
            this.pack();
            Draw.centerPosition(this, this.frame);
            this.panelButtons.setFocusCycleRoot(true);
            this.btnDefault.requestFocus();
            if (this.durationSec > 0) {
                if (this.disposerProcess != null) {
                    this.disposerProcess.stopIt();
                }
                this.disposerProcess = new WindowDisposerProcess(this, this.durationSec);
                this.procName = this.disposerProcess.getName();
                this.disposerProcess.start();
            }
        } else {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
            if (this.durationSec > 0 && this.disposerProcess != null && Thread.currentThread().getName().equals(this.procName)) {
                this.exitState = this.defaultExitState;
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void setFont(Font font) {
        this.message.setFont(font);
    }

    public void setBgColor(Color color) {
        this.message.setBackground(color);
    }

    public void setFgColor(Color color) {
        this.message.setForeground(color);
    }

    public void setTwoButtonsMode() {
        this.btnCancel.setVisible(false);
    }

    public void setYesButtonText(String text) {
        this.btnYes.setText(text);
    }

    public void setNoButtonText(String text) {
        this.btnNo.setText(text);
    }

    public void setCancelButtonText(String text) {
        this.btnCancel.setText(text);
    }

    public int getExitCode() {
        return this.exitState;
    }

    private void btnYes_actionPerformed(ActionEvent e) {
        this.exitState = 0;
        this.dispose();
    }

    private void btnYes_keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.btnYes_actionPerformed(null);
        }
    }

    private void btnNo_actionPerformed(ActionEvent e) {
        this.exitState = 1;
        this.dispose();
    }

    private void btnNo_keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.btnNo_actionPerformed(null);
        }
    }

    private void btnCancel_actionPerformed(ActionEvent e) {
        this.exitState = 2;
        this.dispose();
    }

    private void btnCancel_keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.btnCancel_actionPerformed(null);
        }
    }

    public void message_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 39 || key == 37) {
            e.consume();
            this.btnDefault.requestFocus();
        }
    }

    private void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        int modifier = e.getModifiersEx();
        if (key == 27 && modifier == 0) {
            this.exitState = 2;
            e.consume();
            this.dispose();
        }
    }

    private void setFocusTraversalKeys() {
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>();
        forwardKeys.add(AWTKeyStroke.getAWTKeyStroke(39, 0, false));
        forwardKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 0, false));
        this.getContentPane().setFocusTraversalKeys(0, forwardKeys);
        HashSet<AWTKeyStroke> backwardKeys = new HashSet<AWTKeyStroke>();
        backwardKeys.add(AWTKeyStroke.getAWTKeyStroke(37, 0, false));
        backwardKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 1, false));
        this.getContentPane().setFocusTraversalKeys(1, backwardKeys);
    }

    private void setDefaultButton() {
        this.btnDefault = this.defaultExitState == 0 ? this.btnYes : (this.defaultExitState == 1 ? this.btnNo : this.btnCancel);
    }
}

