/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.frames;

import edu.uml.lgdc.format.C;
import edu.uml.lgdc.gui.HotKeyButton;
import edu.uml.lgdc.gui.HotKeyButtons;
import edu.uml.lgdc.gui.SunBug4783068Fixer;
import edu.uml.lgdc.gui.frames.SingleFrame;
import edu.uml.lgdc.gui.panels.SystemInfoPanel;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SystemInfoFrame
extends SingleFrame {
    private SystemInfoPanel systemInfoPanel = null;
    private JPanel pnlControl = new JPanel();
    private HotKeyButtons hotKeyButtons;
    private JButton btnRefresh = new JButton();
    private JButton btnClose = new JButton();
    private JButton btnRunGC = new JButton();

    public SystemInfoFrame() {
        this(new Rectangle(0, 0, -1, -1));
    }

    public SystemInfoFrame(Rectangle rectangle) {
        super(true);
        this.systemInfoPanel = new SystemInfoPanel();
        this.setPanel(this.systemInfoPanel);
        this.jbInit();
        this.setRectangle(rectangle);
        this.setSizeAndPos();
        this.setVisible(true);
    }

    private void jbInit() {
        ArrayList<HotKeyButton> lstHotKeyButtons = new ArrayList<HotKeyButton>();
        this.setTitle("System information");
        SunBug4783068Fixer.attach(this.btnRefresh);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SystemInfoFrame.this.systemInfoPanel.refresh();
            }
        };
        lstHotKeyButtons.add(new HotKeyButton((AbstractButton)this.btnRefresh, "Refresh", 'R', 128, (KeyListener)keyListener));
        this.btnRefresh.setToolTipText("<HTML>Refresh infromation and statistics, <b>Ctrl-R</b></HTML>");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemInfoFrame.this.systemInfoPanel.refresh();
            }
        });
        this.btnClose.setText("Close");
        this.btnClose.setToolTipText("<HTML>Close this window, <b>Esc</b></HTML>");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemInfoFrame.this.setVisible(false);
            }
        });
        SunBug4783068Fixer.attach(this.btnRunGC);
        keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SystemInfoFrame.this.runGC();
            }
        };
        lstHotKeyButtons.add(new HotKeyButton((AbstractButton)this.btnRunGC, "Run GC", 'G', 128, (KeyListener)keyListener));
        this.btnRunGC.setToolTipText("<HTML>Run garbarge collection and refresh, <b>Ctrl-G</b></HTML>");
        this.btnRunGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemInfoFrame.this.runGC();
            }
        });
        this.pnlControl.add(this.btnRefresh);
        this.pnlControl.add(this.btnClose);
        this.pnlControl.add(this.btnRunGC);
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.systemInfoPanel, "Center");
        this.getContentPane().add((Component)this.pnlControl, "South");
        this.hotKeyButtons = new HotKeyButtons(lstHotKeyButtons, true, true, true);
        this.hotKeyButtons.setColor(C.COLOR_HOT_KEY);
        this.hotKeyButtons.removeKeys();
    }

    public void refresh() {
        this.systemInfoPanel.refresh();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (e.isConsumed()) {
            return;
        }
        this.hotKeyButtons.keyPressed(e);
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.hotKeyButtons.keyReleased(e);
    }

    private void runGC() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.gc();
                SystemInfoFrame.this.systemInfoPanel.refresh();
            }
        }, "GC").start();
    }
}

