/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.help;

import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.gui.KeyboardEventDispatcher;
import edu.uml.lgdc.project.Console;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class Help
extends JFrame {
    private static final int MAX_HISTORY_LENGTH = 100;
    private static final ImageIcon backIcon = new ImageIcon(Object.class.getResource("/Images/left.gif"));
    private static final ImageIcon forwardIcon = new ImageIcon(Object.class.getResource("/Images/right.gif"));
    private KeyEventDispatcher keyEventDispatcher;
    private BorderLayout borderLayout = new BorderLayout();
    private JToolBar toolbar;
    private JButton btnBack;
    private JButton btnForward;
    private JScrollPane scrPane;
    private JEditorPane editor;
    private Border borderStatus = BorderFactory.createLoweredBevelBorder();
    private JLabel lblStatus;
    private Vector<HistoryElement> history = new Vector(100, 100);
    private int historyLength = 0;
    private int historyIndex = -1;
    private int historyLatest = -1;
    private int historyRecent = -1;
    private int numberOfHistInits = 0;
    private static Help helpFrame = new Help();

    private Help() {
        this.enableEvents(64L);
        this.jbInit();
        this.setSize(600, 400);
        Draw.centerPosition(this);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyEventDispatcher = new KeyboardEventDispatcher(this);
        keyboardFocusManager.addKeyEventDispatcher(this.keyEventDispatcher);
    }

    private void jbInit() {
        this.setTitle("Help");
        this.btnBack = new JButton();
        this.btnBack.setIcon(backIcon);
        this.btnBack.setToolTipText("Go back one page, Alt + left arrow");
        this.btnBack.setEnabled(false);
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Help.this.backward();
            }
        });
        this.btnForward = new JButton();
        this.btnForward.setIcon(forwardIcon);
        this.btnForward.setToolTipText("Go forward one page, Alt + right arrow");
        this.btnForward.setEnabled(false);
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Help.this.forward();
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.add(this.btnBack);
        this.toolbar.add(this.btnForward);
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        this.editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                Help.this.followLink(e);
            }
        });
        this.scrPane = new JScrollPane(this.editor);
        this.lblStatus = new JLabel("Status:");
        this.lblStatus.setBorder(this.borderStatus);
        this.getContentPane().setLayout(this.borderLayout);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.scrPane, "Center");
        this.getContentPane().add((Component)this.lblStatus, "South");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                helpFrame.keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                helpFrame.keyPressed(e);
            }
        });
        this.editor.setEditorKitForContentType("text/html", new SyncLoadingHTMLEditorKit());
    }

    private void setDisplay(boolean visible) {
        this.setVisible(visible);
        if (visible) {
            this.setState(0);
            this.toFront();
        }
    }

    public static void setPage(URL url) {
        helpFrame.setPage(url, null, false);
    }

    private void setPage(URL url, Point pos, boolean historyNavigating) {
        URL prevUrl = this.editor.getPage();
        Point prevPos = this.scrPane.getViewport().getViewPosition();
        boolean loadingError = false;
        try {
            if (url != null) {
                this.editor.setPage(url);
                if (pos != null) {
                    this.scrPane.getViewport().setViewPosition(pos);
                }
                this.lblStatus.setText("Loaded: " + url.toString());
                if (!(historyNavigating || this.historyLength != 0 && url.equals(this.history.get((int)this.historyIndex).url))) {
                    this.addLinkToHistory(url);
                }
            } else {
                this.lblStatus.setText("Error: null URL");
            }
        }
        catch (IOException e) {
            loadingError = true;
            this.lblStatus.setText(e.toString());
        }
        if (loadingError && prevUrl != null) {
            try {
                this.editor.setPage(prevUrl);
                if (prevPos != null) {
                    this.scrPane.getViewport().setViewPosition(prevPos);
                }
            }
            catch (IOException e) {
                Console.showError(e.toString());
            }
        }
        this.setDisplay(true);
    }

    public static void setHTMLFile(String shareResourceDir, String htmlFilename) {
        URL url = null;
        String filename = "Docs" + File.separator + "HTML" + File.separator + htmlFilename;
        File file = new File(filename);
        if (!file.exists() && !(file = new File(shareResourceDir, filename)).exists()) {
            return;
        }
        String location = file.getAbsolutePath();
        try {
            url = new URL("file:///" + location);
            Help.setPage(url);
        }
        catch (MalformedURLException e) {
            Help.helpFrame.lblStatus.setText(e.toString());
        }
    }

    public static boolean htmlFileExists(String shareResourceDir, String htmlFilename) {
        String filename = "Docs" + File.separator + "HTML" + File.separator + htmlFilename;
        return new File(filename).exists() || new File(shareResourceDir, filename).exists();
    }

    private void backward() {
        if (this.historyIndex == this.historyLatest) {
            return;
        }
        HistoryElement histEl = this.history.get(this.historyIndex);
        histEl.pos = this.scrPane.getViewport().getViewPosition();
        this.historyIndex = this.getPrevHistoryIndex(this.historyIndex);
        this.btnBack.setEnabled(this.historyIndex != this.historyLatest);
        this.btnForward.setEnabled(this.historyIndex != this.historyRecent);
        histEl = this.history.get(this.historyIndex);
        this.setPage(histEl.url, histEl.pos, true);
    }

    private void forward() {
        if (this.historyIndex == this.historyRecent) {
            return;
        }
        HistoryElement histEl = this.history.get(this.historyIndex);
        histEl.pos = this.scrPane.getViewport().getViewPosition();
        this.historyIndex = this.getNextHistoryIndex(this.historyIndex);
        this.btnBack.setEnabled(this.historyIndex != this.historyLatest);
        this.btnForward.setEnabled(this.historyIndex != this.historyRecent);
        histEl = this.history.get(this.historyIndex);
        this.setPage(histEl.url, histEl.pos, true);
    }

    private void followLink(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            HistoryElement histEl = this.history.get(this.historyIndex);
            histEl.pos = this.scrPane.getViewport().getViewPosition();
            Help.setPage(url);
        }
    }

    private void addLinkToHistory(URL url) {
        if (this.historyLength == 0) {
            this.historyLatest = 0;
            this.historyRecent = 0;
        } else if (this.historyLength < 100 || this.historyIndex != this.historyRecent) {
            this.historyRecent = this.getNextHistoryIndex(this.historyIndex);
        } else {
            this.historyLatest = this.getNextHistoryIndex(this.historyLatest);
            this.historyRecent = this.getNextHistoryIndex(this.historyRecent);
        }
        this.historyIndex = this.historyRecent;
        this.setHistoryLength();
        this.setHistory(this.historyIndex, url);
        this.btnBack.setEnabled(this.historyLength > 1);
        this.btnForward.setEnabled(false);
    }

    private void setHistoryLength() {
        this.historyLength = this.historyRecent >= this.historyLatest ? this.historyRecent - this.historyLatest + 1 : 100 - this.historyLatest + (this.historyRecent + 1);
    }

    private void setHistory(int index, URL url) {
        if (index < this.numberOfHistInits) {
            this.history.set(index, new HistoryElement(url, new Point(0, 0)));
        } else if (index == this.numberOfHistInits) {
            this.history.add(new HistoryElement(url, new Point(0, 0)));
            ++this.numberOfHistInits;
        } else {
            throw new RuntimeException("unexpected behaviour");
        }
    }

    private int getPrevHistoryIndex(int index) {
        if (--index < 0) {
            index = 99;
        }
        return index;
    }

    private int getNextHistoryIndex(int index) {
        if (++index == 100) {
            index = 0;
        }
        return index;
    }

    void keyTyped(KeyEvent e) {
    }

    void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 37 && e.isAltDown()) {
            this.backward();
        } else if (code == 39 && e.isAltDown()) {
            this.forward();
        }
    }

    private static class HistoryElement {
        URL url;
        Point pos;

        HistoryElement(URL url, Point pos) {
            this.url = url;
            this.pos = pos;
        }
    }

    private static class SyncLoadingHTMLEditorKit
    extends HTMLEditorKit {
        private SyncLoadingHTMLEditorKit() {
        }

        @Override
        public Document createDefaultDocument() {
            Document doc = super.createDefaultDocument();
            ((HTMLDocument)doc).setAsynchronousLoadPriority(-1);
            return doc;
        }
    }
}

