/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.format.C;
import edu.uml.lgdc.gui.HotKey;
import edu.uml.lgdc.gui.HotKeyButton;
import edu.uml.lgdc.gui.HotKeyButtons;
import edu.uml.lgdc.gui.InfoLine;
import edu.uml.lgdc.gui.SunBug4783068Fixer;
import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.DebugParam;
import edu.uml.lgdc.project.LogTail;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppInfoPanel
extends EventEnabledPanel {
    private static final int ERROR_LOG_LINES = 100;
    private static final int OUTPUT_LOG_LINES = 300;
    private static final int H_GAP = 5;
    private static final int V_GAP = 0;
    private LogTail logTail;
    private JTabbedPane tpInfo = new JTabbedPane();
    private HotKeyButtons hotKeyButtons;
    private JPanel pnlRootGeneral = new JPanel();
    private JScrollPane scrPaneGeneral = new JScrollPane();
    private JPanel pnlAdjustedListGeneral = new JPanel(new BorderLayout());
    private JPanel pnlListGeneral = new JPanel();
    private BoxLayout boxLayoutListGeneral = new BoxLayout(this.pnlListGeneral, 1);
    private JPanel pnlRootErrorLog = new JPanel();
    private JScrollPane scrPaneErrorLog = new JScrollPane();
    private JTextArea taErrorLog = new JTextArea();
    private JPanel pnlRootOutputLog = new JPanel();
    private JScrollPane scrPaneOutputLog = new JScrollPane();
    private JTextArea taOutputLog = new JTextArea();
    private Border borderInfoLine = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(1, 5, 0, 5));
    private static final int TAB_INDEX_GENERAL = 0;
    private static final int TAB_INDEX_ERROR_LOG = 1;
    private static final int TAB_INDEX_OUTPUT_LOG = 2;
    private final int numberOfTabs;
    private final String[] tabTitles;
    private final String[] tabDescs;
    private final boolean[] tabManualRefresh;
    private final boolean[] tabRefreshOnTabChange;
    private JPanel[] rootPanels = new JPanel[]{this.pnlRootGeneral, this.pnlRootErrorLog, this.pnlRootOutputLog};
    private JScrollPane[] scrPanes = new JScrollPane[]{this.scrPaneGeneral, this.scrPaneErrorLog, this.scrPaneOutputLog};
    private JPanel[] adjustedListPanels;
    private JPanel[] listPanels;
    private BoxLayout[] listPanelBoxLayouts;
    private JPanel pnlRefresh;
    private JButton btnRefresh;
    private JLabel lblAppName;
    private JLabel lblAppNameVal;
    private InfoLine lineAppName;
    private JLabel lblAppVersion;
    private JLabel lblAppVersionVal;
    private InfoLine lineAppVersion;
    private JLabel lblWorkingDir;
    private JLabel lblWorkingDirVal;
    private InfoLine lineWorkingDir;
    private JLabel lblUserDir;
    private JLabel lblUserDirVal;
    private InfoLine lineUserDir;
    private JLabel lblSharedResourcesDir;
    private JLabel lblSharedResourcesDirVal;
    private InfoLine lineSharedResourcesDir;
    private JLabel lblTempDir;
    private JLabel lblTempDirVal;
    private InfoLine lineTempDir;
    private JLabel lblLookAndFeel;
    private JLabel lblLookAndFeelVal;
    private InfoLine lineLookAndFeel;
    private final List<List<InfoLine>> lines;

    public AppInfoPanel(LogTail logTail) {
        JPanel[] jPanelArray = new JPanel[5];
        jPanelArray[0] = this.pnlAdjustedListGeneral;
        this.adjustedListPanels = jPanelArray;
        JPanel[] jPanelArray2 = new JPanel[5];
        jPanelArray2[0] = this.pnlListGeneral;
        this.listPanels = jPanelArray2;
        BoxLayout[] boxLayoutArray = new BoxLayout[5];
        boxLayoutArray[0] = this.boxLayoutListGeneral;
        this.listPanelBoxLayouts = boxLayoutArray;
        this.pnlRefresh = new JPanel();
        this.btnRefresh = new JButton();
        this.lblAppName = new JLabel("Application name");
        this.lblAppNameVal = new JLabel();
        this.lineAppName = new InfoLine(this.lblAppName, this.lblAppNameVal);
        this.lblAppVersion = new JLabel("Application version:");
        this.lblAppVersionVal = new JLabel();
        this.lineAppVersion = new InfoLine(this.lblAppVersion, this.lblAppVersionVal);
        this.lblWorkingDir = new JLabel("Working dir:");
        this.lblWorkingDirVal = new JLabel();
        this.lineWorkingDir = new InfoLine(this.lblWorkingDir, this.lblWorkingDirVal);
        this.lblUserDir = new JLabel("User dir:");
        this.lblUserDirVal = new JLabel();
        this.lineUserDir = new InfoLine(this.lblUserDir, this.lblUserDirVal);
        this.lblSharedResourcesDir = new JLabel("Shared resources dir:");
        this.lblSharedResourcesDirVal = new JLabel();
        this.lineSharedResourcesDir = new InfoLine(this.lblSharedResourcesDir, this.lblSharedResourcesDirVal);
        this.lblTempDir = new JLabel("Temp dir:");
        this.lblTempDirVal = new JLabel();
        this.lineTempDir = new InfoLine(this.lblTempDir, this.lblTempDirVal);
        this.lblLookAndFeel = new JLabel("Look and Feel:");
        this.lblLookAndFeelVal = new JLabel();
        this.lineLookAndFeel = new InfoLine(this.lblLookAndFeel, this.lblLookAndFeelVal);
        this.logTail = logTail;
        this.numberOfTabs = logTail != null ? 3 : 1;
        this.tabTitles = new String[this.numberOfTabs];
        this.tabDescs = new String[this.numberOfTabs];
        this.tabManualRefresh = new boolean[this.numberOfTabs];
        this.tabRefreshOnTabChange = new boolean[this.numberOfTabs];
        this.lines = new ArrayList<List<InfoLine>>(this.numberOfTabs);
        this.init();
        this.guiInit();
        this.setPreferredSize(new Dimension(580, 450));
        this.tpStateChanged();
        this.refresh();
    }

    private void init() {
        int i = 0;
        this.tabTitles[i] = "General";
        this.tabDescs[i] = "General info";
        this.tabManualRefresh[i] = false;
        this.tabRefreshOnTabChange[i] = false;
        if (this.logTail != null) {
            this.tabTitles[++i] = "Errors";
            this.tabDescs[i] = "Tail of Error Logs (no more than 100)";
            this.tabManualRefresh[i] = true;
            this.tabRefreshOnTabChange[i] = false;
            this.tabTitles[++i] = "Output";
            this.tabDescs[i] = "Tail of Output Logs (no more than 300)";
            this.tabManualRefresh[i] = true;
            this.tabRefreshOnTabChange[i] = false;
        }
        if (this.logTail != null) {
            this.taErrorLog.setLineWrap(true);
            this.taErrorLog.setWrapStyleWord(true);
            this.taErrorLog.setEditable(false);
            this.taErrorLog.setFont(new Font("Courier", 0, 12));
            this.taOutputLog.setLineWrap(true);
            this.taOutputLog.setWrapStyleWord(true);
            this.taOutputLog.setEditable(false);
            this.taOutputLog.setFont(new Font("Courier", 0, 12));
        }
        this.rootPanels = new JPanel[this.numberOfTabs];
        this.scrPanes = new JScrollPane[this.numberOfTabs];
        this.adjustedListPanels = new JPanel[this.numberOfTabs];
        this.listPanels = new JPanel[this.numberOfTabs];
        this.listPanelBoxLayouts = new BoxLayout[this.numberOfTabs];
        i = 0;
        this.rootPanels[i] = this.pnlRootGeneral;
        this.scrPanes[i] = this.scrPaneGeneral;
        this.adjustedListPanels[i] = this.pnlAdjustedListGeneral;
        this.listPanels[i] = this.pnlListGeneral;
        this.listPanelBoxLayouts[i] = this.boxLayoutListGeneral;
        if (this.logTail != null) {
            this.rootPanels[++i] = this.pnlRootErrorLog;
            this.scrPanes[i] = this.scrPaneErrorLog;
            this.adjustedListPanels[i] = null;
            this.listPanels[i] = null;
            this.listPanelBoxLayouts[i] = null;
            this.rootPanels[++i] = this.pnlRootOutputLog;
            this.scrPanes[i] = this.scrPaneOutputLog;
            this.adjustedListPanels[i] = null;
            this.listPanels[i] = null;
            this.listPanelBoxLayouts[i] = null;
        }
        this.fillInfoLines();
    }

    private void fillInfoLines() {
        int i = 0;
        while (i < this.numberOfTabs) {
            this.lines.add(new ArrayList());
            ++i;
        }
        this.lines.get(0).add(this.lineAppName);
        this.lines.get(0).add(this.lineAppVersion);
        this.lines.get(0).add(this.lineWorkingDir);
        this.lines.get(0).add(this.lineUserDir);
        this.lines.get(0).add(this.lineSharedResourcesDir);
        this.lines.get(0).add(this.lineTempDir);
        this.lines.get(0).add(this.lineLookAndFeel);
    }

    private void guiInit() {
        this.lblAppNameVal.setText(CommonConst.getApplicationName());
        this.lblAppVersionVal.setText(CommonConst.getApplicationVersion());
        this.lblWorkingDirVal.setText(CommonConst.getWorkingDir());
        this.lblUserDirVal.setText(CommonConst.getUserDir());
        this.lblSharedResourcesDirVal.setText(CommonConst.getShareResourcesDir());
        this.lblTempDirVal.setText(CommonConst.getTempDir());
        this.lblLookAndFeelVal.setText(UIManager.getLookAndFeel().getName());
        this.tpInfo.setFocusable(false);
        this.taErrorLog.setFocusable(false);
        this.taOutputLog.setFocusable(false);
        int i = 0;
        while (i < this.numberOfTabs) {
            if (i != 1 && i != 2) {
                this.listPanels[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                this.listPanels[i].setLayout(this.listPanelBoxLayouts[i]);
                for (InfoLine line : this.lines.get(i)) {
                    line.setBorder(this.borderInfoLine);
                    line.setGaps(5, 0);
                    this.listPanels[i].add(line);
                }
                this.adjustedListPanels[i].add((Component)this.listPanels[i], "North");
                this.scrPanes[i].setViewportView(this.adjustedListPanels[i]);
                this.scrPanes[i].getVerticalScrollBar().setUnitIncrement(this.lines.get((int)i).get((int)0).getPreferredSize().height);
            } else if (i == 1) {
                this.scrPanes[i].setViewportView(this.taErrorLog);
            } else if (i == 2) {
                this.scrPanes[i].setViewportView(this.taOutputLog);
            }
            this.rootPanels[i].setLayout(new BorderLayout(10, 0));
            this.rootPanels[i].add((Component)this.scrPanes[i], "Center");
            this.tpInfo.addTab(this.tabTitles[i], null, this.rootPanels[i], this.tabDescs[i]);
            ++i;
        }
        this.setLayout(new BorderLayout());
        if (this.numberOfTabs > 1) {
            this.add((Component)this.tpInfo, "Center");
        } else {
            this.add((Component)this.rootPanels[0], "Center");
        }
        SunBug4783068Fixer.attach(this.btnRefresh);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (AppInfoPanel.this.btnRefresh.isEnabled() && AppInfoPanel.this.btnRefresh.isShowing()) {
                    AppInfoPanel.this.refresh();
                }
            }
        };
        ArrayList<HotKeyButton> lstHotKeyButtons = new ArrayList<HotKeyButton>();
        lstHotKeyButtons.add(new HotKeyButton((AbstractButton)this.btnRefresh, "Refresh", 'R', 128, (KeyListener)keyListener));
        this.btnRefresh.setToolTipText("<HTML>Push to refresh content, hot key: <b>Ctrl-R</b></HTML");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppInfoPanel.this.refresh();
            }
        });
        this.pnlRefresh.setBorder(BorderFactory.createRaisedBevelBorder());
        this.pnlRefresh.add(this.btnRefresh);
        this.tpInfo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AppInfoPanel.this.tpStateChanged();
            }
        });
        this.hotKeyButtons = new HotKeyButtons(lstHotKeyButtons, true, true, true);
        this.hotKeyButtons.setColor(C.COLOR_HOT_KEY);
        this.hotKeyButtons.removeKeys();
    }

    public void refresh() {
        this.lblLookAndFeelVal.setText(UIManager.getLookAndFeel().getName());
        if (this.logTail != null) {
            StringBuilder strBuf = new StringBuilder(80 * Math.max(100, 300));
            List<String> tail = this.logTail.getErrorLogTail(100);
            for (String line : tail) {
                strBuf.append(line);
            }
            this.taErrorLog.setText(strBuf.toString());
            tail = this.logTail.getOutputLogTail(300);
            strBuf.setLength(0);
            for (String line : tail) {
                strBuf.append(line);
            }
            this.taOutputLog.setText(strBuf.toString());
        }
    }

    public void moveToNextTab() {
        HotKey.moveToNextTab(this.tpInfo);
    }

    public void moveToPrevTab() {
        HotKey.moveToPrevTab(this.tpInfo);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.hotKeyButtons.keyPressed(e);
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.hotKeyButtons.keyReleased(e);
    }

    private void tpStateChanged() {
        int tabIndex = this.tpInfo.getSelectedIndex();
        if (tabIndex >= 0) {
            if (this.tabManualRefresh[tabIndex]) {
                this.rootPanels[tabIndex].add((Component)this.pnlRefresh, "South");
            }
            if (this.tabRefreshOnTabChange[tabIndex]) {
                this.refresh();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (DebugParam.debug && this.getClass().getName().equals(AppInfoPanel.class.getName())) {
            Console.showMsg(String.valueOf(this.getClass().getName()) + " --> GC");
        }
        super.finalize();
    }
}

