/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.gui.FocusMonitoredObject;
import edu.uml.lgdc.gui.controls.PosIntegerField;
import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import edu.uml.lgdc.time.TimeScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DatePanel
extends EventEnabledPanel
implements FocusMonitoredObject {
    static final int maxWaitInMilliseconds = 400;
    static final int NONE = -1;
    static final int YEAR = 0;
    static final int MONTH = 1;
    static final int DAY = 2;
    static final int HOUR = 3;
    static final int MINUTE = 4;
    static final int SECOND = 5;
    static final int UP = 6;
    static final int DOWN = 7;
    static final int YEAR_UP = 0;
    static final int YEAR_DOWN = 1;
    static final int MONTH_UP = 2;
    static final int MONTH_DOWN = 3;
    static final int DAY_UP = 4;
    static final int DAY_DOWN = 5;
    static final int HOUR_UP = 6;
    static final int HOUR_DOWN = 7;
    static final int MINUTE_UP = 8;
    static final int MINUTE_DOWN = 9;
    static final int SECOND_UP = 10;
    static final int SECOND_DOWN = 11;
    static final double waitDivider = 1.3;
    static final int minWaitInMilliseconds = 10;
    static final int nSecToShowError = 1;
    private static Border lineBorder = BorderFactory.createLineBorder(Color.gray, 1);
    private static Border raisedBevelBorder = BorderFactory.createRaisedBevelBorder();
    private static Border loweredBevelBorder = BorderFactory.createLoweredBevelBorder();
    private static final int[] maxDaysPerMonth = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int CONVERT_MODE_WITH_INC = 1;
    private static final int CONVERT_MODE_WITH_DEC = 2;
    private static final int NOT_USED = -999999;
    private static final TimeScale tm = new TimeScale();
    private static final int defYear = 2000;
    private static final int defMonth = 1;
    private static final int defDay = 1;
    private static final int defHour = 0;
    private static final int defMinute = 0;
    private static final int defSecond = 0;
    private static final ImageIcon arrowUp = new ImageIcon(DatePanel.class.getResource("/edu/uml/lgdc/images/Plus5x5.gif"));
    private static final ImageIcon arrowDown = new ImageIcon(DatePanel.class.getResource("/edu/uml/lgdc/images/Minus5x5.gif"));
    private static Color activeDateBrickForegroundColor = Color.white;
    private static Color activeDateBrickBackgroundColor = new Color(0, 0, 200);
    private static Color inactiveDateBrickForegroundColor = Color.black;
    private static Color inactiveDateBrickBackgroundColor = Color.white;
    private boolean isHoursUsed = false;
    private boolean isMinutesUsed = false;
    private boolean isSecondsUsed = false;
    private ButtonPressedMonitor buttonPressedMonitor = null;
    private int yearOK;
    private int monthOK;
    private int dayOK;
    private int hourOK;
    private int minuteOK;
    private int secondOK;
    private int yearCurr;
    private int monthCurr;
    private int dayCurr;
    private int hourCurr;
    private int minuteCurr;
    private int secondCurr;
    private boolean editable = true;
    private int whatIsCurrent = 0;
    private boolean painted = false;
    private boolean paintedByFocusGain = false;
    private boolean justGained = false;
    private int badEntry = -1;
    private boolean newTimeEntered = true;
    private PosIntegerField tfYear;
    private PosIntegerField tfMonth;
    private PosIntegerField tfDay;
    private JButton btnUp = new JButton();
    private JButton btnDown = new JButton();
    private PosIntegerField tfHour;
    private PosIntegerField tfMinute;
    private PosIntegerField tfSecond;
    private JPanel pnlControl = new JPanel();
    private BorderLayout borderLayout6 = new BorderLayout();
    private JLabel lblSpace = new JLabel();
    private JLabel lblDash = new JLabel();
    private FlowLayout flowLayout1 = new FlowLayout(1, 0, 0);

    public DatePanel() {
        this(new TimeScale((double)System.currentTimeMillis() / 60000.0));
    }

    public DatePanel(TimeScale time) {
        this(time, true);
    }

    public DatePanel(TimeScale time, boolean useHours) {
        this(time, useHours, true);
    }

    public DatePanel(TimeScale time, boolean useHours, boolean useMinutes) {
        this(time, useHours, useMinutes, false);
    }

    public DatePanel(TimeScale time, boolean useHours, boolean useMinutes, boolean useSeconds) {
        if (time == null) {
            time = new TimeScale();
        }
        int year = time.get(1);
        int month = time.get(2) + 1;
        int day = time.get(5);
        if (!useHours) {
            useMinutes = false;
        }
        if (!useMinutes) {
            useSeconds = false;
        }
        int hour = useHours ? time.get(11) : -999999;
        int minute = useMinutes ? time.get(12) : -999999;
        int second = useSeconds ? time.get(13) : -999999;
        this.createIt(year, month, day, hour, minute, second);
    }

    public DatePanel(int year, int month, int day) {
        this(year, month, day, -999999, -999999);
    }

    public DatePanel(int year, int month, int day, int hour, int minute) {
        this(year, month, day, hour, minute, -999999);
    }

    public DatePanel(int year, int month, int day, int hour, int minute, int second) {
        this.createIt(year, month, day, hour, minute, second);
    }

    private void createIt(int year, int month, int day, int hour, int minute, int second) {
        this.tfYear = new PosIntegerField();
        this.tfMonth = new PosIntegerField();
        this.tfDay = new PosIntegerField();
        this.tfHour = new PosIntegerField();
        this.tfMinute = new PosIntegerField();
        this.tfSecond = new PosIntegerField();
        this.setDate(year, month, day, hour, minute, second);
        this.guiInit();
        this.initFields();
    }

    public void excludeKeystrokes(KeyStroke[] excludedKeystrokes) {
        this.tfYear.excludeKeystrokes(excludedKeystrokes);
        this.tfMonth.excludeKeystrokes(excludedKeystrokes);
        this.tfDay.excludeKeystrokes(excludedKeystrokes);
        this.tfHour.excludeKeystrokes(excludedKeystrokes);
        this.tfMinute.excludeKeystrokes(excludedKeystrokes);
        this.tfSecond.excludeKeystrokes(excludedKeystrokes);
    }

    void guiInit() {
        this.tfYear.setText("2000");
        this.tfYear.setHorizontalAlignment(0);
        this.tfYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatePanel.this.generateExternal_actionPerformed(e);
            }
        });
        this.tfYear.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                DatePanel.this.tfYear_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DatePanel.this.tfYear_keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DatePanel.this.tfYear_keyReleased(e);
            }
        });
        this.tfYear.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DatePanel.this.tfYear_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DatePanel.this.tfYear_focusLost(e);
            }
        });
        this.tfMonth.setText("09");
        this.tfMonth.setHorizontalAlignment(0);
        this.tfMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatePanel.this.generateExternal_actionPerformed(e);
            }
        });
        this.tfMonth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                DatePanel.this.tfMonth_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DatePanel.this.tfMonth_keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DatePanel.this.tfMonth_keyReleased(e);
            }
        });
        this.tfMonth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DatePanel.this.tfMonth_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DatePanel.this.tfMonth_focusLost(e);
            }
        });
        this.tfDay.setText("28");
        this.tfDay.setHorizontalAlignment(0);
        this.tfDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatePanel.this.generateExternal_actionPerformed(e);
            }
        });
        this.tfDay.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                DatePanel.this.tfDay_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DatePanel.this.tfDay_keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DatePanel.this.tfDay_keyReleased(e);
            }
        });
        this.tfDay.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DatePanel.this.tfDay_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DatePanel.this.tfDay_focusLost(e);
            }
        });
        this.tfHour.setText("00");
        this.tfHour.setHorizontalAlignment(0);
        this.tfHour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatePanel.this.generateExternal_actionPerformed(e);
            }
        });
        this.tfHour.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                DatePanel.this.tfHour_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DatePanel.this.tfHour_keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DatePanel.this.tfHour_keyReleased(e);
            }
        });
        this.tfHour.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DatePanel.this.tfHour_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DatePanel.this.tfHour_focusLost(e);
            }
        });
        this.tfMinute.setText("00");
        this.tfMinute.setHorizontalAlignment(0);
        this.tfMinute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatePanel.this.generateExternal_actionPerformed(e);
            }
        });
        this.tfMinute.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                DatePanel.this.tfMinute_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DatePanel.this.tfMinute_keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DatePanel.this.tfMinute_keyReleased(e);
            }
        });
        this.tfMinute.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DatePanel.this.tfMinute_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DatePanel.this.tfMinute_focusLost(e);
            }
        });
        this.tfSecond.setText("00");
        this.tfSecond.setHorizontalAlignment(0);
        this.tfSecond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatePanel.this.generateExternal_actionPerformed(e);
            }
        });
        this.tfSecond.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                DatePanel.this.tfSecond_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DatePanel.this.tfSecond_keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DatePanel.this.tfSecond_keyReleased(e);
            }
        });
        this.tfSecond.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DatePanel.this.tfSecond_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DatePanel.this.tfSecond_focusLost(e);
            }
        });
        this.btnUp.setBorder(raisedBevelBorder);
        this.btnUp.setIcon(arrowUp);
        this.btnUp.setPreferredSize(new Dimension(12, 9));
        this.btnUp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DatePanel.this.btnUp_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DatePanel.this.btnUp_focusLost(e);
            }
        });
        this.btnUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DatePanel.this.btnUp_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DatePanel.this.btnUp_mouseReleased(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DatePanel.this.btnUp_mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DatePanel.this.btnUp_mouseExited(e);
            }
        });
        this.btnDown.setBorder(raisedBevelBorder);
        this.btnDown.setIcon(arrowDown);
        this.btnDown.setPreferredSize(new Dimension(12, 9));
        this.btnDown.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DatePanel.this.btnDown_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DatePanel.this.btnDown_focusLost(e);
            }
        });
        this.btnDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DatePanel.this.btnDown_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DatePanel.this.btnDown_mouseReleased(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DatePanel.this.btnDown_mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DatePanel.this.btnDown_mouseExited(e);
            }
        });
        this.lblDash.setText(" - ");
        this.flowLayout1.setVgap(1);
        this.pnlControl.setLayout(this.borderLayout6);
        this.pnlControl.add((Component)this.btnUp, "North");
        this.pnlControl.add((Component)this.btnDown, "Center");
        BoxLayout boxLayout = new BoxLayout(this, 0);
        this.setLayout(boxLayout);
        this.setBorder(lineBorder);
        this.add(this.lblSpace);
        this.add(this.tfYear);
        this.add(this.tfMonth);
        this.add(this.tfDay);
        this.add(this.lblDash);
        this.add(this.tfHour);
        this.add(this.tfMinute);
        this.add(this.tfSecond);
        this.add(this.pnlControl);
    }

    public boolean checkOK() {
        return this.checkOK(false);
    }

    private boolean checkOK(boolean internalCall) {
        boolean result = true;
        try {
            int year = this.year2Number(this.tfYear.getText());
            int month = this.month2Number(this.tfMonth.getText());
            int day = this.day2Number(this.tfDay.getText());
            int hour = this.hour2Number(this.tfHour.getText());
            int minute = this.minute2Number(this.tfMinute.getText());
            int second = this.second2Number(this.tfSecond.getText());
            this.checkYearMonthDay(year, month, day);
            if (this.isHoursUsed) {
                this.checkHour(hour);
            }
            if (this.isMinutesUsed) {
                this.checkMinute(minute);
            }
            if (this.isSecondsUsed) {
                this.checkSecond(second);
            }
            this.yearOK = year;
            this.monthOK = month;
            this.dayOK = day;
            this.hourOK = hour;
            this.minuteOK = minute;
            this.secondOK = second;
            this.yearCurr = this.yearOK;
            this.monthCurr = this.monthOK;
            this.dayCurr = this.dayOK;
            this.hourCurr = this.hourOK;
            this.minuteCurr = this.minuteOK;
            this.secondCurr = this.secondOK;
        }
        catch (ParseException ex) {
            result = false;
        }
        catch (IllegalDateException ex) {
            result = false;
        }
        return result;
    }

    public TimeScale getDate() {
        int year = this.getYear();
        int month = this.getMonth() - 1;
        int day = this.getDay();
        int hour = this.getHour();
        int minute = this.getMinute();
        int second = this.getSecond();
        return new TimeScale(year, month, day, hour, minute, second);
    }

    public int getYear() {
        return this.yearOK;
    }

    public int getMonth() {
        return this.monthOK;
    }

    public int getDay() {
        return this.dayOK;
    }

    public int getHour() {
        return this.isHoursUsed ? this.hourOK : 0;
    }

    public int getMinute() {
        return this.isMinutesUsed ? this.minuteOK : 0;
    }

    public int getSecond() {
        return this.isSecondsUsed ? this.secondOK : 0;
    }

    public void setDate(int year, int month, int day, int hour, int minute) {
        this.setDate(year, month, day, hour, minute, -999999);
    }

    public void setDate(int year, int month, int day, int hour, int minute, int second) {
        try {
            this.checkYearMonthDay(year, month, day);
            this.yearCurr = year;
            this.monthCurr = month;
            this.dayCurr = day;
            this.yearOK = year;
            this.monthOK = month;
            this.dayOK = day;
        }
        catch (IllegalDateException ex) {
            System.out.println(ex.getMessage());
            System.out.println("  Default values will be used");
            this.yearOK = 2000;
            this.monthOK = 1;
            this.dayOK = 1;
        }
        if (hour != -999999) {
            this.isHoursUsed = true;
            if (hour < 0 || hour > 23) {
                System.out.println("Error: illegal hours");
                System.out.println("  Default values will be used");
                hour = 0;
            }
        } else {
            this.isHoursUsed = false;
            minute = -999999;
        }
        this.hourCurr = hour;
        this.hourOK = hour;
        if (minute != -999999) {
            this.isMinutesUsed = true;
            if (minute < 0 || minute > 59) {
                System.out.println("Error: illegal minutes");
                System.out.println("  Default values will be used");
                minute = 0;
            }
        } else {
            this.isMinutesUsed = false;
            second = -999999;
        }
        this.minuteCurr = minute;
        this.minuteOK = minute;
        if (second != -999999) {
            this.isSecondsUsed = true;
            if (second < 0 || second > 59) {
                System.out.println("Error: illegal seconds");
                System.out.println("  Default values will be used");
                second = 0;
            }
        } else {
            this.isSecondsUsed = false;
        }
        this.secondCurr = second;
        this.secondOK = second;
        this.draw();
    }

    public void setDate(TimeScale date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        int hour = this.isHoursUsed ? date.get(11) : 0;
        int minute = this.isMinutesUsed ? date.get(12) : 0;
        int second = this.isSecondsUsed ? date.get(13) : 0;
        this.setDate(year, month, day, hour, minute, second);
    }

    public void clearBorder() {
        this.removeBorder();
    }

    public void removeBorder() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public void setEnable(boolean flag) {
        Draw.setEnabled(this, flag);
    }

    public void setEditable(boolean flag) {
        this.editable = flag;
        this.tfYear.setEditable(flag);
        this.tfMonth.setEditable(flag);
        this.tfDay.setEditable(flag);
        this.tfHour.setEditable(flag);
        this.tfMinute.setEditable(flag);
        this.tfSecond.setEditable(flag);
        Draw.setEnabled(this.pnlControl, flag);
    }

    @Override
    public void requestFocus() {
        this.tfYear.requestFocus();
    }

    void increaseYear() {
        this.increaseYear(-1);
    }

    void increaseYear(int year) {
        boolean illegalYMDCombination = false;
        if (year == -1) {
            try {
                year = this.getYearWithCorrection(1);
            }
            catch (ParseException ex) {
                return;
            }
        } else {
            ++year;
        }
        try {
            this.tfYear.setText(this.year2Str(year, true));
        }
        catch (IllegalYearException ex) {
        }
        catch (IllegalYearMonthDayCombinationException e) {
            illegalYMDCombination = true;
        }
        if (illegalYMDCombination) {
            try {
                this.tfYear.setText(this.year2Str(year));
            }
            catch (IllegalDateException illegalDateException) {
                // empty catch block
            }
            this.drawDay(this.getMaxDaysPerMonth(Integer.parseInt(this.tfYear.getText()), Integer.parseInt(this.tfMonth.getText())));
        }
    }

    void decreaseYear() {
        this.decreaseYear(-1);
    }

    void decreaseYear(int year) {
        boolean illegalYMDCombination = false;
        if (year == -1) {
            try {
                year = this.getYearWithCorrection(2);
            }
            catch (ParseException ex) {
                return;
            }
        } else {
            --year;
        }
        try {
            this.tfYear.setText(this.year2Str(year, true));
        }
        catch (IllegalYearException ex) {
        }
        catch (IllegalYearMonthDayCombinationException e) {
            illegalYMDCombination = true;
        }
        if (illegalYMDCombination) {
            try {
                this.tfYear.setText(this.year2Str(year));
            }
            catch (IllegalDateException illegalDateException) {
                // empty catch block
            }
            this.drawDay(this.getMaxDaysPerMonth(Integer.parseInt(this.tfYear.getText()), Integer.parseInt(this.tfMonth.getText())));
        }
    }

    void increaseMonth() {
        this.increaseMonth(-1);
    }

    void increaseMonth(int month) {
        boolean illegalYMDCombination = false;
        if (month == -1) {
            try {
                month = this.getMonthWithCorrection(1);
            }
            catch (ParseException ex) {
                return;
            }
        } else {
            ++month;
        }
        try {
            this.tfMonth.setText(this.month2Str(month, true));
        }
        catch (IllegalMonthException ex) {
        }
        catch (IllegalYearMonthDayCombinationException e) {
            illegalYMDCombination = true;
        }
        if (illegalYMDCombination) {
            try {
                this.tfMonth.setText(this.month2Str(month));
            }
            catch (IllegalDateException illegalDateException) {
                // empty catch block
            }
            this.drawDay(this.getMaxDaysPerMonth(Integer.parseInt(this.tfYear.getText()), Integer.parseInt(this.tfMonth.getText())));
        }
    }

    void decreaseMonth() {
        this.decreaseMonth(-1);
    }

    void decreaseMonth(int month) {
        boolean illegalYMDCombination = false;
        if (month == -1) {
            try {
                month = this.getMonthWithCorrection(2);
            }
            catch (ParseException ex) {
                return;
            }
        } else {
            --month;
        }
        try {
            this.tfMonth.setText(this.month2Str(month, true));
        }
        catch (IllegalMonthException ex) {
        }
        catch (IllegalYearMonthDayCombinationException e) {
            illegalYMDCombination = true;
        }
        if (illegalYMDCombination) {
            try {
                this.tfMonth.setText(this.month2Str(month));
            }
            catch (IllegalDateException illegalDateException) {
                // empty catch block
            }
            this.drawDay(this.getMaxDaysPerMonth(Integer.parseInt(this.tfYear.getText()), Integer.parseInt(this.tfMonth.getText())));
        }
    }

    void increaseDay() {
        int day;
        boolean illegalYMDCombination = false;
        try {
            day = this.getDayWithCorrection(1);
        }
        catch (ParseException ex) {
            return;
        }
        try {
            this.tfDay.setText(this.day2Str(day, true));
        }
        catch (IllegalDayException ex) {
        }
        catch (IllegalYearMonthDayCombinationException e) {
            illegalYMDCombination = true;
        }
        if (illegalYMDCombination) {
            try {
                this.tfDay.setText(this.day2Str(day));
            }
            catch (IllegalDateException illegalDateException) {
                // empty catch block
            }
            this.increaseDay();
        }
    }

    void decreaseDay() {
        int day;
        boolean illegalYMDCombination = false;
        try {
            day = this.getDayWithCorrection(2);
        }
        catch (ParseException ex) {
            return;
        }
        try {
            this.tfDay.setText(this.day2Str(day, true));
        }
        catch (IllegalDayException ex) {
        }
        catch (IllegalYearMonthDayCombinationException e) {
            illegalYMDCombination = true;
        }
        if (illegalYMDCombination) {
            try {
                this.tfDay.setText(this.day2Str(day));
            }
            catch (IllegalDateException illegalDateException) {
                // empty catch block
            }
            this.decreaseDay();
        }
    }

    void increaseHour() {
        int hour;
        try {
            hour = this.getHourWithCorrection(1);
        }
        catch (ParseException ex) {
            return;
        }
        try {
            this.tfHour.setText(this.hour2Str(hour));
        }
        catch (IllegalHourException illegalHourException) {
            // empty catch block
        }
    }

    void decreaseHour() {
        int hour;
        try {
            hour = this.getHourWithCorrection(2);
        }
        catch (ParseException ex) {
            return;
        }
        try {
            this.tfHour.setText(this.hour2Str(hour));
        }
        catch (IllegalHourException illegalHourException) {
            // empty catch block
        }
    }

    void increaseMinute() {
        int minute;
        try {
            minute = this.getMinuteWithCorrection(1);
        }
        catch (ParseException ex) {
            return;
        }
        try {
            this.tfMinute.setText(this.minute2Str(minute));
        }
        catch (IllegalMinuteException illegalMinuteException) {
            // empty catch block
        }
    }

    void decreaseMinute() {
        int minute;
        try {
            minute = this.getMinuteWithCorrection(2);
        }
        catch (ParseException ex) {
            return;
        }
        try {
            this.tfMinute.setText(this.minute2Str(minute));
        }
        catch (IllegalMinuteException illegalMinuteException) {
            // empty catch block
        }
    }

    void increaseSecond() {
        int second;
        try {
            second = this.getSecondWithCorrection(1);
        }
        catch (ParseException ex) {
            return;
        }
        try {
            this.tfSecond.setText(this.second2Str(second));
        }
        catch (IllegalSecondException illegalSecondException) {
            // empty catch block
        }
    }

    void decreaseSecond() {
        int second;
        try {
            second = this.getSecondWithCorrection(2);
        }
        catch (ParseException ex) {
            return;
        }
        try {
            this.tfSecond.setText(this.second2Str(second));
        }
        catch (IllegalSecondException illegalSecondException) {
            // empty catch block
        }
    }

    private void initFields() {
        try {
            this.tfYear.setText(this.year2Str(this.yearOK));
            this.tfMonth.setText(this.month2Str(this.monthOK));
            this.tfDay.setText(this.day2Str(this.dayOK));
            if (!this.isSecondsUsed) {
                this.remove(this.tfSecond);
            } else {
                this.tfSecond.setText(this.second2Str(this.secondOK));
            }
            if (!this.isMinutesUsed) {
                this.remove(this.tfMinute);
            } else {
                this.tfMinute.setText(this.minute2Str(this.minuteOK));
            }
            if (!this.isHoursUsed) {
                this.remove(this.tfHour);
                this.remove(this.lblDash);
            } else {
                this.tfHour.setText(this.hour2Str(this.hourOK));
            }
            this.yearCurr = this.yearOK;
            this.monthCurr = this.monthOK;
            this.dayCurr = this.dayOK;
            this.hourCurr = this.hourOK;
            this.minuteCurr = this.minuteOK;
            this.secondCurr = this.secondOK;
        }
        catch (IllegalYearException illegalYearException) {
        }
        catch (IllegalMonthException illegalMonthException) {
        }
        catch (IllegalDayException illegalDayException) {
        }
        catch (IllegalHourException illegalHourException) {
        }
        catch (IllegalMinuteException illegalMinuteException) {
        }
        catch (IllegalSecondException illegalSecondException) {
        }
        catch (IllegalYearMonthDayCombinationException illegalYearMonthDayCombinationException) {
            // empty catch block
        }
    }

    private int getYearWithCorrection(int convertMode) throws ParseException {
        int year;
        boolean exception;
        block7: {
            exception = false;
            try {
                year = this.year2Number(this.tfYear.getText(), true);
            }
            catch (IllegalDateException e) {
                year = Integer.parseInt(this.tfYear.getText().trim());
                exception = true;
                if (year < 1) {
                    year = 1;
                }
                if (year <= 3000) break block7;
                year = 3000;
            }
        }
        if (!exception) {
            if (convertMode == 2) {
                --year;
            } else if (convertMode == 1) {
                ++year;
            }
        }
        return year;
    }

    private boolean checkYearField() {
        return this.checkYearField(null);
    }

    private boolean checkYearField(String cVal) {
        boolean result = true;
        int year = -1;
        String errorMsg = null;
        boolean noDraw = true;
        if (cVal == null) {
            cVal = this.tfYear.getText();
            if (cVal.trim().length() == 0) {
                cVal = "2000";
            }
            noDraw = false;
        }
        try {
            year = this.year2Number(cVal);
        }
        catch (ParseException e) {
            errorMsg = e.getMessage();
        }
        catch (IllegalDateException e) {
            errorMsg = e.getMessage();
            errorMsg = String.valueOf(errorMsg) + "\nType Esc to return the old value";
        }
        if (errorMsg != null) {
            result = false;
        } else {
            this.yearCurr = year;
            if (!noDraw) {
                this.drawYear(year);
            }
        }
        return result;
    }

    private int getMonthWithCorrection(int convertMode) throws ParseException {
        int month;
        boolean exception;
        block8: {
            exception = false;
            try {
                month = this.month2Number(this.tfMonth.getText(), true);
            }
            catch (IllegalDateException e) {
                month = Integer.parseInt(this.tfMonth.getText().trim());
                exception = true;
                if (month < 1) {
                    month = 1;
                }
                if (month <= 12) break block8;
                month = 12;
            }
        }
        if (!exception) {
            if (convertMode == 2) {
                if (--month < 1) {
                    month = 12;
                }
            } else if (convertMode == 1 && ++month > 12) {
                month = 1;
            }
        }
        return month;
    }

    private boolean checkMonthField() {
        return this.checkMonthField(null);
    }

    private boolean checkMonthField(String cVal) {
        boolean result = true;
        int month = -1;
        String errorMsg = null;
        boolean noDraw = true;
        if (cVal == null) {
            cVal = this.tfMonth.getText();
            if (cVal.trim().length() == 0) {
                cVal = "01";
            }
            noDraw = false;
        }
        try {
            month = this.month2Number(cVal);
        }
        catch (ParseException e) {
            errorMsg = e.getMessage();
        }
        catch (IllegalDateException e) {
            errorMsg = e.getMessage();
            errorMsg = String.valueOf(errorMsg) + "\nType Esc to return the old value";
        }
        if (errorMsg != null) {
            result = false;
        } else {
            this.monthCurr = month;
            if (!noDraw) {
                this.drawMonth(month);
            }
        }
        return result;
    }

    private int getDayWithCorrection(int convertMode) throws ParseException {
        int day;
        boolean exception;
        block8: {
            exception = false;
            try {
                day = this.day2Number(this.tfDay.getText(), true);
            }
            catch (IllegalDateException e) {
                day = Integer.parseInt(this.tfDay.getText().trim());
                exception = true;
                if (day < 1) {
                    day = 1;
                }
                if (day <= this.getMaxDaysPerMonth()) break block8;
                day = this.getMaxDaysPerMonth();
            }
        }
        if (!exception) {
            if (convertMode == 2) {
                if (--day < 1) {
                    day = this.getMaxDaysPerMonth();
                }
            } else if (convertMode == 1 && ++day > this.getMaxDaysPerMonth()) {
                day = 1;
            }
        }
        return day;
    }

    private boolean checkDayField() {
        return this.checkDayField(null);
    }

    private boolean checkDayField(String cVal) {
        boolean result = true;
        int day = -1;
        String errorMsg = null;
        boolean noDraw = true;
        if (cVal == null) {
            cVal = this.tfDay.getText();
            if (cVal.trim().length() == 0) {
                cVal = "01";
            }
            noDraw = false;
        }
        try {
            day = this.day2Number(cVal, true);
        }
        catch (ParseException e) {
            errorMsg = e.getMessage();
        }
        catch (IllegalDateException e) {
            errorMsg = e.getMessage();
            errorMsg = String.valueOf(errorMsg) + "\nType Esc to return the old value";
        }
        if (errorMsg != null) {
            result = false;
        } else {
            this.dayCurr = day;
            if (!noDraw) {
                this.drawDay(day);
            }
        }
        return result;
    }

    private int getHourWithCorrection(int convertMode) throws ParseException {
        int hour;
        boolean exception;
        block8: {
            exception = false;
            try {
                hour = this.hour2Number(this.tfHour.getText());
            }
            catch (IllegalHourException e) {
                hour = Integer.parseInt(this.tfHour.getText().trim());
                exception = true;
                if (hour < 0) {
                    hour = 0;
                }
                if (hour <= 23) break block8;
                hour = 23;
            }
        }
        if (!exception) {
            if (convertMode == 2) {
                if (--hour < 0) {
                    hour = 23;
                }
            } else if (convertMode == 1 && ++hour > 23) {
                hour = 0;
            }
        }
        return hour;
    }

    private boolean checkHourField() {
        return this.checkHourField(null);
    }

    private boolean checkHourField(String cVal) {
        boolean result = true;
        int hour = -1;
        String errorMsg = null;
        boolean noDraw = true;
        if (cVal == null) {
            cVal = this.tfHour.getText();
            if (cVal.trim().length() == 0) {
                cVal = "00";
            }
            noDraw = false;
        }
        try {
            hour = this.hour2Number(cVal);
        }
        catch (ParseException e) {
            errorMsg = e.getMessage();
        }
        catch (IllegalHourException e) {
            errorMsg = e.getMessage();
            errorMsg = String.valueOf(errorMsg) + "\nType Esc to return the old value";
        }
        if (errorMsg != null) {
            result = false;
        } else {
            this.hourCurr = hour;
            if (!noDraw) {
                this.drawHour(hour);
            }
        }
        return result;
    }

    private int getMinuteWithCorrection(int convertMode) throws ParseException {
        int minute;
        boolean exception;
        block8: {
            exception = false;
            try {
                minute = this.minute2Number(this.tfMinute.getText());
            }
            catch (IllegalMinuteException e) {
                minute = Integer.parseInt(this.tfMinute.getText().trim());
                exception = true;
                if (minute < 0) {
                    minute = 0;
                }
                if (minute <= 59) break block8;
                minute = 59;
            }
        }
        if (!exception) {
            if (convertMode == 2) {
                if (--minute < 0) {
                    minute = 59;
                }
            } else if (convertMode == 1 && ++minute > 59) {
                minute = 0;
            }
        }
        return minute;
    }

    private boolean checkMinuteField() {
        return this.checkMinuteField(null);
    }

    private boolean checkMinuteField(String cVal) {
        boolean result = true;
        int minute = -1;
        String errorMsg = null;
        boolean noDraw = true;
        if (cVal == null) {
            cVal = this.tfMinute.getText();
            if (cVal.trim().length() == 0) {
                cVal = "00";
            }
            noDraw = false;
        }
        try {
            minute = this.minute2Number(cVal);
        }
        catch (ParseException e) {
            errorMsg = e.getMessage();
        }
        catch (IllegalMinuteException e) {
            errorMsg = e.getMessage();
            errorMsg = String.valueOf(errorMsg) + "\nType Esc to return the old value";
        }
        if (errorMsg != null) {
            result = false;
        } else {
            this.minuteCurr = minute;
            if (!noDraw) {
                this.drawMinute(minute);
            }
        }
        return result;
    }

    private int getSecondWithCorrection(int convertMode) throws ParseException {
        int second;
        boolean exception;
        block8: {
            exception = false;
            try {
                second = this.second2Number(this.tfSecond.getText());
            }
            catch (IllegalSecondException e) {
                second = Integer.parseInt(this.tfSecond.getText().trim());
                exception = true;
                if (second < 0) {
                    second = 0;
                }
                if (second <= 59) break block8;
                second = 59;
            }
        }
        if (!exception) {
            if (convertMode == 2) {
                if (--second < 0) {
                    second = 59;
                }
            } else if (convertMode == 1 && ++second > 59) {
                second = 0;
            }
        }
        return second;
    }

    private boolean checkSecondField() {
        return this.checkSecondField(null);
    }

    private boolean checkSecondField(String cVal) {
        boolean result = true;
        int second = -1;
        String errorMsg = null;
        boolean noDraw = true;
        if (cVal == null) {
            cVal = this.tfSecond.getText();
            if (cVal.trim().length() == 0) {
                cVal = "00";
            }
            noDraw = false;
        }
        try {
            second = this.second2Number(cVal);
        }
        catch (ParseException e) {
            errorMsg = e.getMessage();
        }
        catch (IllegalSecondException e) {
            errorMsg = e.getMessage();
            errorMsg = String.valueOf(errorMsg) + "\nType Esc to return the old value";
        }
        if (errorMsg != null) {
            result = false;
        } else {
            this.secondCurr = second;
            if (!noDraw) {
                this.drawSecond(second);
            }
        }
        return result;
    }

    private void draw() {
        this.draw(this.yearOK, this.monthOK, this.dayOK, this.hourOK, this.minuteOK, this.secondOK);
    }

    private void draw(int year, int month, int day, int hour, int minute, int second) {
        this.draw(year, month, day);
        if (this.isHoursUsed) {
            this.drawHour(hour);
        }
        if (this.isMinutesUsed) {
            this.drawMinute(minute);
        }
        if (this.isSecondsUsed) {
            this.drawSecond(second);
        }
    }

    private void draw(int year, int month, int day) {
        this.drawYear(year);
        this.drawMonth(month);
        this.drawDay(day);
    }

    private void drawYear(int year) {
        try {
            this.tfYear.setText(this.year2Str(year));
        }
        catch (IllegalDateException illegalDateException) {
            // empty catch block
        }
    }

    private void drawMonth(int month) {
        try {
            this.tfMonth.setText(this.month2Str(month));
        }
        catch (IllegalDateException illegalDateException) {
            // empty catch block
        }
    }

    private void drawDay(int day) {
        try {
            this.tfDay.setText(this.day2Str(day));
        }
        catch (IllegalDateException illegalDateException) {
            // empty catch block
        }
    }

    private void drawHour(int hour) {
        try {
            this.tfHour.setText(this.hour2Str(hour));
        }
        catch (IllegalHourException illegalHourException) {
            // empty catch block
        }
    }

    private void drawMinute(int minute) {
        try {
            this.tfMinute.setText(this.minute2Str(minute));
        }
        catch (IllegalMinuteException illegalMinuteException) {
            // empty catch block
        }
    }

    private void drawSecond(int second) {
        try {
            this.tfSecond.setText(this.second2Str(second));
        }
        catch (IllegalSecondException illegalSecondException) {
            // empty catch block
        }
    }

    private int year2Number() {
        int year = -1;
        try {
            year = this.year2Number(this.tfYear.getText());
        }
        catch (ParseException parseException) {
        }
        catch (IllegalYearException illegalYearException) {
        }
        catch (IllegalYearMonthDayCombinationException illegalYearMonthDayCombinationException) {
            // empty catch block
        }
        return year;
    }

    private int year2Number(String yearStr) throws ParseException, IllegalYearException, IllegalYearMonthDayCombinationException {
        return this.year2Number(yearStr, false);
    }

    private int year2Number(String yearStr, boolean fullCheck) throws ParseException, IllegalYearException, IllegalYearMonthDayCombinationException {
        int year = -9999;
        yearStr = yearStr.trim();
        this.checkForIllegalSymbols(yearStr);
        year = Integer.parseInt(yearStr);
        this.checkYear(year, fullCheck);
        return year;
    }

    private String year2Str(int year) throws IllegalYearException, IllegalYearMonthDayCombinationException {
        return this.year2Str(year, false);
    }

    private String year2Str(int year, boolean fullCheck) throws IllegalYearException, IllegalYearMonthDayCombinationException {
        String yearStr = null;
        this.checkYear(year, fullCheck);
        yearStr = "" + year;
        return yearStr.replace(' ', '0');
    }

    private int month2Number() {
        int month = -1;
        try {
            month = this.month2Number(this.tfMonth.getText());
        }
        catch (ParseException parseException) {
        }
        catch (IllegalMonthException illegalMonthException) {
        }
        catch (IllegalYearMonthDayCombinationException illegalYearMonthDayCombinationException) {
            // empty catch block
        }
        return month;
    }

    private int month2Number(String monthStr) throws ParseException, IllegalMonthException, IllegalYearMonthDayCombinationException {
        return this.month2Number(monthStr, false);
    }

    private int month2Number(String monthStr, boolean fullCheck) throws ParseException, IllegalMonthException, IllegalYearMonthDayCombinationException {
        int month = -99;
        monthStr = monthStr.trim();
        this.checkForIllegalSymbols(monthStr);
        month = Integer.parseInt(monthStr);
        this.checkMonth(month, fullCheck);
        return month;
    }

    private String month2Str(int month) throws IllegalMonthException, IllegalYearMonthDayCombinationException {
        return this.month2Str(month, false);
    }

    private String month2Str(int month, boolean fullCheck) throws IllegalMonthException, IllegalYearMonthDayCombinationException {
        String monthStr = null;
        this.checkMonth(month, fullCheck);
        monthStr = Formatter.padLeft("" + month, 2, '0');
        return monthStr;
    }

    private int day2Number() {
        int day = -1;
        try {
            day = this.day2Number(this.tfDay.getText());
        }
        catch (ParseException parseException) {
        }
        catch (IllegalDayException illegalDayException) {
        }
        catch (IllegalYearMonthDayCombinationException illegalYearMonthDayCombinationException) {
            // empty catch block
        }
        return day;
    }

    private int day2Number(String dayStr) throws ParseException, IllegalDayException, IllegalYearMonthDayCombinationException {
        return this.day2Number(dayStr, false);
    }

    private int day2Number(String dayStr, boolean fullCheck) throws ParseException, IllegalDayException, IllegalYearMonthDayCombinationException {
        int day = -99;
        dayStr = dayStr.trim();
        this.checkForIllegalSymbols(dayStr);
        day = Integer.parseInt(dayStr);
        this.checkDay(day, fullCheck);
        return day;
    }

    private String day2Str(int day) throws IllegalDayException, IllegalYearMonthDayCombinationException {
        return this.day2Str(day, false);
    }

    private String day2Str(int day, boolean fullCheck) throws IllegalDayException, IllegalYearMonthDayCombinationException {
        this.checkDay(day, fullCheck);
        return Formatter.padLeft("" + day, 2, '0');
    }

    private int hour2Number(String hourStr) throws ParseException, IllegalHourException {
        int hour = -99;
        hourStr = hourStr.trim();
        this.checkForIllegalSymbols(hourStr);
        hour = Integer.parseInt(hourStr);
        this.checkHour(hour);
        return hour;
    }

    private String hour2Str(int hour) throws IllegalHourException {
        this.checkHour(hour);
        return Formatter.padLeft("" + hour, 2, '0');
    }

    private int minute2Number(String minuteStr) throws ParseException, IllegalMinuteException {
        int minute = -99;
        minuteStr = minuteStr.trim();
        this.checkForIllegalSymbols(minuteStr);
        minute = Integer.parseInt(minuteStr);
        this.checkMinute(minute);
        return minute;
    }

    private String minute2Str(int minute) throws IllegalMinuteException {
        this.checkMinute(minute);
        return Formatter.padLeft("" + minute, 2, '0');
    }

    private int second2Number(String secondStr) throws ParseException, IllegalSecondException {
        int second = -99;
        secondStr = secondStr.trim();
        this.checkForIllegalSymbols(secondStr);
        second = Integer.parseInt(secondStr);
        this.checkSecond(second);
        return second;
    }

    private String second2Str(int second) throws IllegalSecondException {
        this.checkSecond(second);
        return Formatter.padLeft("" + second, 2, '0');
    }

    private void checkForIllegalSymbols(String digitStr) throws ParseException {
        int i = 0;
        while (i < digitStr.length()) {
            char ch = digitStr.charAt(i);
            if (ch < '0' || ch > '9') {
                throw new ParseException("Illegal symbol - " + ch, i);
            }
            ++i;
        }
    }

    private void checkYear(int year, boolean fullCheck) throws IllegalYearException, IllegalYearMonthDayCombinationException {
        if (year <= 0 || year >= 3000) {
            throw new IllegalYearException();
        }
        if (fullCheck) {
            int month = Integer.parseInt(this.tfMonth.getText());
            int day = Integer.parseInt(this.tfDay.getText());
            this.checkYMDCombination(day, month, year);
        }
    }

    private void checkMonth(int month, boolean fullCheck) throws IllegalMonthException, IllegalYearMonthDayCombinationException {
        if (month < 1 || month > 12) {
            throw new IllegalMonthException();
        }
        if (fullCheck) {
            int year = Integer.parseInt(this.tfYear.getText());
            int day = Integer.parseInt(this.tfDay.getText());
            this.checkYMDCombination(day, month, year);
        }
    }

    private void checkDay(int day, boolean fullCheck) throws IllegalDayException, IllegalYearMonthDayCombinationException {
        if (day < 1 || day > 31) {
            throw new IllegalDayException();
        }
        if (fullCheck) {
            int year = Integer.parseInt(this.tfYear.getText());
            int month = Integer.parseInt(this.tfMonth.getText());
            this.checkYMDCombination(day, month, year);
        }
    }

    private void checkYMDCombination(int day, int month, int year) throws IllegalYearMonthDayCombinationException {
        if (day < 1 || day > this.getMaxDaysPerMonth(year, month)) {
            throw new IllegalYearMonthDayCombinationException();
        }
    }

    private boolean checkYMD() {
        boolean result = false;
        int year = this.year2Number();
        int month = this.month2Number();
        int day = this.day2Number();
        if (year != 1 && month != -1 && day != -1) {
            result = true;
            try {
                this.checkYMDCombination(day, month, year);
            }
            catch (IllegalYearMonthDayCombinationException e) {
                result = false;
            }
        }
        return result;
    }

    private void checkYearMonthDay(int year, int month, int day) throws IllegalYearException, IllegalMonthException, IllegalDayException, IllegalYearMonthDayCombinationException {
        this.checkYear(year, false);
        this.checkMonth(month, false);
        this.checkDay(day, false);
        this.checkYMDCombination(day, month, year);
    }

    private void checkHour(int hour) throws IllegalHourException {
        if (hour < 0 || hour > 23) {
            throw new IllegalHourException();
        }
    }

    private void checkMinute(int minute) throws IllegalMinuteException {
        if (minute < 0 || minute > 59) {
            throw new IllegalMinuteException();
        }
    }

    private void checkSecond(int second) throws IllegalSecondException {
        if (second < 0 || second > 59) {
            throw new IllegalSecondException();
        }
    }

    private int getMaxDaysPerMonth() {
        int year = Integer.parseInt(this.tfYear.getText().trim());
        int month = Integer.parseInt(this.tfMonth.getText().trim());
        return this.getMaxDaysPerMonth(year, month);
    }

    private int getMaxDaysPerMonth(int year, int month) {
        int qty = 28;
        if (month != 2) {
            qty = maxDaysPerMonth[month - 1];
        } else if (tm.isLeapYear(year)) {
            qty = 29;
        }
        return qty;
    }

    private void returnFocusToField() {
        switch (this.whatIsCurrent) {
            case 0: {
                this.tfYear.requestFocus();
                break;
            }
            case 1: {
                this.tfMonth.requestFocus();
                break;
            }
            case 2: {
                this.tfDay.requestFocus();
                break;
            }
            case 3: {
                this.tfHour.requestFocus();
                break;
            }
            case 4: {
                this.tfMinute.requestFocus();
                break;
            }
            case 5: {
                this.tfSecond.requestFocus();
            }
        }
    }

    private void paintDateBrick() {
        if (!this.painted) {
            this.paintDateBrick(activeDateBrickForegroundColor, activeDateBrickBackgroundColor);
            this.painted = true;
        }
    }

    private void unpaintDateBrick() {
        if (this.painted) {
            this.paintDateBrick(inactiveDateBrickForegroundColor, inactiveDateBrickBackgroundColor);
            this.painted = false;
        }
    }

    private void paintDateBrick(Color foreground, Color background) {
        if (!this.editable) {
            return;
        }
        PosIntegerField dateBrick = null;
        switch (this.whatIsCurrent) {
            case 0: {
                dateBrick = this.tfYear;
                break;
            }
            case 1: {
                dateBrick = this.tfMonth;
                break;
            }
            case 2: {
                dateBrick = this.tfDay;
                break;
            }
            case 3: {
                dateBrick = this.tfHour;
                break;
            }
            case 4: {
                dateBrick = this.tfMinute;
                break;
            }
            case 5: {
                dateBrick = this.tfSecond;
            }
        }
        if (dateBrick != null) {
            dateBrick.setCaretColor(foreground);
            dateBrick.setForeground(foreground);
            dateBrick.setBackground(background);
        }
    }

    public void startIncrease() {
        if (this.editable) {
            this.startIncDec(6);
        }
    }

    public void stopIncrease() {
        if (this.editable) {
            this.stopIncDec();
        }
    }

    public void startDecrease() {
        if (this.editable) {
            this.startIncDec(7);
        }
    }

    public void stopDecrease() {
        if (this.editable) {
            this.stopIncDec();
        }
    }

    private void startIncDec(int direction) {
        if (this.buttonPressedMonitor != null) {
            this.buttonPressedMonitor.stop = true;
        }
        this.buttonPressedMonitor = new ButtonPressedMonitor(this, this.whatIsCurrent, direction);
        new Thread(this.buttonPressedMonitor).start();
    }

    private void stopIncDec() {
        if (this.buttonPressedMonitor != null) {
            this.buttonPressedMonitor.stop = true;
        }
        this.returnFocusToField();
    }

    private void restorePreviousValue(JTextField tf) {
        try {
            if (tf == this.tfYear) {
                tf.setText(this.year2Str(this.yearCurr));
            } else if (tf == this.tfMonth) {
                tf.setText(this.month2Str(this.monthCurr));
            } else if (tf == this.tfDay) {
                tf.setText(this.day2Str(this.dayCurr));
            } else if (tf == this.tfHour) {
                tf.setText(this.hour2Str(this.hourCurr));
            } else if (tf == this.tfMinute) {
                tf.setText(this.minute2Str(this.minuteCurr));
            } else if (tf == this.tfSecond) {
                tf.setText(this.second2Str(this.secondCurr));
            }
        }
        catch (IllegalYearException illegalYearException) {
        }
        catch (IllegalMonthException illegalMonthException) {
        }
        catch (IllegalDayException illegalDayException) {
        }
        catch (IllegalHourException illegalHourException) {
        }
        catch (IllegalMinuteException illegalMinuteException) {
        }
        catch (IllegalSecondException illegalSecondException) {
        }
        catch (IllegalYearMonthDayCombinationException illegalYearMonthDayCombinationException) {
            // empty catch block
        }
    }

    private void requestFocusForNextBrick() {
        switch (this.whatIsCurrent) {
            case 0: {
                this.tfMonth.requestFocus();
                break;
            }
            case 1: {
                this.tfDay.requestFocus();
                break;
            }
            case 2: {
                if (this.isHoursUsed) {
                    this.tfHour.requestFocus();
                    break;
                }
                this.tfYear.requestFocus();
                break;
            }
            case 3: {
                if (this.isMinutesUsed) {
                    this.tfMinute.requestFocus();
                    break;
                }
                this.tfYear.requestFocus();
                break;
            }
            case 4: {
                if (this.isSecondsUsed) {
                    this.tfSecond.requestFocus();
                    break;
                }
                this.tfYear.requestFocus();
                break;
            }
            case 5: {
                this.tfYear.requestFocus();
            }
        }
    }

    private void requestFocusForPreviousBrick() {
        switch (this.whatIsCurrent) {
            case 0: {
                if (!this.isHoursUsed) {
                    this.tfDay.requestFocus();
                    break;
                }
                if (!this.isMinutesUsed) {
                    this.tfHour.requestFocus();
                    break;
                }
                if (!this.isSecondsUsed) {
                    this.tfMinute.requestFocus();
                    break;
                }
                this.tfSecond.requestFocus();
                break;
            }
            case 1: {
                this.tfYear.requestFocus();
                break;
            }
            case 2: {
                this.tfMonth.requestFocus();
                break;
            }
            case 3: {
                this.tfDay.requestFocus();
                break;
            }
            case 4: {
                this.tfHour.requestFocus();
                break;
            }
            case 5: {
                this.tfMinute.requestFocus();
            }
        }
    }

    private int getFieldLength(JTextField tf) {
        return tf == this.tfYear ? 4 : 2;
    }

    private void keyTyped(JTextField tf, KeyEvent e) {
        this.newTimeEntered = true;
        char c = e.getKeyChar();
        char key = e.getKeyChar();
        if (key == '\u001b') {
            this.restorePreviousValue(tf);
        } else if (c == '+' || c == '-') {
            e.consume();
        } else if (!this.justGained && tf.getText().length() >= this.getFieldLength(tf) || !Character.isISOControl(c) && !Character.isDigit(c)) {
            e.consume();
            this.getToolkit().beep();
        } else {
            if (this.justGained && Character.isDigit(c)) {
                tf.setText("");
            }
            this.justGained = false;
            boolean canMove = false;
            String cVal = null;
            if (Character.isDigit(c)) {
                cVal = String.valueOf(tf.getText()) + c;
                if (cVal.length() == this.getFieldLength(tf)) {
                    if (this.checkField(cVal)) {
                        canMove = true;
                    } else {
                        e.consume();
                        this.getToolkit().beep();
                    }
                } else {
                    int minVal;
                    int val = Integer.parseInt(cVal);
                    if (val >= (minVal = this.getMinValWeCanMoveToNextField())) {
                        canMove = true;
                    }
                }
            }
            if (!canMove) {
                this.unpaintDateBrick();
            } else {
                tf.setText(cVal);
                e.consume();
                this.requestFocusForNextBrick();
            }
        }
    }

    private void keyPressed(JTextField tf, KeyEvent e) {
        this.newTimeEntered = true;
        char c = e.getKeyChar();
        int key = e.getKeyCode();
        if (c == '+') {
            this.startIncrease();
        } else if (c == '-') {
            this.startDecrease();
        } else if (key == 37 || key == 39 || key == 36 || key == 35 || key == 38 || key == 40 || key == 127) {
            this.justGained = false;
            this.unpaintDateBrick();
            if (key == 39 && this.canMoveToNext(tf)) {
                this.requestFocusForNextBrick();
            } else if (key == 37 && tf.getCaretPosition() == 0) {
                this.requestFocusForPreviousBrick();
            }
        }
    }

    private boolean canMoveToNext(JTextField tf) {
        boolean canMove = false;
        int maxLen = this.getFieldLength(tf);
        int len = tf.getText().length();
        int caretPos = tf.getCaretPosition();
        if (caretPos == len) {
            int minVal;
            int val;
            if (len == maxLen) {
                canMove = true;
            } else if (len == maxLen - 1 && (val = Integer.parseInt(tf.getText())) >= (minVal = this.getMinValWeCanMoveToNextField())) {
                canMove = true;
            }
        }
        return canMove;
    }

    private boolean checkField(String cVal) {
        boolean result = false;
        switch (this.whatIsCurrent) {
            case 0: {
                result = this.checkYearField(cVal);
                break;
            }
            case 1: {
                result = this.checkMonthField(cVal);
                break;
            }
            case 2: {
                result = this.checkDayField(cVal);
                break;
            }
            case 3: {
                result = this.checkHourField(cVal);
                break;
            }
            case 4: {
                result = this.checkMinuteField(cVal);
                break;
            }
            case 5: {
                result = this.checkSecondField(cVal);
            }
        }
        return result;
    }

    private int getMinValWeCanMoveToNextField() {
        int minVal = -1;
        switch (this.whatIsCurrent) {
            case 0: {
                minVal = 300;
                break;
            }
            case 1: {
                minVal = 2;
                break;
            }
            case 2: {
                minVal = 4;
                break;
            }
            case 3: {
                minVal = 3;
                break;
            }
            case 4: {
                minVal = 6;
                break;
            }
            case 5: {
                minVal = 6;
            }
        }
        return minVal;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char c = e.getKeyChar();
        if (c == '+') {
            this.stopIncrease();
        } else if (c == '-') {
            this.stopDecrease();
        }
    }

    private void btnUp_mousePressed(MouseEvent e) {
        if (!this.editable) {
            return;
        }
        if (this.btnUp.isEnabled()) {
            this.startIncrease();
            this.btnUp.setBorder(loweredBevelBorder);
        }
    }

    private void btnUp_mouseReleased(MouseEvent e) {
        if (!this.editable) {
            return;
        }
        if (this.btnUp.isEnabled()) {
            this.stopIncrease();
            this.btnUp.setBorder(raisedBevelBorder);
        }
        this.newTimeEntered = true;
    }

    private void btnDown_mousePressed(MouseEvent e) {
        if (!this.editable) {
            return;
        }
        if (this.btnDown.isEnabled()) {
            this.startDecrease();
            this.btnDown.setBorder(loweredBevelBorder);
        }
    }

    private void btnDown_mouseReleased(MouseEvent e) {
        if (!this.editable) {
            return;
        }
        if (this.btnDown.isEnabled()) {
            this.stopDecrease();
            this.btnDown.setBorder(raisedBevelBorder);
        }
        this.newTimeEntered = true;
    }

    private void tfYear_keyPressed(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyPressed(this.tfYear, e);
    }

    private void tfYear_keyReleased(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyReleased(e);
    }

    private void tfMonth_keyPressed(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyPressed(this.tfMonth, e);
    }

    private void tfMonth_keyReleased(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyReleased(e);
    }

    private void tfDay_keyPressed(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyPressed(this.tfDay, e);
    }

    private void tfDay_keyReleased(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyReleased(e);
    }

    private void tfHour_keyPressed(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyPressed(this.tfHour, e);
    }

    private void tfHour_keyReleased(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyReleased(e);
    }

    private void tfMinute_keyPressed(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyPressed(this.tfMinute, e);
    }

    private void tfMinute_keyReleased(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyReleased(e);
    }

    private void tfSecond_keyPressed(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyPressed(this.tfSecond, e);
    }

    private void tfSecond_keyReleased(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyReleased(e);
    }

    private void tfYear_focusGained(FocusEvent e) {
        this.isFocused = true;
        if (this.badEntry == -1 || this.badEntry == 0) {
            this.whatIsCurrent = 0;
            this.justGained = true;
            if (this.badEntry != 0) {
                this.paintedByFocusGain = true;
                this.paintDateBrick();
            }
            this.runFocusMonitor();
            this.badEntry = -1;
        } else {
            this.whatIsCurrent = this.badEntry;
            this.returnFocusToField();
        }
    }

    private void tfYear_focusLost(FocusEvent e) {
        this.unpaintDateBrick();
        this.paintedByFocusGain = false;
        if (this.badEntry == -1) {
            if (!this.checkYearField()) {
                this.badEntry = 0;
                this.getToolkit().beep();
            } else if (!this.checkYMD()) {
                this.drawDay(this.getMaxDaysPerMonth(Integer.parseInt(this.tfYear.getText()), Integer.parseInt(this.tfMonth.getText())));
            }
        }
        this.isFocused = false;
    }

    private void tfMonth_focusGained(FocusEvent e) {
        this.isFocused = true;
        if (this.badEntry == -1 || this.badEntry == 1) {
            this.whatIsCurrent = 1;
            this.justGained = true;
            if (this.badEntry != 1) {
                this.paintedByFocusGain = true;
                this.paintDateBrick();
            }
            this.runFocusMonitor();
            this.badEntry = -1;
        } else {
            this.whatIsCurrent = this.badEntry;
            this.returnFocusToField();
        }
    }

    private void tfMonth_focusLost(FocusEvent e) {
        this.unpaintDateBrick();
        this.paintedByFocusGain = false;
        if (this.badEntry == -1) {
            if (!this.checkMonthField()) {
                this.getToolkit().beep();
                this.badEntry = 1;
            } else if (!this.checkYMD()) {
                this.drawDay(this.getMaxDaysPerMonth(Integer.parseInt(this.tfYear.getText()), Integer.parseInt(this.tfMonth.getText())));
            }
        }
        this.isFocused = false;
    }

    private void tfDay_focusGained(FocusEvent e) {
        this.isFocused = true;
        if (this.badEntry == -1 || this.badEntry == 2) {
            this.whatIsCurrent = 2;
            this.justGained = true;
            if (this.badEntry != 2) {
                this.paintedByFocusGain = true;
                this.paintDateBrick();
            }
            this.runFocusMonitor();
            this.badEntry = -1;
        } else {
            this.whatIsCurrent = this.badEntry;
            this.returnFocusToField();
        }
    }

    private void tfDay_focusLost(FocusEvent e) {
        this.unpaintDateBrick();
        this.paintedByFocusGain = false;
        if (this.badEntry == -1 && !this.checkDayField()) {
            this.badEntry = 2;
            this.getToolkit().beep();
        }
        this.isFocused = false;
    }

    private void tfHour_focusGained(FocusEvent e) {
        this.isFocused = true;
        if (this.badEntry == -1 || this.badEntry == 3) {
            this.whatIsCurrent = 3;
            this.justGained = true;
            if (this.badEntry != 3) {
                this.paintedByFocusGain = true;
                this.paintDateBrick();
            }
            this.runFocusMonitor();
        } else {
            this.whatIsCurrent = this.badEntry;
            this.returnFocusToField();
        }
    }

    private void tfHour_focusLost(FocusEvent e) {
        this.unpaintDateBrick();
        this.paintedByFocusGain = false;
        if (this.badEntry == -1 && !this.checkHourField()) {
            this.badEntry = 3;
            this.getToolkit().beep();
        }
        this.isFocused = false;
    }

    private void tfMinute_focusGained(FocusEvent e) {
        this.isFocused = true;
        if (this.badEntry == -1 || this.badEntry == 4) {
            this.whatIsCurrent = 4;
            this.justGained = true;
            if (this.badEntry != 4) {
                this.paintedByFocusGain = true;
                this.paintDateBrick();
            }
            this.runFocusMonitor();
        } else {
            this.whatIsCurrent = this.badEntry;
            this.returnFocusToField();
        }
    }

    private void tfMinute_focusLost(FocusEvent e) {
        this.unpaintDateBrick();
        this.paintedByFocusGain = false;
        if (this.badEntry == -1 && !this.checkMinuteField()) {
            this.badEntry = 4;
            this.getToolkit().beep();
        }
        this.isFocused = false;
    }

    private void tfSecond_focusGained(FocusEvent e) {
        this.isFocused = true;
        if (this.badEntry == -1 || this.badEntry == 5) {
            this.whatIsCurrent = 5;
            this.justGained = true;
            if (this.badEntry != 5) {
                this.paintedByFocusGain = true;
                this.paintDateBrick();
            }
            this.runFocusMonitor();
        } else {
            this.whatIsCurrent = this.badEntry;
            this.returnFocusToField();
        }
    }

    private void tfSecond_focusLost(FocusEvent e) {
        this.unpaintDateBrick();
        this.paintedByFocusGain = false;
        if (this.badEntry == -1 && !this.checkSecondField()) {
            this.badEntry = 5;
            this.getToolkit().beep();
        }
        this.isFocused = false;
    }

    private void tfYear_keyTyped(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyTyped(this.tfYear, e);
    }

    private void tfMonth_keyTyped(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyTyped(this.tfMonth, e);
    }

    private void tfDay_keyTyped(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyTyped(this.tfDay, e);
    }

    private void tfHour_keyTyped(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyTyped(this.tfHour, e);
    }

    private void tfMinute_keyTyped(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyTyped(this.tfMinute, e);
    }

    private void tfSecond_keyTyped(KeyEvent e) {
        if (!this.editable) {
            return;
        }
        this.keyTyped(this.tfSecond, e);
    }

    private void btnUp_mouseEntered(MouseEvent e) {
        if (this.btnUp.isEnabled()) {
            this.paintDateBrick();
        }
    }

    private void btnUp_mouseExited(MouseEvent e) {
        if (this.btnUp.isEnabled() && !this.paintedByFocusGain) {
            this.unpaintDateBrick();
        }
    }

    private void btnDown_mouseEntered(MouseEvent e) {
        if (this.btnDown.isEnabled()) {
            this.paintDateBrick();
        }
    }

    private void btnDown_mouseExited(MouseEvent e) {
        if (this.btnDown.isEnabled() && !this.paintedByFocusGain) {
            this.unpaintDateBrick();
        }
    }

    private void btnUp_focusGained(FocusEvent e) {
        if (this.btnUp.isEnabled()) {
            this.isFocused = true;
            this.runFocusMonitor();
        }
    }

    private void btnUp_focusLost(FocusEvent e) {
        if (this.btnUp.isEnabled()) {
            this.isFocused = false;
        }
    }

    private void btnDown_focusGained(FocusEvent e) {
        if (this.btnDown.isEnabled()) {
            this.isFocused = true;
            this.runFocusMonitor();
        }
    }

    private void btnDown_focusLost(FocusEvent e) {
        if (this.btnDown.isEnabled()) {
            this.isFocused = false;
        }
    }

    public boolean isNewTimeEntered() {
        return this.newTimeEntered;
    }

    public void clearNewTimeEnteredFlag() {
        this.newTimeEntered = false;
    }

    private static class ButtonPressedMonitor
    implements Runnable {
        private DatePanel datePanel;
        private int mode;
        boolean stop = false;

        ButtonPressedMonitor(DatePanel datePanel, int who, int direction) {
            this.datePanel = datePanel;
            this.mode = this.getMode(who, direction);
        }

        @Override
        public void run() {
            this.startMonitorProcess();
        }

        private void startMonitorProcess() {
            int waitInMilliseconds = 400;
            while (!this.stop) {
                switch (this.mode) {
                    case 0: {
                        this.datePanel.increaseYear();
                        break;
                    }
                    case 1: {
                        this.datePanel.decreaseYear();
                        break;
                    }
                    case 2: {
                        this.datePanel.increaseMonth();
                        break;
                    }
                    case 3: {
                        this.datePanel.decreaseMonth();
                        break;
                    }
                    case 4: {
                        this.datePanel.increaseDay();
                        break;
                    }
                    case 5: {
                        this.datePanel.decreaseDay();
                        break;
                    }
                    case 6: {
                        this.datePanel.increaseHour();
                        break;
                    }
                    case 7: {
                        this.datePanel.decreaseHour();
                        break;
                    }
                    case 8: {
                        this.datePanel.increaseMinute();
                        break;
                    }
                    case 9: {
                        this.datePanel.decreaseMinute();
                        break;
                    }
                    case 10: {
                        this.datePanel.increaseSecond();
                        break;
                    }
                    case 11: {
                        this.datePanel.decreaseSecond();
                    }
                }
                try {
                    Thread.sleep(waitInMilliseconds);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (waitInMilliseconds <= 10) continue;
                waitInMilliseconds = (int)((double)waitInMilliseconds / 1.3);
            }
        }

        private int getMode(int who, int direction) {
            int mode = -1;
            if (direction == 6) {
                switch (who) {
                    case 0: {
                        mode = 0;
                        break;
                    }
                    case 1: {
                        mode = 2;
                        break;
                    }
                    case 2: {
                        mode = 4;
                        break;
                    }
                    case 3: {
                        mode = 6;
                        break;
                    }
                    case 4: {
                        mode = 8;
                        break;
                    }
                    case 5: {
                        mode = 10;
                    }
                }
            } else if (direction == 7) {
                switch (who) {
                    case 0: {
                        mode = 1;
                        break;
                    }
                    case 1: {
                        mode = 3;
                        break;
                    }
                    case 2: {
                        mode = 5;
                        break;
                    }
                    case 3: {
                        mode = 7;
                        break;
                    }
                    case 4: {
                        mode = 9;
                        break;
                    }
                    case 5: {
                        mode = 11;
                    }
                }
            }
            return mode;
        }
    }

    private static class IllegalDateException
    extends Exception {
        public IllegalDateException(String msg) {
            super(msg);
        }
    }

    private static class IllegalDayException
    extends IllegalDateException {
        public IllegalDayException() {
            super("Illegal day");
        }
    }

    private static class IllegalHourException
    extends IllegalDateException {
        public IllegalHourException() {
            super("Illegal hour");
        }
    }

    private static class IllegalMinuteException
    extends IllegalDateException {
        public IllegalMinuteException() {
            super("Illegal minute");
        }
    }

    private static class IllegalMonthException
    extends IllegalDateException {
        public IllegalMonthException() {
            super("Illegal month");
        }
    }

    private static class IllegalSecondException
    extends IllegalDateException {
        public IllegalSecondException() {
            super("Illegal second");
        }
    }

    private static class IllegalYearException
    extends IllegalDateException {
        public IllegalYearException() {
            super("Illegal year");
        }
    }

    private static class IllegalYearMonthDayCombinationException
    extends IllegalDateException {
        public IllegalYearMonthDayCombinationException() {
            super("Illegal year/month/day combination");
        }
    }
}

