/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.gui.FocusMonitor;
import edu.uml.lgdc.gui.FocusMonitoredObject;
import edu.uml.lgdc.gui.UIDef;
import edu.uml.lgdc.gui.panels.DatePanel;
import edu.uml.lgdc.time.TimeScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DateRangePanel
extends JPanel
implements FocusMonitoredObject {
    public static final int HORIZONTAL_LAYOUT = 0;
    public static final int VERTICAL_LAYOUT = 1;
    private static final Border TITLE_BORDER = BorderFactory.createTitledBorder(" Time Interval, UT ");
    private String txtFrom = "from";
    private String txtTo = "to";
    private int layout = 0;
    private boolean useLabels = true;
    private boolean useHours;
    private FlowLayout flowLayout = new FlowLayout(1, 0, 0);
    private JLabel lblFrom = new JLabel();
    private JLabel lblTo = new JLabel();
    private DatePanel pnlStart;
    private DatePanel pnlEnd;
    private BorderLayout borderLayout = new BorderLayout(0, 0);
    private FlowLayout flowLayoutUpper = new FlowLayout(0, 0, 0);
    private FlowLayout flowLayoutBottom = new FlowLayout(0, 0, 0);
    private JPanel pnlUpper = new JPanel(this.flowLayoutUpper);
    private JPanel pnlBottom = new JPanel(this.flowLayoutBottom);
    private ActionEvent actionEvent = null;
    private FocusEvent focusEvent = null;
    private boolean isFocused = false;
    private FocusMonitor focusMonitor = null;

    public DateRangePanel() {
        this(new TimeScale().startOfYear());
    }

    public DateRangePanel(TimeScale start) {
        this(start, new TimeScale());
    }

    public DateRangePanel(TimeScale start, TimeScale end) {
        this(start, end, false);
    }

    public DateRangePanel(TimeScale start, TimeScale end, boolean useHours) {
        this(start, end, useHours, false);
    }

    public DateRangePanel(TimeScale start, TimeScale end, boolean useHours, boolean useMinutes) {
        if (start == null) {
            start = new TimeScale().startOfYear();
        }
        if (end == null) {
            end = new TimeScale();
        }
        this.pnlStart = new DatePanel(start, useHours, useMinutes);
        this.pnlEnd = new DatePanel(end, useHours, useMinutes);
        this.useHours = useHours;
        this.pnlStart.removeBorder();
        this.pnlEnd.removeBorder();
        if (end.before(start)) {
            start = new TimeScale().startOfYear();
            end = new TimeScale();
            this.pnlStart = new DatePanel(start, useHours, useMinutes);
            this.pnlEnd = new DatePanel(end, useHours, useMinutes);
        }
        this.guiInit();
    }

    private void guiInit() {
        this.lblTo.setText(this.txtTo);
        this.lblTo.setHorizontalAlignment(0);
        this.pnlStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePanel.this.actionOKFired(e);
            }
        });
        this.pnlStart.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DateRangePanel.this.pnlStart_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DateRangePanel.this.pnlStart_focusLost(e);
            }
        });
        this.pnlEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePanel.this.actionOKFired(e);
            }
        });
        this.pnlEnd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DateRangePanel.this.pnlEnd_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DateRangePanel.this.pnlEnd_focusLost(e);
            }
        });
        this.flowLayout.setHgap(4);
        this.flowLayout.setVgap(1);
        this.lblFrom.setText(this.txtFrom);
        this.borderLayout.setVgap(0);
        this.setLayout(this.flowLayout);
        this.setBorder(TITLE_BORDER);
        this.add(this.lblFrom);
        this.add(this.pnlStart);
        this.add(this.lblTo);
        this.add(this.pnlEnd);
    }

    public void setCompactSize() {
        this.lblFrom.setVisible(false);
        this.lblTo.setText("-");
    }

    public void setNominalSize() {
        this.lblFrom.setVisible(true);
        this.lblTo.setText("to");
    }

    public void setNegativeImage(Color backgroundColor) {
        this.setBackground(backgroundColor);
        this.pnlStart.setBackground(backgroundColor);
        this.pnlEnd.setBackground(backgroundColor);
        this.lblFrom.setForeground(Color.white);
        this.lblTo.setForeground(Color.white);
    }

    public void setNominalImage() {
        Color bg = UIDef.getPanelBackground(Color.LIGHT_GRAY);
        this.setBackground(bg);
        this.pnlStart.setBackground(bg);
        this.pnlEnd.setBackground(bg);
        this.lblFrom.setForeground(Color.WHITE);
        this.lblTo.setForeground(Color.WHITE);
    }

    public TimeScale getStart() {
        return this.pnlStart.getDate();
    }

    public TimeScale getEnd() {
        return this.pnlEnd.getDate();
    }

    public void setStart(TimeScale date) {
        this.pnlStart.setDate(date);
    }

    public void setEnd(TimeScale date) {
        this.pnlEnd.setDate(date);
    }

    public boolean checkOK() {
        boolean result = true;
        if (!this.pnlStart.checkOK()) {
            result = false;
        }
        if (!this.pnlEnd.checkOK()) {
            result = false;
        }
        return result && (this.pnlStart.getDate().equals(this.pnlEnd.getDate()) || this.pnlStart.getDate().before(this.pnlEnd.getDate()));
    }

    public DatePanel getStartPanel() {
        return this.pnlStart;
    }

    public DatePanel getEndPanel() {
        return this.pnlEnd;
    }

    public boolean getUseHours() {
        return this.useHours;
    }

    public void setEnable(boolean flag) {
        Draw.setEnabled(this, flag);
    }

    @Override
    public void requestFocus() {
        this.pnlStart.requestFocus();
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ActionListener.class) {
                if (this.actionEvent == null) {
                    this.actionEvent = new ActionEvent(this, 1001, "SET");
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(this.actionEvent);
            }
            i -= 2;
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this.listenerList.add(FocusListener.class, l);
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        this.listenerList.remove(FocusListener.class, l);
    }

    @Override
    public void fireFocusGained() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == FocusListener.class) {
                if (this.focusEvent == null) {
                    this.focusEvent = new FocusEvent(this, 1004, false);
                }
                ((FocusListener)listeners[i + 1]).focusGained(this.focusEvent);
            }
            i -= 2;
        }
    }

    @Override
    public void fireFocusLost() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == FocusListener.class) {
                if (this.focusEvent == null) {
                    this.focusEvent = new FocusEvent(this, 1005, false);
                }
                ((FocusListener)listeners[i + 1]).focusLost(this.focusEvent);
            }
            i -= 2;
        }
    }

    @Override
    public boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public void focusMonitorExit() {
        this.focusMonitor = null;
    }

    public void clearBorder() {
        this.removeBorder();
    }

    public void removeBorder() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public void enableLabels(boolean flag) {
        if (flag != this.useLabels) {
            this.setTextInLabels();
            if (flag) {
                if (this.layout == 0) {
                    this.remove(this.pnlStart);
                    this.remove(this.pnlEnd);
                    this.add(this.lblFrom);
                    this.add(this.pnlStart);
                    this.add(this.lblTo);
                    this.add(this.pnlEnd);
                } else {
                    this.remove(this.pnlStart);
                    this.remove(this.pnlEnd);
                    this.pnlUpper.add(this.lblFrom);
                    this.pnlUpper.add(this.pnlStart);
                    this.pnlBottom.add(this.lblTo);
                    this.pnlBottom.add(this.pnlEnd);
                    this.add((Component)this.pnlUpper, "North");
                    this.add((Component)this.pnlBottom, "Center");
                }
            } else if (this.layout == 0) {
                this.remove(this.lblFrom);
                this.remove(this.lblTo);
            } else {
                this.pnlUpper.remove(this.lblFrom);
                this.pnlUpper.remove(this.pnlStart);
                this.pnlBottom.remove(this.lblTo);
                this.pnlBottom.remove(this.pnlEnd);
                this.remove(this.pnlUpper);
                this.remove(this.pnlBottom);
                this.add((Component)this.pnlStart, "North");
                this.add((Component)this.pnlEnd, "Center");
            }
            this.useLabels = flag;
        }
    }

    public void setLayout(int layout) {
        if (layout != this.layout && this.isLayoutLegal(layout)) {
            this.setTextInLabels(layout);
            if (layout == 0) {
                if (this.useLabels) {
                    this.pnlUpper.remove(this.lblFrom);
                    this.pnlUpper.remove(this.pnlStart);
                    this.pnlBottom.remove(this.lblTo);
                    this.pnlBottom.remove(this.pnlEnd);
                    this.remove(this.pnlUpper);
                    this.remove(this.pnlBottom);
                } else {
                    this.remove(this.pnlStart);
                    this.remove(this.pnlEnd);
                }
                this.setLayout(this.flowLayout);
                if (this.useLabels) {
                    this.add(this.lblFrom);
                }
                this.add(this.pnlStart);
                if (this.useLabels) {
                    this.add(this.lblTo);
                }
                this.add(this.pnlEnd);
            } else if (layout == 1) {
                if (this.useLabels) {
                    this.remove(this.lblFrom);
                    this.remove(this.lblTo);
                }
                this.remove(this.pnlStart);
                this.remove(this.pnlEnd);
                if (this.useLabels) {
                    this.pnlUpper.add(this.lblFrom);
                    this.pnlUpper.add(this.pnlStart);
                    this.pnlBottom.add(this.lblTo);
                    this.pnlBottom.add(this.pnlEnd);
                }
                this.setLayout(this.borderLayout);
                if (this.useLabels) {
                    this.add((Component)this.pnlUpper, "North");
                    this.add((Component)this.pnlBottom, "Center");
                } else {
                    this.add((Component)this.pnlStart, "North");
                    this.add((Component)this.pnlEnd, "Center");
                }
            }
            this.layout = layout;
        }
    }

    public void setLabels(String from, String to) {
        this.txtFrom = from == null ? "" : from;
        this.txtTo = to == null ? "" : to;
        this.setTextInLabels();
    }

    private void setTextInLabels() {
        this.setTextInLabels(this.layout);
    }

    private void setTextInLabels(int layout) {
        if (this.isLayoutLegal(layout)) {
            if (layout == 0) {
                if (this.txtFrom.length() > 0) {
                    this.lblFrom.setText(String.valueOf(this.txtFrom) + " ");
                } else {
                    this.lblFrom.setText("");
                }
                if (this.txtTo.length() > 0) {
                    this.lblTo.setText(" " + this.txtTo + " ");
                } else {
                    this.lblTo.setText("");
                }
            } else if (layout == 1) {
                if (this.txtFrom.length() > 0 || this.txtTo.length() > 0) {
                    int len = Math.max(this.txtFrom.length(), this.txtTo.length());
                    this.lblFrom.setText(String.valueOf(Formatter.padLeft(this.txtFrom, len)) + " ");
                    this.lblTo.setText(String.valueOf(Formatter.padLeft(this.txtTo, len)) + " ");
                } else {
                    this.lblFrom.setText("");
                    this.lblTo.setText("");
                }
            }
        }
    }

    private boolean isLayoutLegal(int layout) {
        return layout == 0 || layout == 1;
    }

    private void runFocusMonitor() {
        if (this.focusMonitor == null) {
            this.focusMonitor = new FocusMonitor(this);
            new Thread(this.focusMonitor).start();
        }
    }

    private void actionOKFired(ActionEvent e) {
        this.actionEvent = new ActionEvent(this, 1001, "SET");
        this.fireActionPerformed();
    }

    private void pnlStart_focusGained(FocusEvent e) {
        this.isFocused = true;
        this.runFocusMonitor();
    }

    private void pnlStart_focusLost(FocusEvent e) {
        this.isFocused = false;
    }

    private void pnlEnd_focusGained(FocusEvent e) {
        this.isFocused = true;
        this.runFocusMonitor();
    }

    private void pnlEnd_focusLost(FocusEvent e) {
        this.isFocused = false;
    }
}

