/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.gui.FocusMonitor;
import edu.uml.lgdc.gui.FocusMonitoredObject;
import edu.uml.lgdc.gui.UIDef;
import edu.uml.lgdc.gui.panels.DateRangePanel;
import edu.uml.lgdc.time.TimeScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DateRangePanelDBtn
extends JPanel
implements FocusMonitoredObject {
    private static final Border TITLED_BORDER = BorderFactory.createTitledBorder(" Time Interval, UT ");
    private static final Border LINE_BORDER = BorderFactory.createLineBorder(Color.BLUE, 1);
    private boolean dayButtonAsOKEnable = false;
    private FlowLayout flowLayout = new FlowLayout(1, 0, 0);
    private DateRangePanel pnlDateRange = null;
    private JButton btnEqual = new JButton();
    private JButton btnOneHour = new JButton();
    private JButton btnOneDay = new JButton();
    private ActionEvent actionEvent = null;
    private FocusEvent focusEvent = null;
    private boolean isFocused = false;
    private FocusMonitor focusMonitor = null;

    public DateRangePanelDBtn() {
        this(new DateRangePanel());
    }

    public DateRangePanelDBtn(DateRangePanel pnlDateRange) {
        this.pnlDateRange = pnlDateRange;
        this.guiInit();
    }

    private void guiInit() {
        this.pnlDateRange.removeBorder();
        this.pnlDateRange.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DateRangePanelDBtn.this.pnlDateRange_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DateRangePanelDBtn.this.pnlDateRange_focusLost(e);
            }
        });
        this.pnlDateRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePanelDBtn.this.actionOKFired(e);
            }
        });
        this.btnEqual.setText(" = ");
        this.btnEqual.setMargin(new Insets(0, 0, 0, 0));
        this.btnEqual.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DateRangePanelDBtn.this.btnEqual_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DateRangePanelDBtn.this.btnEqual_focusLost(e);
            }
        });
        this.btnEqual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePanelDBtn.this.btnEqual_actionPerformed(e);
            }
        });
        this.btnOneHour.setText("+1h");
        this.btnOneHour.setMargin(new Insets(0, 0, 0, 0));
        this.btnOneHour.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DateRangePanelDBtn.this.btnOneHour_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DateRangePanelDBtn.this.btnOneHour_focusLost(e);
            }
        });
        this.btnOneHour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePanelDBtn.this.btnOneHour_actionPerformed(e);
            }
        });
        this.btnOneDay.setText("+1d");
        this.btnOneDay.setMargin(new Insets(0, 0, 0, 0));
        this.btnOneDay.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DateRangePanelDBtn.this.btnOneDay_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DateRangePanelDBtn.this.btnOneDay_focusLost(e);
            }
        });
        this.btnOneDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePanelDBtn.this.btnOneDay_actionPerformed(e);
            }
        });
        this.flowLayout.setHgap(5);
        this.flowLayout.setVgap(0);
        this.setLayout(this.flowLayout);
        this.setBorder(TITLED_BORDER);
        this.getInsets(new Insets(0, 0, 0, 0));
        this.add((Component)this.pnlDateRange, null);
        this.add((Component)this.btnEqual, null);
        if (this.pnlDateRange.getUseHours()) {
            this.add((Component)this.btnOneHour, null);
        }
        this.add((Component)this.btnOneDay, null);
    }

    public void removeBorder() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public void setCompactSize() {
        this.removeBorder();
        this.pnlDateRange.setCompactSize();
    }

    public void setNominalSize() {
        this.setBorder(LINE_BORDER);
        this.pnlDateRange.setNominalSize();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.pnlDateRange != null) {
            this.pnlDateRange.setBackground(color);
        }
    }

    public void setNegativeImage(Color background) {
        this.setBackground(background);
        this.pnlDateRange.setNegativeImage(background);
    }

    public void setNominalImage() {
        this.setBackground(UIDef.getPanelBackground(Color.LIGHT_GRAY));
        this.pnlDateRange.setNominalImage();
    }

    public TimeScale getStart() {
        return this.pnlDateRange.getStart();
    }

    public TimeScale getEnd() {
        return this.pnlDateRange.getEnd();
    }

    public void setStart(TimeScale date) {
        this.pnlDateRange.setStart(date);
    }

    public void setEnd(TimeScale date) {
        this.pnlDateRange.setEnd(date);
    }

    public boolean checkOK() {
        return this.pnlDateRange.checkOK();
    }

    public void setEnable(boolean flag) {
        Draw.setEnabled(this, flag);
    }

    @Override
    public void requestFocus() {
        this.pnlDateRange.requestFocus();
    }

    public void setDayButtonAsOKEnable(boolean flag) {
        this.dayButtonAsOKEnable = flag;
    }

    private void runFocusMonitor() {
        if (this.focusMonitor == null) {
            this.focusMonitor = new FocusMonitor(this);
            new Thread(this.focusMonitor).start();
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ActionListener.class) {
                if (this.actionEvent == null) {
                    this.actionEvent = new ActionEvent(this, 1001, "SET");
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(this.actionEvent);
            }
            i -= 2;
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        this.listenerList.add(FocusListener.class, l);
    }

    @Override
    public void removeFocusListener(FocusListener l) {
        this.listenerList.remove(FocusListener.class, l);
    }

    @Override
    public void fireFocusGained() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == FocusListener.class) {
                if (this.focusEvent == null) {
                    this.focusEvent = new FocusEvent(this, 1004, false);
                }
                ((FocusListener)listeners[i + 1]).focusGained(this.focusEvent);
            }
            i -= 2;
        }
    }

    @Override
    public void fireFocusLost() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == FocusListener.class) {
                if (this.focusEvent == null) {
                    this.focusEvent = new FocusEvent(this, 1005, false);
                }
                ((FocusListener)listeners[i + 1]).focusLost(this.focusEvent);
            }
            i -= 2;
        }
    }

    @Override
    public boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public void focusMonitorExit() {
        this.focusMonitor = null;
    }

    private void pnlDateRange_focusGained(FocusEvent e) {
        this.isFocused = true;
        this.runFocusMonitor();
    }

    private void pnlDateRange_focusLost(FocusEvent e) {
        this.isFocused = false;
    }

    private void actionOKFired(ActionEvent e) {
        this.actionEvent = new ActionEvent(this, 1001, "SET");
        this.fireActionPerformed();
    }

    private void btnEqual_focusGained(FocusEvent e) {
        this.isFocused = true;
        this.runFocusMonitor();
    }

    private void btnEqual_focusLost(FocusEvent e) {
        this.isFocused = false;
    }

    private void btnEqual_actionPerformed(ActionEvent e) {
        if (this.pnlDateRange.getStartPanel().checkOK()) {
            this.setEnd(new TimeScale(this.getStart().getTimeInMinutes() + 1.0));
            if (this.dayButtonAsOKEnable) {
                this.actionOKFired(null);
            }
        }
    }

    private void btnOneHour_focusGained(FocusEvent e) {
        this.isFocused = true;
        this.runFocusMonitor();
    }

    private void btnOneHour_focusLost(FocusEvent e) {
        this.isFocused = false;
    }

    private void btnOneHour_actionPerformed(ActionEvent e) {
        if (this.pnlDateRange.getStartPanel().isNewTimeEntered()) {
            if (this.pnlDateRange.getStartPanel().checkOK()) {
                this.setEnd(new TimeScale(this.getStart().getTimeInMinutes() + 60.0));
            }
            this.pnlDateRange.getStartPanel().clearNewTimeEnteredFlag();
        } else if (this.pnlDateRange.getEndPanel().checkOK()) {
            this.setEnd(new TimeScale(this.getEnd().getTimeInMinutes() + 60.0));
        }
        if (this.dayButtonAsOKEnable) {
            this.actionOKFired(null);
        }
    }

    private void btnOneDay_focusGained(FocusEvent e) {
        this.isFocused = true;
        this.runFocusMonitor();
    }

    private void btnOneDay_focusLost(FocusEvent e) {
        this.isFocused = false;
    }

    private void btnOneDay_actionPerformed(ActionEvent e) {
        if (this.pnlDateRange.getStartPanel().isNewTimeEntered()) {
            if (this.pnlDateRange.getStartPanel().checkOK()) {
                this.setEnd(new TimeScale(this.getStart().getTimeInMinutes() + 1440.0));
            }
            this.pnlDateRange.getStartPanel().clearNewTimeEnteredFlag();
        } else if (this.pnlDateRange.getEndPanel().checkOK()) {
            this.setEnd(new TimeScale(this.getEnd().getTimeInMinutes() + 1440.0));
        }
        if (this.dayButtonAsOKEnable) {
            this.actionOKFired(null);
        }
    }
}

