/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.gui.controls.PosIntegerField;
import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import edu.uml.lgdc.gui.settings.FileCacheSettings_Ix;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileCacheSettingsPanel
extends EventEnabledPanel {
    private static final int MAX_MAX_SIZE_GB = 99999;
    private FileCacheSettings_Ix options;
    private FileCacheSettings_Ix prevOptions;
    private boolean changed;
    private int prevMaxSize_Gb = 10;
    private GridLayout gridLayout = new GridLayout(0, 1);
    private JPanel pnlMaxSize_Gb = new JPanel();
    private JLabel lblMaxSize_Gb = new JLabel();
    private PosIntegerField tfMaxSize_Gb = new PosIntegerField();

    public FileCacheSettingsPanel() {
        this((FileCacheSettings_Ix)null);
    }

    public FileCacheSettingsPanel(FileCacheSettings_Ix options) {
        this.init(options);
    }

    public void setFields(FileCacheSettings_Ix options) {
        this.options = options;
        this.prevOptions = (FileCacheSettings_Ix)options.clone();
        this.changed = false;
        this.setText(this.tfMaxSize_Gb, "" + options.getMaxSize_Gb());
        Formatter.checkNumericFieldValue(this.tfMaxSize_Gb, 1, 99999, this.prevMaxSize_Gb);
    }

    private void init(FileCacheSettings_Ix options) {
        this.guiInit();
        if (options != null) {
            this.setFields(options);
        }
        this.requestFocus();
    }

    private void guiInit() {
        this.lblMaxSize_Gb.setText("Max Chache Size, Gb ");
        this.lblMaxSize_Gb.setLabelFor(this.tfMaxSize_Gb);
        this.tfMaxSize_Gb.setText("99999");
        this.tfMaxSize_Gb.setColumns("99999".length());
        this.tfMaxSize_Gb.setHorizontalAlignment(4);
        this.tfMaxSize_Gb.setToolTipText("Maximum size of disk cache, in gigabytes");
        this.tfMaxSize_Gb.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                FileCacheSettingsPanel.this.tfMaxSize_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                FileCacheSettingsPanel.this.tfMaxSize_focusLost(e);
            }
        });
        this.tfMaxSize_Gb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCacheSettingsPanel.this.tfMaxSize_actionPerformed(e);
            }
        });
        this.pnlMaxSize_Gb.setToolTipText("Queue size for Parser/Framer, has effect after reconnecting");
        this.pnlMaxSize_Gb.setLayout(new FlowLayout(0));
        this.pnlMaxSize_Gb.add(this.lblMaxSize_Gb);
        this.pnlMaxSize_Gb.add(this.tfMaxSize_Gb);
        this.setLayout(this.gridLayout);
        this.add(this.pnlMaxSize_Gb);
    }

    public void accept() {
        this.options.setMaxSize_Gb(Integer.parseInt(this.tfMaxSize_Gb.getText().trim()));
        this.changed = !this.options.equals(this.prevOptions);
    }

    public void reset() {
        this.setFields(this.options);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public FileCacheSettings_Ix getOptions() {
        return this.options;
    }

    public boolean isChangedMaxSize() {
        return this.options.getMaxSize_Gb() != this.prevOptions.getMaxSize_Gb();
    }

    private void setText(JTextField tf, String text) {
        tf.setText(text);
        if (tf.isEnabled()) {
            tf.setCaretPosition(text.length());
            tf.moveCaretPosition(0);
        }
    }

    private void common_actionPerformed(ActionEvent e) {
        this.generateExternal_actionPerformed(e);
    }

    private void common_focusGained(FocusEvent e) {
        this.runFocusMonitor();
        this.isFocused = true;
    }

    private void common_focusLost(FocusEvent e) {
        this.isFocused = false;
    }

    private void tfMaxSize_actionPerformed(ActionEvent e) {
        this.prevMaxSize_Gb = Formatter.checkNumericFieldValue(this.tfMaxSize_Gb, 1, 99999, this.prevMaxSize_Gb);
        this.common_actionPerformed(e);
    }

    private void tfMaxSize_focusGained(FocusEvent e) {
        this.prevMaxSize_Gb = Integer.parseInt(this.tfMaxSize_Gb.getText().trim());
        this.common_focusGained(e);
    }

    private void tfMaxSize_focusLost(FocusEvent e) {
        this.prevMaxSize_Gb = Formatter.checkNumericFieldValue(this.tfMaxSize_Gb, 1, 99999, this.prevMaxSize_Gb);
        this.common_focusLost(e);
    }
}

