/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.math.Search;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GeneralAntennaSelectorPanel
extends Box {
    protected final int numberOfAntennas;
    private final int buttonSize;
    private final JToggleButton[] tbAntennas;
    private Color selectedColor = new Color(0, 152, 0);
    private String selectedTooltipPrefix = "";
    private String selectedTooltipSuffix = " is selected";
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public GeneralAntennaSelectorPanel(int numberOfAntennas) {
        this(numberOfAntennas, 0, 10);
    }

    public GeneralAntennaSelectorPanel(int numberOfAntennas, int buttonSize) {
        this(numberOfAntennas, 0, buttonSize);
    }

    public GeneralAntennaSelectorPanel(int numberOfAntennas, int axis, int buttonSize) {
        super(axis);
        this.numberOfAntennas = numberOfAntennas;
        this.buttonSize = buttonSize;
        this.tbAntennas = new JToggleButton[numberOfAntennas];
        this.guiInit();
        this.setButtonsAppearance();
    }

    public void setSelectedColor(Color selectedColor) {
        this.setSelectedColor_1(selectedColor);
        this.setButtonsAppearance();
    }

    private void setSelectedColor_1(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    public void setSelectedTooltip(String selectedTooltipPrefix, String selectedTooltipSuffix) {
        this.setSelectededTooltip_1(selectedTooltipPrefix, selectedTooltipSuffix);
        this.setButtonsAppearance();
    }

    private void setSelectededTooltip_1(String selectedTooltipPrefix, String selectedTooltipSuffix) {
        this.selectedTooltipPrefix = selectedTooltipPrefix != null ? selectedTooltipPrefix : "";
        this.selectedTooltipSuffix = selectedTooltipSuffix != null ? selectedTooltipSuffix : "";
    }

    public void setAppearanceForSelectedAntennas(Color selectedColor, String selectedTooltipPrefix, String selectedTooltipSuffix) {
        this.setSelectedColor_1(selectedColor);
        this.setSelectededTooltip_1(selectedTooltipPrefix, selectedTooltipSuffix);
        this.setButtonsAppearance();
    }

    public void setTitle(String title) {
        this.remove(0);
        this.add((Component)new JLabel(String.valueOf(title) + "  "), 0);
    }

    private void guiInit() {
        int i = 0;
        while (i < this.numberOfAntennas) {
            this.tbAntennas[i] = new JToggleButton("" + (i + 1));
            this.tbAntennas[i].setFont(new Font("Arial", 0, this.buttonSize));
            this.tbAntennas[i].setMargin(new Insets(2, 0, 2, 0));
            this.tbAntennas[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeneralAntennaSelectorPanel.this.toggle_actionPerformed(e);
                }
            });
            this.add(this.tbAntennas[i]);
            ++i;
        }
        this.add((Component)new JLabel(""), 0);
    }

    public SortedSet<Integer> get() {
        TreeSet<Integer> antSet = new TreeSet<Integer>();
        boolean[] ants = this.getAsBoolArray();
        int i = 0;
        while (i < this.numberOfAntennas) {
            if (!ants[i]) {
                antSet.add(i + 1);
            }
            ++i;
        }
        return antSet;
    }

    public void set(Set<Integer> antSet) {
        if (antSet == null) {
            throw new IllegalArgumentException("antSet == null");
        }
        if (antSet.size() > this.numberOfAntennas) {
            throw new IllegalArgumentException("antSet.size() > numberOfAntennas");
        }
        boolean[] ants = new boolean[this.numberOfAntennas];
        Arrays.fill(ants, true);
        for (int antNumber : antSet) {
            if (antNumber < 1) {
                throw new IllegalArgumentException("antSet contains antenna number < 1, " + antNumber);
            }
            if (antNumber > this.numberOfAntennas) {
                throw new IllegalArgumentException("antSet contains antenna number > " + this.numberOfAntennas + ", " + antNumber);
            }
            ants[antNumber - 1] = false;
        }
        this.set(ants);
    }

    public boolean[] getAsBoolArray() {
        boolean[] antennas = new boolean[this.numberOfAntennas];
        int i = 0;
        while (i < this.numberOfAntennas) {
            antennas[i] = this.tbAntennas[i].isSelected();
            ++i;
        }
        return antennas;
    }

    public void set(boolean[] antStatus) {
        if (antStatus == null) {
            throw new IllegalArgumentException("array antStatus is null");
        }
        if (antStatus.length != this.numberOfAntennas) {
            throw new IllegalArgumentException("array antStatus contains wrong number of antennas, " + antStatus.length + ", has to be " + this.numberOfAntennas);
        }
        int i = 0;
        while (i < antStatus.length) {
            this.tbAntennas[i].setSelected(antStatus[i]);
            ++i;
        }
        this.setButtonsAppearance();
    }

    @Override
    public void setEnabled(boolean value) {
        int i = 0;
        while (i < this.numberOfAntennas) {
            this.tbAntennas[i].setEnabled(value);
            ++i;
        }
        this.getComponent(0).setEnabled(value);
        this.setButtonsAppearance();
    }

    @Override
    public void setVisible(boolean value) {
        int i = 0;
        while (i < this.numberOfAntennas) {
            this.tbAntennas[i].setVisible(value);
            ++i;
        }
        this.getComponent(0).setVisible(value);
    }

    public boolean isAllSelected() {
        int i = 0;
        while (i < this.numberOfAntennas) {
            if (!this.tbAntennas[i].isSelected()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void toggle_actionPerformed(ActionEvent e) {
        JToggleButton button = (JToggleButton)e.getSource();
        int antIndex = Search.strictScan(this.tbAntennas, (Object)button);
        this.setButtonAppearance(antIndex);
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener e) {
        this.listeners.add(e);
    }

    public void removeChangeListener(ChangeListener e) {
        this.listeners.remove(e);
    }

    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).stateChanged(e);
            ++i;
        }
    }

    private void setButtonsAppearance() {
        int i = 0;
        while (i < this.numberOfAntennas) {
            this.setButtonAppearance(i);
            ++i;
        }
    }

    private void setButtonAppearance(int antIndex) {
        JToggleButton button = this.tbAntennas[antIndex];
        if (button.isSelected()) {
            button.setToolTipText(null);
        } else {
            button.setBackground(this.selectedColor);
            button.setToolTipText(String.valueOf(this.selectedTooltipPrefix) + "Antenna/Channel " + (antIndex + 1) + this.selectedTooltipSuffix);
        }
    }
}

