/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.math.Sort;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class LookAndFeelPanel
extends JPanel {
    private static final String CURRENT_LOOK = "Current Look and Feel";
    private static final String CROSS_PLATFORM_LOOK = "Cross platform Look and Feel";
    private static final String SYSTEM_LOOK = "System Look and Feel";
    private String lookAndFeelName;
    private String prevLookAndFeelName;
    private boolean changed;
    private String[] lookAndFeelNames;
    private String[] lookAndFeelClassNames;
    private int lookAndFeelIndex;
    private String crossPlatformLookAndFeelName;
    private int crossPlatformLookAndFeelIndex;
    private String systemLookAndFeelName;
    private int systemLookAndFeelIndex;
    private MyTableModel tblModel;
    private JTable tblSettings;
    private JLabel lblLookAndFeels = new JLabel("You can choose another Look and Feel: ");
    private JComboBox<String> cbLookAndFeels;
    private JPanel pnlCbLookAndFeels = new JPanel(new FlowLayout(0, 0, 0));
    private JPanel pnlLookAndFeels = new JPanel(new GridLayout(2, 1, 0, 5));
    private JPanel pnlContent = new JPanel();
    private JTextArea taText = new JTextArea();
    private transient boolean internalSet;

    public LookAndFeelPanel() {
        this.init();
        this.guiInit();
    }

    private void init() {
        UIManager.LookAndFeelInfo[] lookAndFeelsInfo = UIManager.getInstalledLookAndFeels();
        this.lookAndFeelNames = new String[lookAndFeelsInfo.length];
        this.lookAndFeelClassNames = new String[lookAndFeelsInfo.length];
        int i = 0;
        while (i < lookAndFeelsInfo.length) {
            this.lookAndFeelNames[i] = lookAndFeelsInfo[i].getName();
            this.lookAndFeelClassNames[i] = lookAndFeelsInfo[i].getClassName();
            ++i;
        }
        Sort sort = new Sort(this.lookAndFeelNames);
        this.lookAndFeelClassNames = sort.doSort(this.lookAndFeelClassNames);
        this.lookAndFeelName = UIManager.getLookAndFeel().getName();
        this.lookAndFeelIndex = Arrays.binarySearch(this.lookAndFeelNames, this.lookAndFeelName);
        this.crossPlatformLookAndFeelIndex = Search.scanStr(this.lookAndFeelClassNames, UIManager.getCrossPlatformLookAndFeelClassName());
        this.crossPlatformLookAndFeelName = this.lookAndFeelNames[this.crossPlatformLookAndFeelIndex];
        this.systemLookAndFeelIndex = Search.scanStr(this.lookAndFeelClassNames, UIManager.getSystemLookAndFeelClassName());
        this.systemLookAndFeelName = this.lookAndFeelNames[this.systemLookAndFeelIndex];
    }

    public void setLookAndFeelName(String lookAndFeelName) {
        boolean changed = !lookAndFeelName.equals(this.lookAndFeelName);
        this.lookAndFeelName = lookAndFeelName;
        this.prevLookAndFeelName = lookAndFeelName;
        if (changed) {
            this.lookAndFeelIndex = Arrays.binarySearch(this.lookAndFeelNames, lookAndFeelName);
            this.cbLookAndFeels.setSelectedIndex(this.lookAndFeelIndex);
        }
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public String getLookAndFeelName() {
        return this.lookAndFeelName;
    }

    public void accept() {
        this.changed = !this.lookAndFeelName.equals(this.prevLookAndFeelName);
        this.prevLookAndFeelName = this.lookAndFeelName;
    }

    public void reset() {
        this.lookAndFeelName = this.prevLookAndFeelName;
        this.lookAndFeelIndex = Arrays.binarySearch(this.lookAndFeelNames, this.lookAndFeelName);
        this.cbLookAndFeels.setSelectedIndex(this.lookAndFeelIndex);
    }

    private void guiInit() {
        this.createSettingsTable();
        this.lblLookAndFeels.setHorizontalTextPosition(2);
        this.cbLookAndFeels = new JComboBox<String>(this.lookAndFeelNames);
        this.cbLookAndFeels.setSelectedIndex(this.lookAndFeelIndex);
        this.cbLookAndFeels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelPanel.this.changeLookAndFeel();
            }
        });
        this.pnlCbLookAndFeels.add(this.cbLookAndFeels);
        this.pnlLookAndFeels.add(this.lblLookAndFeels);
        this.pnlLookAndFeels.add(this.pnlCbLookAndFeels);
        this.pnlContent.setLayout(new BoxLayout(this.pnlContent, 1));
        this.pnlContent.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.taText.setText("In some cases, to get full effect of change you need to quit and start over the application");
        this.taText.setLineWrap(true);
        this.taText.setWrapStyleWord(true);
        this.taText.setBackground(Color.DARK_GRAY);
        this.taText.setForeground(Color.WHITE);
        this.taText.setBorder(BorderFactory.createRaisedBevelBorder());
        this.pnlContent.add(this.tblSettings);
        this.pnlContent.add(this.pnlLookAndFeels);
        this.pnlContent.add(this.taText);
        this.setLayout(new BorderLayout(10, 5));
        this.add((Component)this.pnlContent, "North");
        this.setPreferredSize(new Dimension(400, 180));
    }

    private void createSettingsTable() {
        this.tblModel = new MyTableModel();
        this.tblSettings = new JTable(this.tblModel);
    }

    private void changeLookAndFeel() {
        if (this.internalSet) {
            return;
        }
        int index = this.cbLookAndFeels.getSelectedIndex();
        if (index != this.lookAndFeelIndex) {
            this.lookAndFeelIndex = index;
            this.lookAndFeelName = this.lookAndFeelNames[index];
            this.tblModel.fireDataChanged();
        }
    }

    private class MyTableModel
    implements TableModel {
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
        private Object sync = new Object();

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return 3;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "L&F type";
            }
            return "L&F name";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (rowIndex) {
                case 0: {
                    if (columnIndex == 0) {
                        return LookAndFeelPanel.CURRENT_LOOK;
                    }
                    return LookAndFeelPanel.this.lookAndFeelName;
                }
                case 1: {
                    if (columnIndex == 0) {
                        return LookAndFeelPanel.CROSS_PLATFORM_LOOK;
                    }
                    return LookAndFeelPanel.this.crossPlatformLookAndFeelName;
                }
                case 2: {
                    if (columnIndex == 0) {
                        return LookAndFeelPanel.SYSTEM_LOOK;
                    }
                    return LookAndFeelPanel.this.systemLookAndFeelName;
                }
            }
            throw new RuntimeException("illegal rowIndex or columnIndex");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addTableModelListener(TableModelListener l) {
            Object object = this.sync;
            synchronized (object) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTableModelListener(TableModelListener l) {
            Object object = this.sync;
            synchronized (object) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireDataChanged() {
            Object object = this.sync;
            synchronized (object) {
                TableModelEvent e = new TableModelEvent(this, 0, 0, 1);
                for (TableModelListener l : this.listeners) {
                    l.tableChanged(e);
                }
            }
        }
    }
}

