/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.graph.Draw;
import edu.uml.lgdc.gui.navigation.NavigationExecutor;
import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class NavigatorPanel
extends EventEnabledPanel {
    public static final int LAYOUT_HORIZONTAL = 0;
    public static final int LAYOUT_VERTICAL = 1;
    public static final int LAYOUT_HORIZONTAL_GRID = 2;
    public static final int LAYOUT_VERTICAL_GRID = 3;
    public static final String ICONS_DIR = "/edu/uml/lgdc/gui/icons/";
    private static final int NUMBER_OF_LAYOUTS = 4;
    private static final ImageIcon ICON_PLAY = new ImageIcon(NavigatorPanel.class.getResource("/edu/uml/lgdc/gui/icons/play.gif"));
    private static final ImageIcon ICON_STOP = new ImageIcon(NavigatorPanel.class.getResource("/edu/uml/lgdc/gui/icons/stop.gif"));
    private static final ImageIcon ICON_PREV = new ImageIcon(NavigatorPanel.class.getResource("/edu/uml/lgdc/gui/icons/prev.gif"));
    private static final ImageIcon ICON_NEXT = new ImageIcon(NavigatorPanel.class.getResource("/edu/uml/lgdc/gui/icons/next.gif"));
    private static final ImageIcon ICON_FIRST = new ImageIcon(NavigatorPanel.class.getResource("/edu/uml/lgdc/gui/icons/first.gif"));
    private static final ImageIcon ICON_LAST = new ImageIcon(NavigatorPanel.class.getResource("/edu/uml/lgdc/gui/icons/last.gif"));
    private static final ImageIcon ICON_PAUSE = new ImageIcon(NavigatorPanel.class.getResource("/edu/uml/lgdc/gui/icons/pause.gif"));
    private static final char HOT_CHAR_A = 'A';
    private static final char HOT_CHAR_Z = 'Z';
    private static final char HOT_CHAR_S = 'S';
    private static final char HOT_CHAR_P = 'P';
    private static final char HOT_CHAR_X = 'X';
    private static final char HOT_CHAR_D = 'D';
    private NavigationExecutor navExec;
    private boolean playMode = false;
    private int layoutStyle = -1;
    private boolean borderEnabled = true;
    private boolean playFeatureEnabled = true;
    private Border border = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Navigating", 2, 2);
    private Border borderPlay = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), "Playing", 2, 2);
    private FlowLayout flowLayout = new FlowLayout();
    private GridLayout gridLayout1 = new GridLayout(6, 1);
    private GridLayout gridLayout2 = new GridLayout(2, 3);
    private GridLayout gridLayout3 = new GridLayout(3, 2);
    private LayoutManager layout;
    private JButton btnPrev = new JButton();
    private JButton btnNext = new JButton();
    private JButton btnPlay = new JButton();
    private JButton btnStop = new JButton();
    private JButton btnFirst = new JButton();
    private JButton btnLast = new JButton();
    private int keyModifiers;
    private String modifiersText = "";

    public NavigatorPanel() {
        this((NavigationExecutor)null);
    }

    public NavigatorPanel(NavigationExecutor navExec) {
        this.navExec = navExec;
        this.setLayoutManager();
        this.guiInit();
    }

    private void guiInit() {
        this.btnFirst.setIcon(ICON_FIRST);
        this.btnFirst.setMargin(new Insets(0, 0, 0, 0));
        this.btnFirst.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                NavigatorPanel.this.thisFocusLost(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
                NavigatorPanel.this.thisFocusGained(e);
            }
        });
        this.btnFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.btnFirst_actionPerformed(e);
            }
        });
        this.btnPrev.setIcon(ICON_PREV);
        this.btnPrev.setMargin(new Insets(0, 0, 0, 0));
        this.btnPrev.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                NavigatorPanel.this.thisFocusLost(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
                NavigatorPanel.this.thisFocusGained(e);
            }
        });
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.btnPrev_actionPerformed(e);
            }
        });
        this.btnStop.setIcon(ICON_STOP);
        this.btnStop.setEnabled(false);
        this.btnStop.setMargin(new Insets(0, 0, 0, 0));
        this.btnStop.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                NavigatorPanel.this.thisFocusLost(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
                NavigatorPanel.this.thisFocusGained(e);
            }
        });
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.btnStop_actionPerformed(e);
            }
        });
        this.btnPlay.setIcon(ICON_PLAY);
        this.btnPlay.setMargin(new Insets(0, 0, 0, 0));
        this.btnPlay.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                NavigatorPanel.this.thisFocusLost(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
                NavigatorPanel.this.thisFocusGained(e);
            }
        });
        this.btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.btnPlay_actionPerformed(e);
            }
        });
        this.btnNext.setIcon(ICON_NEXT);
        this.btnNext.setMargin(new Insets(0, 0, 0, 0));
        this.btnNext.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                NavigatorPanel.this.thisFocusLost(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
                NavigatorPanel.this.thisFocusGained(e);
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.btnNext_actionPerformed(e);
            }
        });
        this.btnLast.setIcon(ICON_LAST);
        this.btnLast.setMargin(new Insets(0, 0, 0, 0));
        this.btnLast.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                NavigatorPanel.this.thisFocusLost(e);
            }

            @Override
            public void focusGained(FocusEvent e) {
                NavigatorPanel.this.thisFocusGained(e);
            }
        });
        this.btnLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigatorPanel.this.btnLast_actionPerformed(e);
            }
        });
        this.setBorderEnabled(this.borderEnabled, true);
        this.setPlayFeatureEnabled(this.playFeatureEnabled, true);
        this.setLayout(0, true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                NavigatorPanel.this.keyTyped(e);
            }
        });
        this.buildTooltips();
    }

    private void buildTooltips() {
        String plus = this.modifiersText.length() == 0 ? "<b>" : "+<b>";
        this.btnFirst.setToolTipText("<html>first, " + this.modifiersText + plus + 'A' + "</b></html>");
        this.btnPrev.setToolTipText("<html>previous, " + this.modifiersText + plus + 'Z' + "</b></html>");
        this.btnStop.setToolTipText("<html>stop, " + this.modifiersText + plus + 'S' + "</b></html>");
        this.btnPlay.setToolTipText("<html>play, " + this.modifiersText + plus + 'P' + "</b></html>");
        this.btnNext.setToolTipText("<html>next, " + this.modifiersText + plus + 'X' + "</b></html>");
        this.btnLast.setToolTipText("<html>last, " + this.modifiersText + plus + 'D' + "</b></html>");
    }

    public void setExecutor(NavigationExecutor navExec) {
        this.navExec = navExec;
    }

    public void setBorderEnabled(boolean borderEnabled) {
        this.setBorderEnabled(borderEnabled, false);
    }

    public void setBorderEnabled(boolean borderEnabled, boolean force) {
        if (this.borderEnabled != borderEnabled || force) {
            this.borderEnabled = borderEnabled;
            if (borderEnabled) {
                if (!this.playMode) {
                    this.setBorder(this.border);
                } else {
                    this.setBorder(this.borderPlay);
                }
            } else {
                this.setBorder(null);
            }
        }
    }

    public void setTitle(String navigatingTitle, String playingTitle) {
        this.border = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), navigatingTitle, 2, 2);
        this.borderPlay = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), playingTitle, 2, 2);
        if (this.borderEnabled) {
            if (!this.playMode) {
                this.setBorder(this.border);
            } else {
                this.setBorder(this.borderPlay);
            }
        }
    }

    public void setPlayFeatureEnabled(boolean playFeatureEnabled) {
        this.setPlayFeatureEnabled(playFeatureEnabled, false);
    }

    public void setPlayFeatureEnabled(boolean playFeatureEnabled, boolean force) {
        if (this.playFeatureEnabled != playFeatureEnabled || force) {
            this.playFeatureEnabled = playFeatureEnabled;
            if (playFeatureEnabled) {
                this.gridLayout1.setRows(6);
                this.gridLayout2.setRows(2);
                this.gridLayout2.setColumns(3);
                this.gridLayout3.setRows(3);
            } else {
                this.gridLayout1.setRows(4);
                this.gridLayout2.setRows(2);
                this.gridLayout2.setColumns(2);
                this.gridLayout3.setRows(2);
            }
            this.setLayout(this.layoutStyle, true);
        }
    }

    public void setLayout(int layoutStyle) {
        this.setLayout(layoutStyle, false);
    }

    public void setLayout(int layoutStyle, boolean force) {
        if (layoutStyle < 0 || layoutStyle >= 4) {
            return;
        }
        if (layoutStyle == this.layoutStyle && !force) {
            return;
        }
        this.layoutStyle = layoutStyle;
        this.setLayoutManager();
        this.removeAll();
        this.setLayout(this.layout);
        if (layoutStyle == 0) {
            this.add(this.btnFirst);
            this.add(this.btnPrev);
            if (this.playFeatureEnabled) {
                this.add(this.btnStop);
                this.add(this.btnPlay);
            }
            this.add(this.btnNext);
            this.add(this.btnLast);
        } else if (layoutStyle == 1) {
            this.add(this.btnFirst);
            this.add(this.btnPrev);
            if (this.playFeatureEnabled) {
                this.add(this.btnStop);
                this.add(this.btnPlay);
            }
            this.add(this.btnNext);
            this.add(this.btnLast);
        } else if (layoutStyle == 2) {
            this.add(this.btnLast);
            if (this.playFeatureEnabled) {
                this.add(this.btnPlay);
            }
            this.add(this.btnNext);
            this.add(this.btnFirst);
            if (this.playFeatureEnabled) {
                this.add(this.btnStop);
            }
            this.add(this.btnPrev);
        } else {
            this.add(this.btnPrev);
            this.add(this.btnNext);
            this.add(this.btnFirst);
            this.add(this.btnLast);
            if (this.playFeatureEnabled) {
                this.add(this.btnPlay);
                this.add(this.btnStop);
            }
        }
    }

    public void setPlayMode(boolean flag) {
        if (this.playMode == flag) {
            return;
        }
        this.btnFirst.setEnabled(!flag);
        this.btnPrev.setEnabled(!flag);
        this.btnNext.setEnabled(!flag);
        this.btnLast.setEnabled(!flag);
        if (flag) {
            this.btnPlay.setIcon(ICON_PAUSE);
            this.btnPlay.setToolTipText("Pause movie (hot key P)");
            this.btnStop.setEnabled(true);
            if (this.borderEnabled) {
                this.setBorder(this.borderPlay);
            }
        } else {
            this.btnPlay.setIcon(ICON_PLAY);
            this.btnPlay.setToolTipText("Play movie (hot key P)");
            this.btnStop.setEnabled(false);
            if (this.borderEnabled) {
                this.setBorder(this.border);
            }
        }
        this.playMode = flag;
    }

    public void setEnable(boolean flag) {
        Draw.setEnabled(this, flag);
    }

    public void setButtonBorder(boolean flag) {
        this.btnFirst.setBorderPainted(flag);
        this.btnPrev.setBorderPainted(flag);
        this.btnStop.setBorderPainted(flag);
        this.btnPlay.setBorderPainted(flag);
        this.btnNext.setBorderPainted(flag);
        this.btnLast.setBorderPainted(flag);
    }

    public void setPrevEnabled(boolean flag) {
        this.btnPrev.setEnabled(flag);
    }

    public void setPlayEnabled(boolean flag) {
        this.btnPlay.setEnabled(flag);
    }

    public void setStopEnabled(boolean flag) {
        this.btnStop.setEnabled(flag);
    }

    public void setNextEnabled(boolean flag) {
        this.btnNext.setEnabled(flag);
    }

    public void setFirstEnabled(boolean flag) {
        this.btnFirst.setEnabled(flag);
    }

    public void setLastEnabled(boolean flag) {
        this.btnLast.setEnabled(flag);
    }

    private void setLayoutManager() {
        if (this.layoutStyle == 0) {
            this.layout = this.flowLayout;
        } else if (this.layoutStyle == 1) {
            this.layout = this.gridLayout1;
        } else if (this.layoutStyle == 2) {
            this.layout = this.gridLayout2;
        } else if (this.layoutStyle == 3) {
            this.layout = this.gridLayout3;
        }
    }

    @Override
    protected void generateExternal_actionPerformed(ActionEvent e) {
        this.fireActionPerformed();
    }

    @Override
    public void requestFocus() {
        this.btnNext.requestFocus();
    }

    private void btnNext_actionPerformed(ActionEvent e) {
        if (this.navExec != null) {
            this.navExec.next();
        }
        this.generateExternal_actionPerformed(e);
    }

    private void btnPrev_actionPerformed(ActionEvent e) {
        if (this.navExec != null) {
            this.navExec.prev();
        }
        this.generateExternal_actionPerformed(e);
    }

    private void btnFirst_actionPerformed(ActionEvent e) {
        if (this.navExec != null) {
            this.navExec.first();
        }
        this.generateExternal_actionPerformed(e);
    }

    private void btnLast_actionPerformed(ActionEvent e) {
        if (this.navExec != null) {
            this.navExec.last();
        }
        this.generateExternal_actionPerformed(e);
    }

    private void btnPlay_actionPerformed(ActionEvent e) {
        if (this.navExec != null) {
            this.navExec.play();
        }
        this.generateExternal_actionPerformed(e);
    }

    private void btnStop_actionPerformed(ActionEvent e) {
        if (this.navExec != null) {
            this.navExec.stop();
        }
        this.generateExternal_actionPerformed(e);
    }

    private void thisFocusGained(FocusEvent e) {
        this.isFocused = true;
        this.runFocusMonitor();
    }

    private void thisFocusLost(FocusEvent e) {
        this.isFocused = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.keyModifiers != 0) {
            return;
        }
        switch (Character.toUpperCase(e.getKeyChar())) {
            case 'P': {
                if (this.btnPlay.isEnabled() && this.btnPlay.isShowing() && this.playFeatureEnabled) {
                    this.btnPlay_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 'Z': {
                if (this.btnPrev.isEnabled() && this.btnPrev.isShowing()) {
                    this.btnPrev_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 'X': {
                if (this.btnNext.isEnabled() && this.btnNext.isShowing()) {
                    this.btnNext_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 'S': {
                if (this.btnStop.isEnabled() && this.btnStop.isShowing() && this.playFeatureEnabled) {
                    this.btnStop_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 'A': {
                if (this.btnFirst.isEnabled() && this.btnFirst.isShowing()) {
                    this.btnFirst_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 'D': {
                if (this.btnLast.isEnabled() && this.btnLast.isShowing()) {
                    this.btnLast_actionPerformed(null);
                }
                e.consume();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.keyModifiers == 0) {
            return;
        }
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiers();
        switch (keyCode) {
            case 80: {
                if (modifiers != this.keyModifiers) break;
                if (this.btnPlay.isEnabled() && this.btnPlay.isShowing() && this.playFeatureEnabled) {
                    this.btnPlay_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 90: {
                if (modifiers != this.keyModifiers) break;
                if (this.btnPrev.isEnabled() && this.btnPrev.isShowing()) {
                    this.btnPrev_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 88: {
                if (modifiers != this.keyModifiers) break;
                if (this.btnNext.isEnabled() && this.btnNext.isShowing()) {
                    this.btnNext_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 83: {
                if (modifiers != this.keyModifiers) break;
                if (this.btnStop.isEnabled() && this.btnStop.isShowing() && this.playFeatureEnabled) {
                    this.btnStop_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 65: {
                if (modifiers != this.keyModifiers) break;
                if (this.btnFirst.isEnabled() && this.btnFirst.isShowing()) {
                    this.btnFirst_actionPerformed(null);
                }
                e.consume();
                break;
            }
            case 68: {
                if (modifiers != this.keyModifiers) break;
                if (this.btnLast.isEnabled() && this.btnLast.isShowing()) {
                    this.btnLast_actionPerformed(null);
                }
                e.consume();
            }
        }
    }

    public int getKeyModifiers() {
        return this.keyModifiers;
    }

    public void setKeyModifiers(int keyModifiers) {
        switch (keyModifiers) {
            case 2: {
                this.modifiersText = "<b>Ctrl</b>";
                break;
            }
            case 1: {
                this.modifiersText = "<b>Shift</b>";
                break;
            }
            case 8: {
                this.modifiersText = "<b>Alt</b>";
                break;
            }
            case 3: {
                this.modifiersText = "<b>Ctrl</b>+<b>Shift</b>";
                break;
            }
            case 10: {
                this.modifiersText = "<b>Ctrl</b>+<b>Alt</b>";
                break;
            }
            case 9: {
                this.modifiersText = "<b>Shift</b>+<b>ALT</b>";
                break;
            }
            case 11: {
                this.modifiersText = "<b>Ctrl</b>+<b>Shift</b>+<b>Alt</b>";
                break;
            }
            default: {
                keyModifiers = 0;
                this.modifiersText = "";
            }
        }
        this.keyModifiers = keyModifiers;
        this.buildTooltips();
    }
}

