/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.panels;

import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.gui.InfoLine;
import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class SystemInfoPanel
extends EventEnabledPanel {
    private static final int H_GAP = 5;
    private static final int V_GAP = 0;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final RuntimeMXBean RUNTIME_MX = ManagementFactory.getRuntimeMXBean();
    private static final MemoryMXBean MEMORY_MX = ManagementFactory.getMemoryMXBean();
    private static final ThreadMXBean THREAD_MX = ManagementFactory.getThreadMXBean();
    private JScrollPane scrPane = new JScrollPane();
    private JPanel pnlMain = new JPanel();
    private BoxLayout boxLayout = new BoxLayout(this.pnlMain, 1);
    private Border border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(1, 5, 0, 5));
    private JLabel lblOSName = new JLabel("OS name:");
    private JLabel lblOSNameVal = new JLabel(System.getProperty("os.name"));
    private InfoLine lineOSName = new InfoLine(this.lblOSName, this.lblOSNameVal);
    private JLabel lblOSVer = new JLabel("OS version:");
    private JLabel lblOSVerVal = new JLabel(System.getProperty("os.version"));
    private InfoLine lineOSVer = new InfoLine(this.lblOSVer, this.lblOSVerVal);
    private JLabel lblOSArch = new JLabel("OS architecture");
    private JLabel lblOSArchVal = new JLabel(System.getProperty("os.arch"));
    private InfoLine lineOSArch = new InfoLine(this.lblOSArch, this.lblOSArchVal);
    private JLabel lblNumberOfProcessors = new JLabel("Number of processors:");
    private JLabel lblNumberOfProcessorsVal = new JLabel("" + RUNTIME.availableProcessors());
    private InfoLine lineNumberOfProcessors = new InfoLine(this.lblNumberOfProcessors, this.lblNumberOfProcessorsVal);
    private JLabel lblRunningJVMName = new JLabel("Running JVM name:");
    private JLabel lblRunningJVMNameVal = new JLabel(RUNTIME_MX.getName());
    private InfoLine lineRunningJVMName = new InfoLine(this.lblRunningJVMName, this.lblRunningJVMNameVal);
    private JLabel lblJVMSpecName = new JLabel("JVM specification name:");
    private JLabel lblJVMSpecNameVal = new JLabel(RUNTIME_MX.getSpecName());
    private InfoLine lineJVMSpecName = new InfoLine(this.lblJVMSpecName, this.lblJVMSpecNameVal);
    private JLabel lblJVMSpecVendor = new JLabel("JVM specification vendor:");
    private JLabel lblJVMSpecVendorVal = new JLabel(RUNTIME_MX.getSpecVendor());
    private InfoLine lineJVMSpecVendor = new InfoLine(this.lblJVMSpecVendor, this.lblJVMSpecVendorVal);
    private JLabel lblJVMSpecVersion = new JLabel("JVM specification version:");
    private JLabel lblJVMSpecVersionVal = new JLabel(RUNTIME_MX.getSpecVersion());
    private InfoLine lineJVMSpecVersion = new InfoLine(this.lblJVMSpecVersion, this.lblJVMSpecVersionVal);
    private JLabel lblJavaRuntimeName = new JLabel("Java Runtime name:");
    private JLabel lblJavaRuntimeNameVal = new JLabel(System.getProperty("java.runtime.name"));
    private InfoLine lineJavaRuntimeName = new InfoLine(this.lblJavaRuntimeName, this.lblJavaRuntimeNameVal);
    private JLabel lblJavaRuntimeVersion = new JLabel("Java Runtime version:");
    private JLabel lblJavaRuntimeVersionVal = new JLabel(System.getProperty("java.runtime.version"));
    private InfoLine lineJavaRuntimeVersion = new InfoLine(this.lblJavaRuntimeVersion, this.lblJavaRuntimeVersionVal);
    private JLabel lblJVMImplName = new JLabel("JVM implemention name:");
    private JLabel lblJVMImplNameVal = new JLabel(RUNTIME_MX.getVmName());
    private InfoLine lineJVMImplName = new InfoLine(this.lblJVMImplName, this.lblJVMImplNameVal);
    private JLabel lblJVMImplVendor = new JLabel("JVM implemention vendor:");
    private JLabel lblJVMImplVendorVal = new JLabel(RUNTIME_MX.getVmVendor());
    private InfoLine lineJVMImplVendor = new InfoLine(this.lblJVMImplVendor, this.lblJVMImplVendorVal);
    private JLabel lblJVMImplVersion = new JLabel("JVM implemention version:");
    private JLabel lblJVMImplVersionVal = new JLabel(RUNTIME_MX.getVmVersion());
    private InfoLine lineJVMImplVersion = new InfoLine(this.lblJVMImplVersion, this.lblJVMImplVersionVal);
    private JLabel lblThreadCount = new JLabel("Current thread count:");
    private JLabel lblThreadCountVal = new JLabel("");
    private InfoLine lineThreadCount = new InfoLine(this.lblThreadCount, this.lblThreadCountVal);
    private JLabel lblPeakThreadCount = new JLabel("Peak thread count:");
    private JLabel lblPeakThreadCountVal = new JLabel("");
    private InfoLine linePeakThreadCount = new InfoLine(this.lblPeakThreadCount, this.lblPeakThreadCountVal);
    private JLabel lblTotalStartedThreadCount = new JLabel("Total started thread count:");
    private JLabel lblTotalStartedThreadCountVal = new JLabel("");
    private InfoLine lineTotalStartedThreadCount = new InfoLine(this.lblTotalStartedThreadCount, this.lblTotalStartedThreadCountVal);
    private JLabel lblThreadCPUTimeSupported = new JLabel("MX thread CPU time:");
    private JLabel lblThreadCPUTimeSupportedVal = new JLabel(THREAD_MX.isThreadCpuTimeSupported() ? "Supported" : "Not supported");
    private InfoLine lineThreadCPUTimeSupported = new InfoLine(this.lblThreadCPUTimeSupported, this.lblThreadCPUTimeSupportedVal);
    private JLabel lblThreadContentionMonitor = new JLabel("MX thread contention monitor:");
    private JLabel lblThreadContentionMonitorVal = new JLabel(THREAD_MX.isThreadContentionMonitoringSupported() ? "Supported" : "Not supported");
    private InfoLine lineThreadContentionMonitor = new InfoLine(this.lblThreadContentionMonitor, this.lblThreadContentionMonitorVal);
    private JLabel lblHeapMemInit = new JLabel("Heap memory init:");
    private JLabel lblHeapMemInitVal = new JLabel("");
    private InfoLine lineHeapMemInit = new InfoLine(this.lblHeapMemInit, this.lblHeapMemInitVal);
    private JLabel lblHeapMemUsed = new JLabel("Heap memory used:");
    private JLabel lblHeapMemUsedVal = new JLabel("");
    private InfoLine lineHeapMemUsed = new InfoLine(this.lblHeapMemUsed, this.lblHeapMemUsedVal);
    private JLabel lblHeapMemCommitted = new JLabel("Heap memory committed:");
    private JLabel lblHeapMemCommittedVal = new JLabel("");
    private InfoLine lineHeapMemCommitted = new InfoLine(this.lblHeapMemCommitted, this.lblHeapMemCommittedVal);
    private JLabel lblHeapMemMax = new JLabel("Heap memory max:");
    private JLabel lblHeapMemMaxVal = new JLabel("");
    private InfoLine lineHeapMemMax = new InfoLine(this.lblHeapMemMax, this.lblHeapMemMaxVal);
    private JLabel lblNonHeapMemInit = new JLabel("Non-heap memory init:");
    private JLabel lblNonHeapMemInitVal = new JLabel("");
    private InfoLine lineNonHeapMemInit = new InfoLine(this.lblNonHeapMemInit, this.lblNonHeapMemInitVal);
    private JLabel lblNonHeapMemUsed = new JLabel("Non-heap memory used:");
    private JLabel lblNonHeapMemUsedVal = new JLabel("");
    private InfoLine lineNonHeapMemUsed = new InfoLine(this.lblNonHeapMemUsed, this.lblNonHeapMemUsedVal);
    private JLabel lblNonHeapMemCommitted = new JLabel("Non-heap memory committed:");
    private JLabel lblNonHeapMemCommittedVal = new JLabel("");
    private InfoLine lineNonHeapMemCommitted = new InfoLine(this.lblNonHeapMemCommitted, this.lblNonHeapMemCommittedVal);
    private JLabel lblNonHeapMemMax = new JLabel("NonHeap memory max:");
    private JLabel lblNonHeapMemMaxVal = new JLabel("");
    private InfoLine lineNonHeapMemMax = new InfoLine(this.lblNonHeapMemMax, this.lblNonHeapMemMaxVal);
    private InfoLine[] lines = new InfoLine[]{this.lineOSName, this.lineOSVer, this.lineOSArch, this.lineNumberOfProcessors, this.lineRunningJVMName, this.lineJVMSpecName, this.lineJVMSpecVendor, this.lineJVMSpecVersion, this.lineJavaRuntimeName, this.lineJavaRuntimeVersion, this.lineJVMImplName, this.lineJVMImplVendor, this.lineJVMImplVersion, this.lineThreadCount, this.linePeakThreadCount, this.lineTotalStartedThreadCount, this.lineThreadCPUTimeSupported, this.lineThreadContentionMonitor, this.lineHeapMemInit, this.lineHeapMemUsed, this.lineHeapMemCommitted, this.lineHeapMemMax, this.lineNonHeapMemInit, this.lineNonHeapMemUsed, this.lineNonHeapMemCommitted, this.lineNonHeapMemMax};

    public SystemInfoPanel() {
        this.jbInit();
        this.refresh();
        this.setPreferredSize(new Dimension(440, 520));
    }

    private void jbInit() {
        JPanel pnlRoot = new JPanel(new BorderLayout());
        this.pnlMain.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.pnlMain.setLayout(this.boxLayout);
        InfoLine[] infoLineArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            InfoLine line = infoLineArray[n2];
            line.setBorder(this.border);
            line.setGaps(5, 0);
            this.pnlMain.add(line);
            ++n2;
        }
        pnlRoot.add((Component)this.pnlMain, "North");
        this.scrPane.setViewportView(pnlRoot);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrPane, "Center");
    }

    public void refresh() {
        this.lblThreadCountVal.setText("" + THREAD_MX.getThreadCount());
        this.lblPeakThreadCountVal.setText("" + THREAD_MX.getPeakThreadCount());
        this.lblTotalStartedThreadCountVal.setText("" + THREAD_MX.getTotalStartedThreadCount());
        MemoryUsage memUsage = MEMORY_MX.getHeapMemoryUsage();
        long initMem = memUsage.getInit();
        this.lblHeapMemInitVal.setText(initMem >= 0L ? StrUtil.toTriplets(initMem) : "Undefined");
        this.lblHeapMemUsedVal.setText(StrUtil.toTriplets(memUsage.getUsed()));
        this.lblHeapMemCommittedVal.setText(StrUtil.toTriplets(memUsage.getCommitted()));
        long maxMem = memUsage.getMax();
        this.lblHeapMemMaxVal.setText(maxMem >= 0L ? StrUtil.toTriplets(maxMem) : "Undefined");
        memUsage = MEMORY_MX.getNonHeapMemoryUsage();
        initMem = memUsage.getInit();
        this.lblNonHeapMemInitVal.setText(initMem >= 0L ? StrUtil.toTriplets(initMem) : "Undefined");
        this.lblNonHeapMemUsedVal.setText(StrUtil.toTriplets(memUsage.getUsed()));
        this.lblNonHeapMemCommittedVal.setText(StrUtil.toTriplets(memUsage.getCommitted()));
        maxMem = memUsage.getMax();
        this.lblNonHeapMemMaxVal.setText(maxMem >= 0L ? StrUtil.toTriplets(maxMem) : "Undefined");
    }
}

