/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.gui.settings;

import edu.uml.lgdc.gui.LookAndFeelMgr;
import edu.uml.lgdc.gui.config.InterfaceChangedEvent;
import edu.uml.lgdc.gui.config.InterfaceChangedListener;
import edu.uml.lgdc.gui.settings.DisplayInterfaceSettings_Ix;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.ApplicationProperties;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;

public class DisplayInterfaceSettings
implements Cloneable,
DisplayInterfaceSettings_Ix {
    private boolean qualityRendering;
    private static String lookAndFeel = "Metal";
    private boolean developmentInterfaceEnabled;
    private List<InterfaceChangedListener> listeners = new ArrayList<InterfaceChangedListener>();
    private String prefix = "";

    public DisplayInterfaceSettings() {
        this("");
    }

    public DisplayInterfaceSettings(String prefix) {
        this.prefix = prefix;
        this.setDefaults();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaults() {
        this.qualityRendering = false;
        lookAndFeel = "Metal";
        this.developmentInterfaceEnabled = true;
    }

    @Override
    public void get(ApplicationProperties properties) {
        this.qualityRendering = properties.get(String.valueOf(this.prefix) + "QualityRendering", this.qualityRendering);
        lookAndFeel = properties.get(String.valueOf(this.prefix) + "LookAndFeel", lookAndFeel);
        this.developmentInterfaceEnabled = properties.get(String.valueOf(this.prefix) + "DevelopmentInterfaceEnabled", this.developmentInterfaceEnabled);
    }

    @Override
    public void put(ApplicationProperties properties) {
        properties.put(String.valueOf(this.prefix) + "QualityRendering", this.qualityRendering);
        properties.put(String.valueOf(this.prefix) + "LookAndFeel", lookAndFeel);
        properties.put(String.valueOf(this.prefix) + "DevelopmentInterfaceEnabled", this.developmentInterfaceEnabled);
    }

    public void set(DisplayInterfaceSettings options) {
        this.prefix = options.prefix;
        this.qualityRendering = options.qualityRendering;
        this.developmentInterfaceEnabled = options.developmentInterfaceEnabled;
    }

    @Override
    public Object clone() {
        try {
            DisplayInterfaceSettings options = (DisplayInterfaceSettings)super.clone();
            options.set(this);
            return options;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof DisplayInterfaceSettings) {
            DisplayInterfaceSettings options = (DisplayInterfaceSettings)obj;
            result = this.qualityRendering == options.qualityRendering && lookAndFeel.equals(lookAndFeel) && this.developmentInterfaceEnabled == options.developmentInterfaceEnabled;
        }
        return result;
    }

    @Override
    public boolean getQualityRenderingEnable() {
        return this.qualityRendering;
    }

    @Override
    public void setQualityRenderingEnable(boolean value) {
        this.qualityRendering = value;
    }

    @Override
    public boolean getDevelopmentInterfaceEnabled() {
        return this.developmentInterfaceEnabled;
    }

    public void setDevelopmentInterfaceEnabled(boolean value) {
        this.developmentInterfaceEnabled = value;
        int interfaceType = !this.developmentInterfaceEnabled ? 0 : 1;
        this.fireInterfaceChangedEvent(new InterfaceChangedEvent(this, interfaceType));
    }

    @Override
    public synchronized void addInterfaceChangedListener(InterfaceChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeInterfaceChangedListener(InterfaceChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireInterfaceChangedEvent(InterfaceChangedEvent event) {
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            this.listeners.get(i).interfaceChanged(event);
            --i;
        }
    }

    @Override
    public void startLookAndFeel() {
        if (!UIManager.getLookAndFeel().getName().equals(lookAndFeel) && !LookAndFeelMgr.install(lookAndFeel, false)) {
            Console.showWarn("Can not set up " + lookAndFeel + " Look and Feel, " + "will set up Cross Platform Look and Feel");
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                lookAndFeel = UIManager.getLookAndFeel().getName();
            }
            catch (Exception ex) {
                Console.showError(ex.toString());
            }
        }
    }
}

