/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.https_udl;

import edu.uml.lgdc.https_udl.UdlCourierSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class UdlCourier {
    UdlCourierSettings settings;
    private String errMsg;
    private int requestStatus = -1;

    public UdlCourier(UdlCourierSettings settings) {
        this.settings = settings;
    }

    public boolean deliverOneUdlFile(File file) {
        StringBuilder contentBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                contentBuilder.append(line).append(System.lineSeparator());
            }
            reader.close();
        }
        catch (IOException e) {
            System.err.println("Error reading the file: " + e.getMessage());
        }
        String content = contentBuilder.toString();
        return this.deliverJsonString(content);
    }

    public String getErrMsg() {
        if (this.errMsg == null) {
            return "";
        }
        return this.errMsg;
    }

    public int getRequestStatus() {
        return this.requestStatus;
    }

    public boolean deliverJsonString(String jsonData) {
        block30: {
            this.requestStatus = 999;
            URL url = this.settings.getUrl();
            String basicAuth = this.settings.getEncodedCredentials();
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Content-Type", "application/json; utf-8");
                connection.setDoOutput(true);
                connection.setRequestProperty("Authorization", basicAuth);
                connection.setConnectTimeout(this.settings.getConnectionTimeoutMs());
                connection.setReadTimeout(this.settings.getSocketTimeoutMs());
                connection.setRequestMethod("POST");
            }
            catch (Exception e) {
                this.errMsg = e.getMessage();
                return false;
            }
            try {
                try {
                    Throwable e = null;
                    Object var6_9 = null;
                    try (OutputStream os = connection.getOutputStream();){
                        os.write(jsonData.getBytes(StandardCharsets.UTF_8));
                        this.requestStatus = connection.getResponseCode();
                        if (this.requestStatus < 200 || this.requestStatus > 299) {
                            String inputLine;
                            this.errMsg = "UDL Error " + this.requestStatus + ": ";
                            switch (this.requestStatus) {
                                case 400: {
                                    this.errMsg = String.valueOf(this.errMsg) + "Invalid mapping to target definition";
                                    break;
                                }
                                case 401: 
                                case 407: {
                                    this.errMsg = String.valueOf(this.errMsg) + "Unauthorized, authentication failed";
                                    break;
                                }
                                case 403: {
                                    this.errMsg = String.valueOf(this.errMsg) + "User is not authorized";
                                    break;
                                }
                                case 405: {
                                    this.errMsg = String.valueOf(this.errMsg) + "Method is not allowed";
                                    break;
                                }
                                case 415: {
                                    this.errMsg = String.valueOf(this.errMsg) + "MediaType unsupported";
                                    break;
                                }
                                case 429: {
                                    this.errMsg = String.valueOf(this.errMsg) + "Rate of requests exceeds allowed limit";
                                    break;
                                }
                                case 500: {
                                    this.errMsg = String.valueOf(this.errMsg) + "Internal server error";
                                    break;
                                }
                            }
                            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                            while ((inputLine = in.readLine()) != null) {
                                this.errMsg = String.valueOf(this.errMsg) + " " + inputLine;
                            }
                            in.close();
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    this.errMsg = "Could not set output stream bytes: " + e.getMessage();
                    if (connection != null) {
                        connection.disconnect();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    connection.disconnect();
                }
                throw throwable;
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return this.wasDeliverySuccessful(this.requestStatus);
    }

    private boolean wasDeliverySuccessful(int requestStatus) {
        return requestStatus >= 200 && requestStatus <= 299;
    }
}

