/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.https_udl;

import edu.uml.lgdc.appuserdb.api.UserCredentials;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;

public class UdlCourierSettings {
    private URL url;
    private UserCredentials credentials;
    private int connectionTimeoutMs;
    private int socketTimeoutMs;

    public UdlCourierSettings(String url, UserCredentials credentials, int connectionTimeoutMs, int socketTimeoutMs) {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.credentials = credentials;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public URL getUrl() {
        return this.url;
    }

    public UserCredentials getCredentials() {
        return this.credentials;
    }

    public String getEncodedCredentials() {
        String userCredentials = String.valueOf(this.credentials.getUserLogin()) + ":" + this.credentials.getUserPassword();
        return "Basic " + new String(Base64.getEncoder().encode(userCredentials.getBytes()));
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }
}

