/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.instrument.Payload;
import edu.uml.lgdc.instrument.PayloadPM_Ix;
import edu.uml.lgdc.multithread.BinSemaphore;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;

public class BasicFramer {
    public static final String PAR_PM_PAYLOAD_TYPE = "PeriodicMessagePayloadType";
    public static final String PAR_PM_EXPIRATION_MS = "PeriodicMessageExpriration_ms";
    public static final String PAR_PM_MAX_THRESHOLD_MS = "PeriodicMessageExpriration_ms";
    private static final int PKT_K1 = 0;
    private static final int PKT_K2 = 1;
    private static final int PKT_T = 2;
    private static final int PKT_D = 3;
    private static final int PKT_BYTES_PER_LEN = 2;
    private static final int PACKET_AUX_LENGTH = 3;
    protected BinSemaphore outputSync = null;
    protected OutputStream os;
    protected transient Payload payload;
    protected transient int parseState = 0;
    protected transient int payloadIndex;
    Properties properties = new Properties();

    public BasicFramer(OutputStream os) {
        this.os = os;
        this.outputSync = null;
        this.fillDefaultProperties();
    }

    public BasicFramer(OutputStream os, BinSemaphore sync) {
        this.os = os;
        this.outputSync = sync;
        this.fillDefaultProperties();
    }

    public BasicFramer(OutputStream os, BinSemaphore sync, Properties customProps) {
        this.os = os;
        this.outputSync = sync;
        this.fillDefaultProperties();
        Enumeration<?> enums = customProps.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            String value = customProps.getProperty(key);
            this.properties.put(key, value);
        }
    }

    private void fillDefaultProperties() {
        this.properties.put(PAR_PM_PAYLOAD_TYPE, (Object)-1);
        this.properties.put("PeriodicMessageExpriration_ms", (Object)0);
        this.properties.put("PeriodicMessageExpriration_ms", (Object)0);
    }

    public boolean send(Payload payload) throws IOException {
        try {
            this.sendIt(payload, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public boolean sendWithSync(Payload payload) throws IOException, InterruptedException {
        return this.sendIt(payload, true);
    }

    protected boolean sendIt(Payload payload, boolean syncNeeded) throws IOException, InterruptedException {
        try {
            String expiredMsg;
            if (syncNeeded && this.outputSync != null) {
                this.outputSync.pend(0);
            }
            if ((expiredMsg = this.checkForExpiredPacket(payload)) != null) {
                if (syncNeeded) {
                    this.outputSync.post();
                }
                Console.showError("BasicFramer: " + expiredMsg);
                return false;
            }
            this.payload = payload;
            payload.setReadyToSend();
            this.parseState = 0;
            while (true) {
                int c;
                if ((c = this.getNextPacketByte()) == -1) {
                    this.os.flush();
                    payload = null;
                    break;
                }
                this.os.write((byte)c);
            }
        }
        finally {
            if (syncNeeded && this.outputSync != null) {
                this.outputSync.post();
            }
        }
        return true;
    }

    private int getNextPacketByte() {
        int c = -1;
        switch (this.parseState) {
            case 0: 
            case 1: {
                ++this.parseState;
                c = this.payload.length + 3 >> 8 * (2 - (this.parseState - 0)) & 0xFF;
                break;
            }
            case 2: {
                c = this.payload.type & 0xFF;
                this.payloadIndex = 0;
                this.parseState = 3;
                break;
            }
            case 3: {
                if (this.payloadIndex >= this.payload.length) break;
                c = this.payload.data[this.payloadIndex++] & 0xFF;
            }
        }
        return c;
    }

    protected String checkForExpiredPacket(Payload payload) {
        int periodicMessageType = (Integer)this.properties.get(PAR_PM_PAYLOAD_TYPE);
        if (periodicMessageType == -1) {
            return null;
        }
        int maxThreshold_ms = (Integer)this.properties.get("PeriodicMessageExpriration_ms");
        int expirationTime_ms = (Integer)this.properties.get("PeriodicMessageExpriration_ms");
        if (payload.getType() == periodicMessageType) {
            TimeScale tm = ((PayloadPM_Ix)((Object)payload)).getTime();
            long timeOfPM_ms = tm.getTimeInMilliSeconds();
            long currTime_ms = new TimeScale().getTimeInMilliSeconds();
            if (currTime_ms > timeOfPM_ms + (long)maxThreshold_ms + (long)expirationTime_ms) {
                return "discard obsolete PM, " + tm.toTimestamp();
            }
        }
        return null;
    }
}

