/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.graph.ColorUtils;
import edu.uml.lgdc.instrument.SelfComponentReport_Ix;
import edu.uml.lgdc.math.Search;
import java.awt.Color;

public class Card {
    public static final Color TRUE_GAIN_COLOR_ON_WHITE_BG = new Color(21, 15, 142);
    public static final Color REL_GAIN_COLOR_ON_WHITE_BG = new Color(118, 0, 18);
    public static final Color TRUE_GAIN_COLOR_ON_BLACK_BG = new Color(164, 247, 251);
    public static final Color REL_GAIN_COLOR_ON_BLACK_BG = new Color(245, 250, 80);
    public static final String TRUE_GAIN_HTML_COLOR_ON_WHITE_BG = ColorUtils.getHTMLColor(TRUE_GAIN_COLOR_ON_WHITE_BG);
    public static final String REL_GAIN_HTML_COLOR_ON_WHITE_BG = ColorUtils.getHTMLColor(REL_GAIN_COLOR_ON_WHITE_BG);
    public static final String TRUE_GAIN_HTML_COLOR_ON_BLACK_BG = ColorUtils.getHTMLColor(TRUE_GAIN_COLOR_ON_BLACK_BG);
    public static final String REL_GAIN_HTML_COLOR_ON_BLACK_BG = ColorUtils.getHTMLColor(REL_GAIN_COLOR_ON_BLACK_BG);
    public final String mnem;
    public final String name;
    public final int[] vCodes;
    public final String[] vNames;
    public final String[] vDescs;
    public final String[] vSpecs;
    private final SelfComponentReport_Ix escConfig;
    public final boolean[] includesAmplifier;
    public int[] nonProgrammablePartGain_dB;
    public int[] maxProgrammablePartGain_dB;
    public final int defaultVer;
    public final boolean critical;
    protected String[] vHTMLNames;

    public Card(String mnem, String name, SelfComponentReport_Ix escConfig, int[] vCodes, String[] vNames, String[] vDescs, String[] vSpecs, int defaultVer, boolean critical, boolean[] includesAmplifier, int[] nonProgrammablePartGain_dB, int[] maxProgrammablePartGain_dB) {
        if (mnem == null) {
            throw new IllegalArgumentException("mnem is null");
        }
        if (mnem.trim().length() == 0) {
            throw new IllegalArgumentException("mnem is empty");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        if (vCodes == null) {
            throw new IllegalArgumentException("vCodes is null");
        }
        if (vCodes.length == 0) {
            throw new IllegalArgumentException("vCodes.length == 0");
        }
        if (vNames == null) {
            throw new IllegalArgumentException("vNames is null");
        }
        if (vNames.length == 0) {
            throw new IllegalArgumentException("vNames.length == 0");
        }
        if (vDescs == null) {
            throw new IllegalArgumentException("vDescs is null");
        }
        if (vDescs.length == 0) {
            throw new IllegalArgumentException("vDescs.length == 0");
        }
        if (vSpecs == null) {
            throw new IllegalArgumentException("vSpecs is null");
        }
        if (vSpecs.length == 0) {
            throw new IllegalArgumentException("vSpecs.length == 0");
        }
        if (vCodes.length != vNames.length) {
            throw new IllegalArgumentException("vCodes.length != vNames.length");
        }
        if (vCodes.length != vDescs.length) {
            throw new IllegalArgumentException("vCodes.length != vDescs.length");
        }
        if (vCodes.length != vSpecs.length) {
            throw new IllegalArgumentException("vCodes.length != vSpecs.length");
        }
        this.checkNames(vNames, name);
        this.checkCodes(vCodes, name);
        if (Search.scan(vCodes, defaultVer) < 0) {
            throw new IllegalArgumentException("defaultVer is not in array vCodes");
        }
        if (includesAmplifier != null) {
            if (vCodes.length != includesAmplifier.length) {
                throw new IllegalArgumentException("vCodes.length != includesAmplifier.length");
            }
            if (vCodes.length != nonProgrammablePartGain_dB.length) {
                throw new IllegalArgumentException("vCodes.length != nonProgrammablePartGain_dB.length");
            }
            if (vCodes.length != maxProgrammablePartGain_dB.length) {
                throw new IllegalArgumentException("vCodes.length != maxProgrammablePartGain_dB.length");
            }
        }
        this.mnem = mnem.trim();
        this.name = name.trim();
        this.escConfig = escConfig;
        this.vCodes = vCodes;
        this.vNames = vNames;
        this.vDescs = vDescs;
        this.vSpecs = vSpecs;
        this.defaultVer = defaultVer;
        this.critical = critical;
        if (includesAmplifier == null) {
            this.includesAmplifier = new boolean[vCodes.length];
            this.nonProgrammablePartGain_dB = new int[vCodes.length];
            this.maxProgrammablePartGain_dB = new int[vCodes.length];
        } else {
            this.includesAmplifier = includesAmplifier;
            this.nonProgrammablePartGain_dB = nonProgrammablePartGain_dB;
            this.maxProgrammablePartGain_dB = maxProgrammablePartGain_dB;
        }
    }

    public boolean isLegalVerCode(int verCode) {
        if (verCode == 0) {
            return true;
        }
        return this.getIndexByCode(verCode) >= 0;
    }

    public String getVerName(int verCode) {
        if (verCode == 0) {
            return "Legacy model";
        }
        int index = Search.scan(this.vCodes, verCode);
        if (index >= 0) {
            return this.vNames[index];
        }
        return null;
    }

    public String getHTMLVerName(int verCode) {
        if (verCode == 0) {
            return "Legacy model";
        }
        int index = Search.scan(this.vCodes, verCode);
        if (index >= 0) {
            return this.getHTMLNames()[index];
        }
        return null;
    }

    protected String[] toHTMLNames(String[] names) {
        return names;
    }

    public int getLastVersion() {
        return this.vCodes[this.vCodes.length - 1];
    }

    public int getVersion() {
        int ver = this.getLastVersion();
        if (this.escConfig != null && this.escConfig.isCardPresent(this.mnem)) {
            ver = this.escConfig.getCardVersion(this.mnem);
        }
        return ver;
    }

    public String getVerDescs(int verCode) {
        if (verCode == 0) {
            return "";
        }
        int index = this.getIndexByCode(verCode);
        if (index >= 0) {
            return this.vDescs[index];
        }
        return null;
    }

    public String getVerSpecs(int verCode) {
        if (verCode == 0) {
            return "";
        }
        int index = this.getIndexByCode(verCode);
        if (index >= 0) {
            return this.vSpecs[index];
        }
        return null;
    }

    public boolean isAmplifierIncluded(int verCode) {
        if (verCode == 0) {
            return false;
        }
        int index = this.getIndexByCode(verCode);
        if (index >= 0) {
            return this.includesAmplifier[index];
        }
        return false;
    }

    public int getNonProgrammablePartGain_dB(int verCode) {
        if (verCode == 0) {
            return 0;
        }
        int index = this.getIndexByCode(verCode);
        if (index >= 0) {
            return this.nonProgrammablePartGain_dB[index];
        }
        return 0;
    }

    public int getMaxProgrammablePartGain_dB(int verCode) {
        if (verCode == 0) {
            return 0;
        }
        int index = this.getIndexByCode(verCode);
        if (index >= 0) {
            return this.maxProgrammablePartGain_dB[index];
        }
        return 0;
    }

    public int getIndexByCode(int verCode) {
        return Search.scan(this.vCodes, verCode);
    }

    public String[] getHTMLNames() {
        if (this.vHTMLNames == null) {
            this.vHTMLNames = this.toHTMLNames(this.vNames);
        }
        return this.vHTMLNames;
    }

    private void checkNames(String[] vNames, String cardName) {
        int i = 0;
        while (i < vNames.length) {
            if (vNames[i] == null) {
                throw new IllegalArgumentException("For card " + cardName + ": vNames[" + i + "] is null");
            }
            vNames[i] = vNames[i].trim();
            if (vNames[i].length() == 0) {
                throw new IllegalArgumentException("For card " + cardName + ": vNames[" + i + "] is empty");
            }
            ++i;
        }
    }

    private void checkCodes(int[] vCodes, String cardName) {
        int i = 0;
        while (i < vCodes.length) {
            if (vCodes[i] <= 0) {
                throw new IllegalArgumentException("For card " + cardName + ": vCodes[" + i + "] is <= 0, " + vCodes[i]);
            }
            ++i;
        }
        i = 0;
        while (i < vCodes.length - 1) {
            int j = i + 1;
            while (j < vCodes.length) {
                if (vCodes[i] == vCodes[j]) {
                    throw new IllegalArgumentException("For card " + cardName + ": vCodes[" + i + "] == vCodes[" + j + "]");
                }
                ++j;
            }
            ++i;
        }
    }

    public static String[] getNames(String[] namesWithoutGain, int[] dBValues, boolean totalGain, int nonProgrammableGain_dB) {
        String[] names = new String[namesWithoutGain.length];
        int maxVal = 0;
        int i = 0;
        while (i < dBValues.length) {
            if (Math.abs(dBValues[i]) > maxVal) {
                maxVal = Math.abs(dBValues[i]);
            }
            ++i;
        }
        int outLength = 1 + ("" + maxVal).length();
        int outLength1 = 0;
        if (totalGain && nonProgrammableGain_dB != 0) {
            maxVal = 0;
            int i2 = 0;
            while (i2 < dBValues.length) {
                if (Math.abs(dBValues[i2] - nonProgrammableGain_dB) > maxVal) {
                    maxVal = Math.abs(dBValues[i2] - nonProgrammableGain_dB);
                }
                ++i2;
            }
            outLength1 = 1 + ("" + maxVal).length();
        }
        int i3 = 0;
        while (i3 < names.length) {
            int value;
            names[i3] = "<HTML><FONT FACE=\"COURIER\"";
            if (totalGain) {
                int n = i3;
                names[n] = String.valueOf(names[n]) + " COLOR=\"" + TRUE_GAIN_HTML_COLOR_ON_WHITE_BG + "\">";
                value = dBValues[i3];
            } else {
                int n = i3;
                names[n] = String.valueOf(names[n]) + " COLOR=\"" + REL_GAIN_HTML_COLOR_ON_WHITE_BG + "\">FULL GAIN";
                value = -dBValues[i3];
            }
            if (value != 0) {
                int n = i3;
                names[n] = String.valueOf(names[n]) + StrUtil.padLeftNBSP(value > 0 ? "+" + value : "" + value, outLength) + "dB";
            } else if (totalGain) {
                int n = i3;
                names[n] = String.valueOf(names[n]) + StrUtil.padLeftNBSP("0", outLength) + "dB";
            }
            if (totalGain && nonProgrammableGain_dB != 0) {
                int n = i3;
                names[n] = String.valueOf(names[n]) + " (";
                if ((value -= nonProgrammableGain_dB) != 0) {
                    int n2 = i3;
                    names[n2] = String.valueOf(names[n2]) + StrUtil.padLeftNBSP(value > 0 ? "+" + value : "" + value, outLength1) + "dB,";
                } else {
                    int n3 = i3;
                    names[n3] = String.valueOf(names[n3]) + StrUtil.padLeftNBSP("0", outLength1) + "dB,";
                }
                if (nonProgrammableGain_dB > 0) {
                    int n4 = i3;
                    names[n4] = String.valueOf(names[n4]) + "+" + nonProgrammableGain_dB + "dB)";
                } else {
                    int n5 = i3;
                    names[n5] = String.valueOf(names[n5]) + nonProgrammableGain_dB + "dB)";
                }
            }
            int n = i3;
            names[n] = String.valueOf(names[n]) + "&nbsp;&nbsp;</FONT>";
            if (namesWithoutGain[i3] == null || namesWithoutGain[i3].length() == 0) {
                int n6 = i3;
                names[n6] = String.valueOf(names[n6]) + "</HTML>";
            } else {
                int n7 = i3;
                names[n7] = String.valueOf(names[n7]) + "<I><FONT COLOR=\"#404040\">" + namesWithoutGain[i3] + "</FONT></I></HTML>";
            }
            ++i3;
        }
        return names;
    }

    public int getConstantGainInFront() {
        return 0;
    }
}

