/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.dashboard.ByteBufferUtil;
import edu.uml.lgdc.time.TimeScale;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class InstrumentStatus {
    private int connectStatus;
    private int currentSched;
    private int opState;
    private long badPktCounter;
    private String lastConnectedTime;
    private String progschedUpdatedTime;
    private int dac1Cmd;
    private int dac2Cmd;
    private List<String> cardVersions;

    public InstrumentStatus(int connectStatus, int currentSched, int opState, long badPktCounter, String lastConnectedTime, String progUpTime, int dac1Cmd, int dac2Cmd, List<String> cardVersions) {
        this.connectStatus = connectStatus;
        this.currentSched = currentSched;
        this.opState = opState;
        this.badPktCounter = badPktCounter;
        this.lastConnectedTime = lastConnectedTime;
        this.progschedUpdatedTime = progUpTime;
        this.dac1Cmd = dac1Cmd;
        this.dac2Cmd = dac2Cmd;
        this.cardVersions = cardVersions;
    }

    public InstrumentStatus(byte[] data) {
        ByteBufferUtil bUtil = new ByteBufferUtil();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.connectStatus = bUtil.popIntFromBuffer(buffer);
        this.currentSched = bUtil.popIntFromBuffer(buffer);
        this.opState = bUtil.popIntFromBuffer(buffer);
        this.badPktCounter = bUtil.popLongFromBuffer(buffer);
        this.lastConnectedTime = bUtil.popStringFromBuffer(buffer);
        this.progschedUpdatedTime = bUtil.popStringFromBuffer(buffer);
        this.dac1Cmd = bUtil.popIntFromBuffer(buffer);
        this.dac2Cmd = bUtil.popIntFromBuffer(buffer);
        int numCards = bUtil.popIntFromBuffer(buffer);
        this.cardVersions = new ArrayList<String>();
        int i = 0;
        while (i < numCards) {
            this.cardVersions.add(bUtil.popStringFromBuffer(buffer));
            ++i;
        }
    }

    public byte[] getBytes() {
        ByteBufferUtil bUtil = new ByteBufferUtil();
        ByteBuffer buffer = ByteBuffer.allocate(0);
        buffer = bUtil.pushOntoByteBuffer(this.connectStatus, buffer);
        buffer = bUtil.pushOntoByteBuffer(this.currentSched, buffer);
        buffer = bUtil.pushOntoByteBuffer(this.opState, buffer);
        buffer = bUtil.pushOntoByteBuffer(this.badPktCounter, buffer);
        buffer = bUtil.pushOntoByteBuffer(this.lastConnectedTime, Charset.defaultCharset(), buffer);
        buffer = bUtil.pushOntoByteBuffer(this.progschedUpdatedTime, Charset.defaultCharset(), buffer);
        buffer = bUtil.pushOntoByteBuffer(this.dac1Cmd, buffer);
        buffer = bUtil.pushOntoByteBuffer(this.dac2Cmd, buffer);
        buffer = bUtil.pushOntoByteBuffer(this.cardVersions.size(), buffer);
        for (String cardVersion : this.cardVersions) {
            buffer = bUtil.pushOntoByteBuffer(cardVersion, Charset.defaultCharset(), buffer);
        }
        return buffer.array();
    }

    public void setConnectStatus(int connectedStatus) {
        this.connectStatus = connectedStatus;
    }

    public int getConnectStatus() {
        return this.connectStatus;
    }

    public void setLastConnectedTime(TimeScale time) {
        this.lastConnectedTime = time.getAsString();
    }

    public String getLastConnectedTime() {
        return this.lastConnectedTime;
    }

    public void setBadPktCounter(long num) {
        this.badPktCounter = num;
    }

    public void setCurrentSched(int sched) {
        this.currentSched = sched;
    }

    public void setProgschedUpdatedTime(TimeScale time) {
        this.progschedUpdatedTime = time.getAsString();
    }

    public void setOpState(int opstate) {
        this.opState = opstate;
    }

    public int getOpState() {
        return this.opState;
    }

    public int getDac1Cmd() {
        return this.dac1Cmd;
    }

    public int getDac2Cmd() {
        return this.dac2Cmd;
    }

    public List<String> getCardVersions() {
        return this.cardVersions;
    }
}

