/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.geospace.Azimuth;
import edu.uml.lgdc.geospace.EarthSphere;
import edu.uml.lgdc.instrument.Platform;
import edu.uml.lgdc.instrument.RFTransmitter;
import edu.uml.lgdc.instrument.StationLink;
import edu.uml.lgdc.instrument.constants.TxType;
import edu.uml.lgdc.time.TimeScale;
import java.util.Objects;

public class Observation {
    private final Platform rxStation;
    private final TimeScale referenceTime;
    private final RFTransmitter transmitter;
    private final boolean isVerticalSounding;
    private final double groundDistance_km;
    private final double stationBearing_CW_deg;
    private final double stationBearing_CWnorm_deg;
    private final double midpointLatitude_deg;
    private final double midpointLongitude_deg;
    private int id = -1;

    public Observation(Platform rxStation, TimeScale referenceTime, RFTransmitter transmitter) {
        this.rxStation = Objects.requireNonNull(rxStation);
        this.referenceTime = Objects.requireNonNull(referenceTime);
        this.transmitter = Objects.requireNonNull(transmitter);
        boolean bl = this.isVerticalSounding = transmitter.getTxType() == TxType.DIGISONDE && rxStation.getUrsi().equalsIgnoreCase(transmitter.getCode());
        if (!this.isVerticalSounding) {
            EarthSphere earthSphere = new EarthSphere();
            this.groundDistance_km = earthSphere.distanceOnEarth_km(rxStation.getLatitude(), rxStation.getLongitude(), transmitter.getLatitude_deg(), transmitter.getLongitude_deg());
            double[] mid = earthSphere.midpointOnEarth(rxStation.getLatitude(), rxStation.getLongitude(), transmitter.getLatitude_deg(), transmitter.getLongitude_deg());
            this.midpointLatitude_deg = mid[0];
            this.midpointLongitude_deg = mid[1];
            Azimuth azimuth = new Azimuth();
            azimuth.calc(rxStation.getLatitude(), rxStation.getLongitude(), transmitter.getLatitude_deg(), transmitter.getLongitude_deg());
            this.stationBearing_CW_deg = azimuth.getCWazimuth_deg();
            this.stationBearing_CWnorm_deg = azimuth.getNormCWazimuth_deg();
        } else {
            this.groundDistance_km = 0.0;
            this.stationBearing_CWnorm_deg = Double.NaN;
            this.stationBearing_CW_deg = Double.NaN;
            this.midpointLatitude_deg = rxStation.getLatitude();
            this.midpointLongitude_deg = rxStation.getLongitude();
        }
    }

    public Platform getRxStation() {
        return this.rxStation;
    }

    public TimeScale getReferenceTime() {
        return this.referenceTime;
    }

    public RFTransmitter getTransmitter() {
        return this.transmitter;
    }

    public boolean isVerticalSounding() {
        return this.isVerticalSounding;
    }

    public double getGroundDistance_km() {
        return this.groundDistance_km;
    }

    public double getStationBearing_CW_deg() {
        return this.stationBearing_CW_deg;
    }

    public double getStationBearing_CWnorm_deg() {
        return this.stationBearing_CWnorm_deg;
    }

    public double getMidpointLatitude_deg() {
        return this.midpointLatitude_deg;
    }

    public double getMidpointLongitude_deg() {
        return this.midpointLongitude_deg;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public StationLink getStationLink() {
        return new StationLink(this.rxStation, this.transmitter);
    }

    public String toString() {
        return Formatter.format("New record at %s, %s<--%s (%d km), TX bearing %.1f deg CW", this.referenceTime.toHumanUT(), this.rxStation.getUrsi(), this.transmitter.getCode(), (int)this.groundDistance_km, this.getStationBearing_CW_deg());
    }
}

