/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.gui.dialogs.BrowseFile;
import edu.uml.lgdc.gui.panels.EventEnabledPanel;
import edu.uml.lgdc.instrument.PacketStreamOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class PacketStreamOptionsPanel
extends EventEnabledPanel {
    private PacketStreamOptions options = null;
    private PacketStreamOptions prevOptions = null;
    private boolean changed = false;
    private Border border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Packet Stream options", 2, 2);
    private GridLayout gridLayout = new GridLayout(0, 1);
    private JCheckBox ckbSaveInboundPackets = new JCheckBox();
    private JTextField tfInboundFilename = new JTextField();
    private JButton btnInboundFilename = new JButton();
    private JPanel pnlInboundFilename = new JPanel();
    private JCheckBox ckbSaveOutboundPackets = new JCheckBox();
    private JTextField tfOutboundFilename = new JTextField();
    private JButton btnOutboundFilename = new JButton();
    private JPanel pnlOutboundFilename = new JPanel();
    private Frame frame;

    public PacketStreamOptionsPanel() {
        this((PacketStreamOptions)null);
    }

    public PacketStreamOptionsPanel(PacketStreamOptions options) {
        this.init(options);
    }

    public void setFields(PacketStreamOptions options) {
        this.options = options;
        this.prevOptions = (PacketStreamOptions)options.clone();
        this.changed = false;
        this.ckbSaveInboundPackets.setSelected(options.getSaveInboundEnabled());
        this.tfInboundFilename.setText(options.getInboundFilename());
        this.ckbSaveOutboundPackets.setSelected(options.getSaveOutboundEnabled());
        this.tfOutboundFilename.setText(options.getOutboundFilename());
    }

    private boolean init(PacketStreamOptions options) {
        boolean result = true;
        this.guiInit();
        if (options != null) {
            this.setFields(options);
        }
        this.requestFocus();
        return result;
    }

    private void guiInit() {
        this.ckbSaveInboundPackets.setText("Write inbound packets to the file:");
        this.ckbSaveInboundPackets.setSelected(false);
        this.tfInboundFilename.setText("InboundPackets.pkt");
        this.tfInboundFilename.setColumns(30);
        this.tfInboundFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PacketStreamOptionsPanel.this.common_actionPerformed(e);
            }
        });
        this.btnInboundFilename.setText("Browse...");
        this.btnInboundFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PacketStreamOptionsPanel.this.btnInboundFilename_actionPerformed(e);
            }
        });
        this.btnInboundFilename.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                PacketStreamOptionsPanel.this.btnInboundFilename_actionPerformed(null);
            }
        });
        this.pnlInboundFilename.add(this.tfInboundFilename);
        this.pnlInboundFilename.add(this.btnInboundFilename);
        this.ckbSaveOutboundPackets.setText("Write outbound packets to the file:");
        this.ckbSaveOutboundPackets.setSelected(false);
        this.tfOutboundFilename.setText("OutboundPackets.pkt");
        this.tfOutboundFilename.setColumns(30);
        this.tfOutboundFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PacketStreamOptionsPanel.this.common_actionPerformed(e);
            }
        });
        this.btnOutboundFilename.setText("Browse...");
        this.btnOutboundFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PacketStreamOptionsPanel.this.btnOutboundFilename_actionPerformed(e);
            }
        });
        this.btnOutboundFilename.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                PacketStreamOptionsPanel.this.btnOutboundFilename_actionPerformed(null);
            }
        });
        this.pnlOutboundFilename.add(this.tfOutboundFilename);
        this.pnlOutboundFilename.add(this.btnOutboundFilename);
        this.setBorder(this.border);
        this.setLayout(this.gridLayout);
        this.add((Component)this.ckbSaveInboundPackets, null);
        this.add((Component)this.pnlInboundFilename, null);
        this.add((Component)this.ckbSaveOutboundPackets, null);
        this.add((Component)this.pnlOutboundFilename, null);
    }

    public String check() {
        File outbound;
        File inbound = new File(this.tfInboundFilename.getText().trim());
        if (inbound.equals(outbound = new File(this.tfOutboundFilename.getText().trim()))) {
            return "inbound filename is equal to outbound filename";
        }
        return null;
    }

    public void accept() {
        this.options.setSaveInboundEnabled(this.ckbSaveInboundPackets.isSelected());
        this.options.setSaveOutboundEnabled(this.ckbSaveOutboundPackets.isSelected());
        this.options.setInboundFilename(this.tfInboundFilename.getText());
        this.options.setOutboundFilename(this.tfOutboundFilename.getText());
        this.changed = !this.options.equals(this.prevOptions);
    }

    public void reset() {
        this.setFields(this.options);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public PacketStreamOptions getOptions() {
        return this.options;
    }

    public boolean isChangedSaveInboundPackets() {
        return this.options.getSaveInboundEnabled() ^ this.prevOptions.getSaveInboundEnabled();
    }

    public boolean isChangedSaveOutboundPackets() {
        return this.options.getSaveOutboundEnabled() ^ this.prevOptions.getSaveOutboundEnabled();
    }

    public boolean isChangedInboundFilename() {
        return !this.options.getInboundFilename().equals(this.prevOptions.getInboundFilename());
    }

    public boolean isChangedOutboundFilename() {
        return !this.options.getOutboundFilename().equals(this.prevOptions.getOutboundFilename());
    }

    @Override
    public void requestFocus() {
        this.ckbSaveInboundPackets.requestFocus();
    }

    private void common_actionPerformed(ActionEvent e) {
        this.generateExternal_actionPerformed(e);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    private void btnInboundFilename_actionPerformed(ActionEvent e) {
        String fileName = BrowseFile.browseFile(this.frame, this.tfInboundFilename.getText(), 1);
        if (fileName != null) {
            this.tfInboundFilename.setText(fileName);
        }
    }

    private void btnOutboundFilename_actionPerformed(ActionEvent e) {
        String fileName = BrowseFile.browseFile(this.frame, this.tfOutboundFilename.getText(), 1);
        if (fileName != null) {
            this.tfOutboundFilename.setText(fileName);
        }
    }
}

