/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.dashboard.ByteBufferUtil;
import edu.uml.lgdc.instrument.BadPacketLengthException;
import edu.uml.lgdc.instrument.BasicParser;
import edu.uml.lgdc.instrument.IdentifiesPayloads;
import edu.uml.lgdc.instrument.Payload;
import edu.uml.lgdc.multithread.MSQueue;
import edu.uml.lgdc.multithread.Semaphore;
import edu.uml.lgdc.project.Console;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class PayloadParser
extends Thread {
    private String className;
    private IdentifiesPayloads payloadIdentifier;
    private BasicParser parser;
    private MSQueue responseQueue;
    private Semaphore terminated;
    private boolean eos = false;

    public PayloadParser(IdentifiesPayloads payloadIdentifier, BasicParser parser, MSQueue responseQueue, Semaphore terminated) {
        super("PayloadParser");
        this.payloadIdentifier = payloadIdentifier;
        this.className = this.getClass().getSimpleName();
        if (parser == null) {
            throw new IllegalArgumentException(String.valueOf(this.className) + ": parser is null");
        }
        if (responseQueue == null) {
            throw new IllegalArgumentException(String.valueOf(this.className) + ": responseQueue is null.");
        }
        this.parser = parser;
        this.responseQueue = responseQueue;
        this.terminated = terminated;
    }

    public PayloadParser(String payloadParserName, IdentifiesPayloads payloadIdentifier, BasicParser parser, MSQueue responseQueue, Semaphore terminated) {
        super(payloadParserName);
        this.payloadIdentifier = payloadIdentifier;
        this.className = this.getClass().getSimpleName();
        if (parser == null) {
            throw new IllegalArgumentException(String.valueOf(this.className) + ": parser is null");
        }
        if (responseQueue == null) {
            throw new IllegalArgumentException(String.valueOf(this.className) + ": responseQueue is null.");
        }
        this.parser = parser;
        this.responseQueue = responseQueue;
        this.terminated = terminated;
    }

    @Override
    public void run() {
        Payload payload = null;
        boolean ok = true;
        Throwable err = null;
        this.eos = false;
        while (ok) {
            try {
                payload = new Payload();
                if (!this.parser.receive(payload)) {
                    this.eos = true;
                    break;
                }
                this.resizePayloadData(payload);
                this.identifyAndHandle(payload);
            }
            catch (IOException e) {
                if (e instanceof BadPacketLengthException) continue;
                ok = false;
                Console.showError(String.valueOf(this.className) + ": ended because of " + e);
            }
            catch (Throwable e) {
                Console.printThreadStackTrace(e);
                err = e;
                ok = false;
                break;
            }
        }
        if (this.eos && !(this.parser.getInputStream() instanceof FileInputStream)) {
            Console.showWarn(String.valueOf(this.className) + ": End Of Stream received");
        }
        if (this.terminated != null) {
            this.terminated.post();
        }
        if (err != null) {
            Console.showMsg(String.valueOf(this.className) + ": " + err.getMessage() + " error");
            if (err instanceof ThreadDeath) {
                throw new ThreadDeath();
            }
        }
    }

    private void resizePayloadData(Payload payload) {
        if (payload.length > 0) {
            ByteBufferUtil bUtil = new ByteBufferUtil();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            buffer = bUtil.pushOntoByteBuffer(payload.data, payload.length, buffer);
            payload.setPayload(payload.type, payload.length, buffer.array(), payload.out);
        }
    }

    private void identifyAndHandle(Payload genericPayload) throws InterruptedException {
        Payload specificPayload = this.identifyAndCreateSpecificPayload(genericPayload);
        if (specificPayload != null) {
            if (this.ifToBeSent(specificPayload)) {
                this.responseQueue.post(specificPayload);
            } else {
                specificPayload.handle(this.responseQueue);
            }
        } else {
            Console.showError(String.valueOf(this.className) + ": Unable to identify payload");
        }
    }

    private boolean ifToBeSent(Payload specificPayload) {
        return specificPayload.getOut();
    }

    private Payload identifyAndCreateSpecificPayload(Payload genericPayload) {
        int type = genericPayload.getType();
        byte[] data = genericPayload.getData();
        int length = genericPayload.getLength();
        return this.payloadIdentifier.identifyAndCreatePayload(type, data, length);
    }

    public void setParserName(String name) {
        this.className = name;
    }
}

