/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.instrument;

import edu.uml.lgdc.format.FC;

public class StationLocation
implements Comparable<StationLocation> {
    private String ursi;
    private String name;
    private double lat = 9999.0;
    private double lon = 9999.0;
    private int didbaseIdent = -1;
    private String wmoid1;
    private String wmoid2;
    private String wmoid3;
    private String udlIdSensor;
    private String udlClassification;

    public StationLocation() {
    }

    public StationLocation(String ursi, String name, double lat, double lon, int databaseIdent) {
        this(ursi, name, lat, lon, databaseIdent, null, null, null);
    }

    public StationLocation(String ursi, String name, String udlIdSensor, String udlClassification, double lat, double lon, int databaseIdent) {
        this(ursi, name, lat, lon, databaseIdent, null, null, null);
        this.udlIdSensor = udlIdSensor;
        this.udlClassification = udlClassification;
    }

    public StationLocation(String ursi, String name, double lat, double lon, int databaseIdent, String wmoid1, String wmoid2, String wmoid3) {
        this.setUrsi(ursi);
        this.setName(name);
        this.setLat(lat);
        this.setLon(lon);
        this.setDidbaseIdent(databaseIdent);
        this.setWmoid1(wmoid1);
        this.setWmoid2(wmoid2);
        this.setWmoid3(wmoid3);
    }

    public StationLocation(StationLocation location) {
        this.ursi = new String(location.ursi);
        this.name = new String(location.name);
        this.lat = location.lat;
        this.lon = location.lon;
        this.didbaseIdent = location.didbaseIdent;
        this.wmoid1 = new String(location.wmoid1);
        this.wmoid2 = new String(location.wmoid2);
        this.wmoid3 = new String(location.wmoid3);
    }

    public boolean isNull() {
        return this.ursi == null && this.name == null && this.lat == 9999.0 && this.lon == 9999.0;
    }

    public String getUrsi() {
        return this.ursi;
    }

    public void setUrsi(String ursi) {
        this.ursi = ursi;
    }

    public String getUdlIdSensor() {
        return this.udlIdSensor != null ? this.udlIdSensor : "";
    }

    public void setUdlIdSensor(String udlIdSensor) {
        this.udlIdSensor = udlIdSensor;
    }

    public String getUdlClassification() {
        return this.udlClassification != null ? this.udlClassification : "";
    }

    public void setUdlClassification(String classification) {
        this.udlClassification = classification;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public int getDidbaseIdent() {
        return this.didbaseIdent;
    }

    public void setDidbaseIdent(int didbaseIdent) {
        this.didbaseIdent = didbaseIdent;
    }

    public String getWmoid1() {
        return this.wmoid1;
    }

    public void setWmoid1(String wmoid1) {
        this.wmoid1 = wmoid1;
    }

    public String getWmoid2() {
        return this.wmoid2;
    }

    public void setWmoid2(String wmoid2) {
        this.wmoid2 = wmoid2;
    }

    public String getWmoid3() {
        return this.wmoid3;
    }

    public void setWmoid3(String wmoid3) {
        this.wmoid3 = wmoid3;
    }

    public String toString() {
        return this.name + "(" + this.ursi + ") " + this.toShortString();
    }

    public String toShortString() {
        return String.valueOf(FC.doubleToString(this.lat, 2)) + "N " + FC.doubleToString(this.lon, 2) + "E";
    }

    @Override
    public int compareTo(StationLocation arg0) {
        return this.ursi.compareTo(arg0.getUrsi());
    }
}

