/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.java;

import edu.uml.lgdc.time.TimeScale;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;

public class DeadLock {
    public static String checkDeadlock() {
        String text = new TimeScale().toUT();
        long[] deadlockedThreads = ManagementFactory.getThreadMXBean().findMonitorDeadlockedThreads();
        if (deadlockedThreads == null) {
            text = String.valueOf(text) + "\nNo monitor deadlocked threads were detected";
        } else {
            text = String.valueOf(text) + "\n" + deadlockedThreads.length + " monitor deadlocked threads were found:";
            ThreadInfo[] threadinfo = new ThreadInfo[deadlockedThreads.length];
            int i = 0;
            while (i < deadlockedThreads.length) {
                threadinfo[i] = ManagementFactory.getThreadMXBean().getThreadInfo(deadlockedThreads[i], Integer.MAX_VALUE);
                text = String.valueOf(text) + "\n\t" + threadinfo[i].getThreadName() + " (Id=" + threadinfo[i].getThreadId() + ", state=" + (Object)((Object)threadinfo[i].getThreadState());
                if (threadinfo[i].getLockName() != null) {
                    text = String.valueOf(text) + " on " + threadinfo[i].getLockName();
                    if (threadinfo[i].getLockOwnerName() != null) {
                        text = String.valueOf(text) + " owned by " + threadinfo[i].getLockOwnerName();
                    }
                }
                text = String.valueOf(text) + ")";
                ++i;
            }
            i = 0;
            while (i < deadlockedThreads.length) {
                text = String.valueOf(text) + "\n\nStack of thread " + threadinfo[i].getThreadName();
                StackTraceElement[] stackTraceElementArray = threadinfo[i].getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    text = String.valueOf(text) + "\n" + element;
                    ++n2;
                }
                ++i;
            }
        }
        return text;
    }
}

