/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.instrument.AbstractPlatform;
import edu.uml.lgdc.list.BasicRecordList;
import edu.uml.lgdc.list.CRB;
import edu.uml.lgdc.list.DataChangedEventProducer;
import edu.uml.lgdc.list.DataChangedListener;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.time.TimeScale;
import edu.uml.lgdc.time.TimeType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class BasicDataList<S extends AbstractPlatform, E extends TimeOrderedMetric> {
    protected List<S> stations = new ArrayList<S>();
    protected List<BasicRecordList<E>> recordLists = new ArrayList<BasicRecordList<E>>();
    private List<CRB<S, E>> vCRB = new ArrayList<CRB<S, E>>();
    private DataChangedEventProducer dataChangedEventProducer;

    public BasicDataList() {
        this.initData();
    }

    public void initData() {
        this.saveCurrents();
        this.stations = new ArrayList<S>();
        this.recordLists = new ArrayList<BasicRecordList<E>>();
    }

    public void setDataChangedEventProducer(DataChangedEventProducer dataChangedEventProducer) {
        this.dataChangedEventProducer = dataChangedEventProducer;
    }

    public void addDataChangedListener(DataChangedListener listener) {
        if (this.dataChangedEventProducer == null) {
            throw new RuntimeException("DataChangedEventProducer was not set");
        }
        this.dataChangedEventProducer.add(listener);
    }

    public void removeDataChangedListener(DataChangedListener listener) {
        if (this.dataChangedEventProducer == null) {
            throw new RuntimeException("DataChangedEventProducer was not set");
        }
        this.dataChangedEventProducer.remove(listener);
    }

    public abstract E createRecord(double var1);

    public abstract BasicRecordList<E> createRecordList();

    public abstract String getDataTypeMnemonic();

    public E createRecord(TimeScale time) {
        return this.createRecord(time.getTimeInMinutes());
    }

    public void addCRB(CRB<S, E> crb) {
        this.vCRB.add(crb);
        crb.restore();
    }

    public void removeCRB(CRB<S, E> crb) {
        this.vCRB.remove(crb);
    }

    public void saveCurrents() {
        int i = 0;
        while (i < this.vCRB.size()) {
            this.vCRB.get(i).save();
            ++i;
        }
    }

    public void restoreCurrents() {
        int i = 0;
        while (i < this.vCRB.size()) {
            this.vCRB.get(i).restore();
            ++i;
        }
    }

    public List<S> getStations() {
        return this.stations;
    }

    public int getStationsQty() {
        return this.stations.size();
    }

    public BasicRecordList<E> getRecordList(int stInd) {
        if (stInd < 0 || stInd >= this.stations.size()) {
            return null;
        }
        return this.recordLists.get(stInd);
    }

    public int getSize(int stInd) {
        if (stInd < 0 || stInd >= this.stations.size()) {
            return 0;
        }
        return this.recordLists.get(stInd).totalRecords();
    }

    public int getTotalSize() {
        int qty = 0;
        int i = 0;
        while (i < this.getStationsQty()) {
            qty += this.getSize(i);
            ++i;
        }
        return qty;
    }

    public double getTimeInMinutes(int stInd, int index) {
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            return this.getRecordList(stInd).getTimeInMinutes(index);
        }
        return Double.NaN;
    }

    public TimeScale getTime(int stInd, int index) {
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            return this.getRecordList(stInd).getTime(index);
        }
        return null;
    }

    public int delete(S station, double timeInMinutes) {
        int stInd = this.getStationIndex(station);
        return this.delete(stInd, this.indexOf(stInd, timeInMinutes));
    }

    public int delete(int stInd, int index) {
        BasicRecordList<E> recordList;
        int deleteCode = 0;
        if (stInd >= 0 && stInd < this.getStationsQty() && (deleteCode = (recordList = this.getRecordList(stInd)).delete(index)) == 2) {
            this.stations.remove(stInd);
            this.recordLists.remove(stInd);
        }
        return deleteCode;
    }

    public int deleteStation(int stInd) {
        this.saveCurrents();
        int deleteCode = 0;
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            deleteCode = 1;
            this.stations.remove(stInd);
            this.recordLists.remove(stInd);
            if (this.stations.size() == 0) {
                deleteCode = 2;
            }
            int i = 0;
            while (i < this.vCRB.size()) {
                this.vCRB.get(i).remove_Station(stInd);
                ++i;
            }
        }
        return deleteCode;
    }

    public double getFirstTimeInMinutes(int stInd) {
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            return this.getRecordList(stInd).getFirstTimeInMinutes();
        }
        return Double.NaN;
    }

    public TimeScale getFirstTime(int stInd) {
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            return this.getRecordList(stInd).getFirstTime();
        }
        return null;
    }

    public double getLastTimeInMinutes(int stInd) {
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            return this.getRecordList(stInd).getLastTimeInMinutes();
        }
        return Double.NaN;
    }

    public TimeScale getLastTime(int stInd) {
        if (stInd >= 0 && stInd <= this.getStationsQty()) {
            return this.getRecordList(stInd).getLastTime();
        }
        return null;
    }

    public int getRightNearest(int stInd, TimeScale time) {
        if (stInd < 0 || stInd >= this.stations.size() || this.getSize(stInd) == 0) {
            return -1;
        }
        return this.recordLists.get(stInd).getRightNearest(time);
    }

    public int getLeftNearest(int stInd, TimeScale time) {
        if (stInd < 0 || stInd >= this.stations.size() || this.getSize(stInd) == 0) {
            return -1;
        }
        return this.recordLists.get(stInd).getLeftNearest(time);
    }

    public int getClosest(int stInd, TimeScale time) {
        if (stInd < 0 || stInd >= this.stations.size() || this.getSize(stInd) == 0) {
            return -1;
        }
        return this.recordLists.get(stInd).getClosest(time);
    }

    public int indexOf(int stInd, E record) {
        if (stInd < 0 || stInd >= this.stations.size() || this.getSize(stInd) == 0 || record == null) {
            return -1;
        }
        return this.recordLists.get(stInd).indexOf(record);
    }

    public int indexOf(int stInd, E record, int startInd, int endInd) {
        if (stInd < 0 || stInd >= this.stations.size() || this.getSize(stInd) == 0 || record == null) {
            return -1;
        }
        return this.recordLists.get(stInd).indexOf(record, startInd, endInd);
    }

    public double getMostProbableInterval(int stInd) {
        return BasicDataList.getMostProbableInterval(this.getRecordList(stInd));
    }

    public double getMostProbableInterval(int stInd, int ind1, int ind2) {
        return BasicDataList.getMostProbableInterval(this.getRecordList(stInd), ind1, ind2);
    }

    public double getMostProbableInterval(int stInd, TimeScale t1, TimeScale t2) {
        return BasicDataList.getMostProbableInterval(this.getRecordList(stInd), t1, t2);
    }

    public static <E extends TimeOrderedMetric> double getMostProbableInterval(BasicRecordList<E> recordList) {
        return recordList.getMostProbableInterval();
    }

    public static <E extends TimeOrderedMetric> double getMostProbableInterval(BasicRecordList<E> recordList, int ind1, int ind2) {
        return recordList.getMostProbableInterval(ind1, ind2);
    }

    public static <E extends TimeOrderedMetric> double getMostProbableInterval(BasicRecordList<E> recordList, TimeScale t1, TimeScale t2) {
        return recordList.getMostProbableInterval(t1, t2);
    }

    public boolean isEmpty(int stInd) {
        return this.getSize(stInd) == 0;
    }

    public boolean isTotalEmpty() {
        return this.stations.size() == 0;
    }

    public S getStation(int ind) {
        AbstractPlatform station = null;
        if (ind >= 0 && ind < this.stations.size()) {
            station = (AbstractPlatform)this.stations.get(ind);
        }
        return (S)station;
    }

    public double getLocalTimeShiftInMin(int stInd, TimeType LocalTimeType) {
        double shift = 0.0;
        if (stInd >= 0 && stInd < this.stations.size()) {
            shift = ((AbstractPlatform)this.stations.get(stInd)).getLocalTimeShiftInMin(LocalTimeType);
        }
        return shift;
    }

    public int getStationIndex(String uniqueName) {
        if (uniqueName != null) {
            int index = -1;
            int i = 0;
            while (i < this.stations.size()) {
                if (((AbstractPlatform)this.stations.get(i)).equals(uniqueName)) {
                    index = i;
                    break;
                }
                ++i;
            }
            return index;
        }
        return -1;
    }

    public int getStationIndex(S station) {
        if (station != null) {
            return this.stations.indexOf(station);
        }
        return -1;
    }

    public E getRecord(String station, int ind) {
        return this.getRecord(this.getStationIndex(station), ind);
    }

    public E getRecord(int stInd, String timeStr) {
        return this.getRecord(stInd, new TimeScale(timeStr));
    }

    public E getRecord(int stInd, TimeScale time) {
        return this.getRecord(stInd, this.indexOf(stInd, time));
    }

    public int indexOf(int stInd, String timeStr) {
        return this.indexOf(stInd, new TimeScale(timeStr));
    }

    public int indexOf(int stInd, double timeInMinutes) {
        return this.indexOf(stInd, this.createRecord(timeInMinutes));
    }

    public int indexOf(int stInd, TimeScale time) {
        return this.indexOf(stInd, this.createRecord(time));
    }

    public E getRecord(int stInd, int ind) {
        if (stInd >= 0 && stInd < this.stations.size() && ind >= 0) {
            return this.recordLists.get(stInd).getRecord(ind);
        }
        return null;
    }

    public void leaveElements(int stInd, TimeScale start, TimeScale end, int offsetInSeconds, int stepInSeconds, int windowInSeconds) {
        if (stInd >= 0 && stInd < this.stations.size()) {
            BasicRecordList<E> recordList = this.recordLists.get(stInd);
            recordList.leaveElements(start, end, offsetInSeconds, stepInSeconds, windowInSeconds);
            if (recordList.totalRecords() == 0) {
                this.deleteStation(stInd);
            }
        }
    }

    public boolean add(E record, S station) {
        BasicRecordList<E> recordList;
        boolean added = false;
        int index = this.getStationIndex(station);
        boolean newStation = false;
        if (index >= 0) {
            recordList = this.recordLists.get(index);
            S masterCopyStation = this.getStation(index);
            if (masterCopyStation.getUniqueCode() == -1) {
                if (station.getUniqueCode() != -1) {
                    masterCopyStation.setUniqueCode(station.getUniqueCode());
                }
            } else if (station.getUniqueCode() != -1 && station.getUniqueCode() != masterCopyStation.getUniqueCode()) {
                System.out.println("The same station (" + masterCopyStation.getUniqueName() + ") with different SID encountered!");
            }
        } else {
            newStation = true;
            recordList = this.createRecordList();
        }
        boolean bl = added = recordList.addRecord(record) >= 0;
        if (newStation) {
            this.addNewStation(station, recordList);
        }
        return added;
    }

    protected int addNewStation(S station, BasicRecordList<E> recordList) {
        int pos = -1;
        int i = 0;
        while (i < this.stations.size()) {
            if (station.compareTo((AbstractPlatform)this.stations.get(i)) < 0) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos >= 0) {
            this.stations.add(pos, station);
            this.recordLists.add(pos, recordList);
        } else {
            this.stations.add(station);
            this.recordLists.add(recordList);
        }
        return pos;
    }

    public String createFullFileName(int stInd, int ind) {
        String name = this.createFileName(stInd, ind);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createFullTempFileName(int stInd, int ind) {
        String name = this.createTempFileName(stInd, ind);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createName(int stInd, int ind) {
        if (stInd >= 0 && stInd < this.stations.size() && ind >= 0) {
            return this.recordLists.get(stInd).createName(ind);
        }
        return null;
    }

    public String createTempName(int stInd, int ind) {
        if (stInd >= 0 && stInd < this.stations.size() && ind >= 0) {
            return this.recordLists.get(stInd).createTempName(ind);
        }
        return null;
    }

    public String createFileName(int stInd, int ind) {
        if (stInd >= 0 && stInd < this.stations.size() && ind >= 0) {
            return this.recordLists.get(stInd).createFileName(ind);
        }
        return null;
    }

    public String createTempFileName(int stInd, int ind) {
        if (stInd >= 0 && stInd < this.stations.size() && ind >= 0) {
            return this.recordLists.get(stInd).createTempFileName(ind);
        }
        return null;
    }

    public String createFullFileName(int stInd, int ind1, int ind2) {
        String name = this.createFileName(stInd, ind1, ind2);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createFullTempFileName(int stInd, int ind1, int ind2) {
        String name = this.createTempFileName(stInd, ind1, ind2);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createName(int stInd, int ind1, int ind2) {
        return this.create_Name(stInd, ind1, ind2);
    }

    public String createTempName(int stInd, int ind1, int ind2) {
        return this.create_Name(stInd, ind1, ind2);
    }

    public String createFileName(int stInd, int ind1, int ind2) {
        return this.create_FileName(stInd, ind1, ind2);
    }

    public String createTempFileName(int stInd, int ind1, int ind2) {
        return this.create_FileName(stInd, ind1, ind2);
    }

    private String create_Name(int stInd, int ind1, int ind2) {
        String recName;
        if (ind1 == ind2) {
            return this.createName(stInd, ind1);
        }
        String name = null;
        if (stInd >= 0 && stInd < this.stations.size() && ind1 >= 0 && ind2 >= 0 && (recName = this.recordLists.get(stInd).createName(ind1, ind2)) != null) {
            String mn = this.getDataTypeMnemonic();
            name = String.valueOf(this.getStation(stInd).getUrsi()) + "_" + recName + (mn.length() > 0 ? "_" + mn : "");
        }
        return name;
    }

    private String create_FileName(int stInd, int ind1, int ind2) {
        String recName;
        if (ind1 == ind2) {
            return this.createFileName(stInd, ind1);
        }
        String name = null;
        if (stInd >= 0 && stInd < this.stations.size() && ind1 >= 0 && ind2 >= 0 && (recName = this.recordLists.get(stInd).createFileName(ind1, ind2)) != null) {
            String mn = this.getDataTypeMnemonic();
            name = String.valueOf(this.getStation(stInd).getUrsi()) + "_" + recName + (mn.length() > 0 ? "." + mn : "");
        }
        return name;
    }

    public String createFullFileName(int stationIndex) {
        String name = this.createFileName(stationIndex);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createFullTempFileName(int stationIndex) {
        String name = this.createTempFileName(stationIndex);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createName(int stationIndex) {
        return this.create_Name(stationIndex);
    }

    public String createTempName(int stationIndex) {
        return this.create_Name(stationIndex);
    }

    public String createFileName(int stationIndex) {
        return this.create_FileName(stationIndex);
    }

    public String createTempFileName(int stationIndex) {
        return this.create_FileName(stationIndex);
    }

    private String create_Name(int stationIndex) {
        BasicRecordList<E> recordList;
        String name = null;
        if (stationIndex >= 0 && stationIndex < this.stations.size() && (recordList = this.recordLists.get(stationIndex)).totalRecords() > 0) {
            name = this.createName(stationIndex, 0, recordList.totalRecords() - 1);
        }
        return name;
    }

    private String create_FileName(int stationIndex) {
        BasicRecordList<E> recordList;
        String name = null;
        if (stationIndex >= 0 && stationIndex < this.stations.size() && (recordList = this.recordLists.get(stationIndex)).totalRecords() > 0) {
            name = this.createFileName(stationIndex, 0, recordList.totalRecords() - 1);
        }
        return name;
    }
}

