/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.ArrVec;
import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.math.Statistic;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class BasicRecordList<E extends TimeOrderedMetric> {
    public static final int DELETE_NO = 0;
    public static final int DELETE_YES_NOT_LAST = 1;
    public static final int DELETE_YES_LAST = 2;
    protected List<E> list = new ArrayList(1024);

    public abstract E createRecord(double var1);

    public abstract BasicRecordList<E> createRecordList();

    public E createRecord(TimeScale time) {
        return this.createRecord(time.getTimeInMinutes());
    }

    public List<E> getList() {
        return this.list;
    }

    public int totalRecords() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    public double getTimeInMinutes(int index) {
        if (index >= 0 && index < this.totalRecords()) {
            return this.getRecord(index).getTimeInMinutes();
        }
        return Double.NaN;
    }

    public TimeScale getTime(int index) {
        if (index >= 0 && index < this.totalRecords()) {
            return ((TimeOrderedMetric)this.getRecord(index)).getTime();
        }
        return null;
    }

    public int delete(double timeInMinutes) {
        return this.delete(this.indexOf(timeInMinutes));
    }

    public int delete(TimeScale time) {
        return this.delete(this.indexOf(time));
    }

    public int delete(E record) {
        return this.delete(this.indexOf(record));
    }

    public int delete(int index) {
        int deleteCode = 0;
        if (index >= 0 && index < this.totalRecords()) {
            deleteCode = 1;
            this.remove_Record(index);
            if (this.totalRecords() == 0) {
                deleteCode = 2;
            }
        }
        return deleteCode;
    }

    public double getFirstTimeInMinutes() {
        return this.getTimeInMinutes(0);
    }

    public TimeScale getFirstTime() {
        return this.getTime(0);
    }

    public double getLastTimeInMinutes() {
        if (this.totalRecords() > 0) {
            return this.getTimeInMinutes(this.totalRecords() - 1);
        }
        return Double.NaN;
    }

    public TimeScale getLastTime() {
        if (this.totalRecords() > 0) {
            return this.getTime(this.totalRecords() - 1);
        }
        return null;
    }

    public E getRecord(int index) {
        if (index >= 0 && index < this.totalRecords()) {
            return (E)((TimeOrderedMetric)this.list.get(index));
        }
        return null;
    }

    public int addRecord(E record) {
        int ind = Search.rightNearest(this.list, record);
        if (ind == -1) {
            ind = this.list.size();
        } else if (((TimeOrderedMetric)this.list.get(ind)).getTimeInMinutes() == record.getTimeInMinutes()) {
            ind = -1;
        }
        if (ind >= 0) {
            if (ind == this.list.size()) {
                this.list.add(record);
            } else {
                this.list.add(ind, record);
            }
        }
        return ind;
    }

    public int getLeftNearest(double timeInMin) {
        return Search.leftNearest(this.list, this.createRecord(timeInMin));
    }

    public int getLeftNearest(TimeScale time) {
        return Search.leftNearest(this.list, this.createRecord(time));
    }

    public int getLeftNearest(double timeInMin, int start, int end) {
        return Search.leftNearest(this.list, this.createRecord(timeInMin), start, end);
    }

    public int getLeftNearest(TimeScale time, int start, int end) {
        return Search.leftNearest(this.list, this.createRecord(time), start, end);
    }

    public int getRightNearest(double timeInMin) {
        return Search.rightNearest(this.list, this.createRecord(timeInMin));
    }

    public int getRightNearest(TimeScale time) {
        return Search.rightNearest(this.list, this.createRecord(time));
    }

    public int getClosest(double timeInMin) {
        return Search.closest(this.list, this.createRecord(timeInMin));
    }

    public int getClosest(TimeScale time) {
        return Search.closest(this.list, this.createRecord(time));
    }

    public int indexOf(double timeInMinutes) {
        return Search.binarySearch(this.list, this.createRecord(timeInMinutes));
    }

    public int indexOf(TimeScale time) {
        return Search.binarySearch(this.list, this.createRecord(time));
    }

    public int indexOf(E record) {
        return Search.binarySearch(this.list, record);
    }

    public int indexOf(E record, int startInd, int endInd) {
        return Search.binarySearch(this.list, record, startInd, endInd);
    }

    public double getMostProbableInterval() {
        return Statistic.getMostProbableInterval(this.list);
    }

    public double getMostProbableInterval(int ind1, int ind2) {
        return Statistic.getMostProbableInterval(this.list, ind1, ind2);
    }

    public double getMostProbableInterval(TimeScale time1, TimeScale time2) {
        return Statistic.getMostProbableInterval(this.list, this.createRecord(time1), this.createRecord(time2));
    }

    public void leaveElements(TimeScale start, TimeScale end, int offsetInSeconds, int stepInSeconds, int windowInSeconds) {
        if (this.totalRecords() == 0) {
            return;
        }
        int i = 0;
        while (i < this.totalRecords()) {
            if (!BasicRecordList.isHit(this.getTime(i), start, end, offsetInSeconds, stepInSeconds, windowInSeconds)) {
                this.remove_Record(i);
                --i;
            }
            ++i;
        }
    }

    public static boolean isHit(TimeScale time, TimeScale start, TimeScale end, int offsetInSeconds, int stepInSeconds, int windowInSeconds) {
        boolean result = false;
        if (!(start != null && time.before(start) || end != null && time.after(end))) {
            int daySeconds = (time.get(11) * 60 + time.get(12)) * 60 + time.get(13);
            if (daySeconds < offsetInSeconds) {
                return false;
            }
            int divRest = (daySeconds - offsetInSeconds) % stepInSeconds;
            if (divRest <= windowInSeconds || divRest >= stepInSeconds - windowInSeconds) {
                result = true;
            }
        }
        return result;
    }

    public BasicRecordList<E> getSubset(int minutes, int minutesInterval) {
        if (this.totalRecords() == 0) {
            return null;
        }
        BasicRecordList<E> newList = this.createRecordList();
        int i = 0;
        while (i < this.totalRecords()) {
            TimeScale currTime = this.getTime(i);
            int dayMinute = currTime.get(11) * 60 + currTime.get(12);
            int divRest = dayMinute % minutes;
            if (divRest > minutes - minutesInterval || divRest < minutesInterval) {
                newList.add_record(this.getRecord(i));
            }
            ++i;
        }
        return newList;
    }

    protected void add_record(E record) {
        this.list.add(record);
    }

    protected void insert_record(E record, int index) {
        this.list.add(index, record);
    }

    private void remove_Record(int index) {
        this.list.remove(index);
    }

    public String createFullFileName(int index) {
        String name = this.createFileName(index);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createFullTempFileName(int index) {
        String name = this.createTempFileName(index);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createFullFileName(int ind1, int ind2) {
        String name = this.createFileName(ind1, ind2);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createFullTempFileName(int ind1, int ind2) {
        String name = this.createTempFileName(ind1, ind2);
        if (name != null) {
            name = new File(CommonConst.getTempDir(), name).getPath();
        }
        return name;
    }

    public String createName(int index) {
        return this.create_Name(index);
    }

    public String createTempName(int index) {
        return this.create_Name(index);
    }

    public String createFileName(int index) {
        return this.create_Name(index);
    }

    public String createTempFileName(int index) {
        return this.create_Name(index);
    }

    private String create_Name(int index) {
        String name = null;
        E record = this.getRecord(index);
        if (record != null) {
            name = ((TimeOrderedMetric)record).createName();
        }
        return name;
    }

    public String createName(int ind1, int ind2) {
        return this.create_Name(ind1, ind2);
    }

    public String createTempName(int ind1, int ind2) {
        return this.create_Name(ind1, ind2);
    }

    public String createFileName(int ind1, int ind2) {
        return this.create_Name(ind1, ind2);
    }

    public String createTempFileName(int ind1, int ind2) {
        return this.create_Name(ind1, ind2);
    }

    private String create_Name(int ind1, int ind2) {
        if (ind1 == ind2) {
            return this.createName(ind1);
        }
        return this.getTimeRangeAsString(ind1, ind2);
    }

    public final String getTimeAsString(int index) {
        return ((TimeOrderedMetric)this.getRecord(index)).getTimeAsString();
    }

    public final String getTimeRangeAsString(int ind1, int ind2) {
        if (ind1 == ind2) {
            this.getTimeAsString(ind1);
        }
        String name = null;
        E record1 = this.getRecord(ind1);
        E record2 = this.getRecord(ind2);
        if (record1 != null && record2 != null) {
            TimeScale time1 = ((TimeOrderedMetric)record1).getTime();
            TimeScale time2 = ((TimeOrderedMetric)record2).getTime();
            String oneDayFormat = "yyyyMMdd(DDD)";
            int len = 0;
            name = !time1.startOfDay().equals(time2.startOfDay()) ? ((len = (int)time2.diffWholeIn(5, time1)) <= 5 ? String.valueOf(((TimeOrderedMetric)record1).getTimeAsString()) + "-" + ((TimeOrderedMetric)record2).getTimeAsString() : String.valueOf(((TimeOrderedMetric)record1).getTimeAsString(oneDayFormat)) + "-" + ((TimeOrderedMetric)record2).getTimeAsString(oneDayFormat)) : ((double)(1440 - (len = (int)time2.diffWholeIn(12, time1))) > 3.0 * this.getMostProbableInterval() ? String.valueOf(((TimeOrderedMetric)record1).getTimeAsString()) + "-" + ((TimeOrderedMetric)record2).getTimeAsString("HHmmss") : ((TimeOrderedMetric)record1).getTimeAsString(oneDayFormat));
        }
        return name;
    }

    public void shiftCircularly(int shift) {
        ArrVec.shiftCircularly(this.list, shift);
    }
}

