/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.instrument.AbstractPlatform;
import edu.uml.lgdc.list.BasicDataList;
import edu.uml.lgdc.list.Capsule;
import edu.uml.lgdc.list.CapsuleRecordList;

public abstract class CapsuleDataList<S extends AbstractPlatform, E extends TimeOrderedMetric>
extends BasicDataList<S, E> {
    @Override
    public final String getDataTypeMnemonic() {
        return "";
    }

    public boolean addToCapsule(E entry, int entryType, int producerId, S station) {
        CapsuleRecordList stationRecordList;
        boolean added = false;
        int index = this.getStationIndex(station);
        boolean newStation = false;
        if (index >= 0) {
            stationRecordList = (CapsuleRecordList)this.recordLists.get(index);
            Object masterCopyStation = this.getStation(index);
            if (masterCopyStation.getUniqueCode() == -1) {
                if (station.getUniqueCode() != -1) {
                    masterCopyStation.setUniqueCode(station.getUniqueCode());
                }
            } else if (station.getUniqueCode() != -1 && station.getUniqueCode() != masterCopyStation.getUniqueCode()) {
                System.out.println("The same station (" + masterCopyStation.getUrsi() + ") with different SID encountered");
            }
        } else {
            newStation = true;
            stationRecordList = (CapsuleRecordList)this.createRecordList();
        }
        added = stationRecordList.addEntry(entry, entryType, producerId);
        if (newStation) {
            this.addNewStation(station, stationRecordList);
        }
        return added;
    }

    public int getFirstIndex(int stInd, int entryType) {
        int index = -1;
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            CapsuleRecordList recordList = (CapsuleRecordList)this.getRecordList(stInd);
            index = recordList.getFirstIndex(entryType);
        }
        return index;
    }

    public int getLastIndex(int stInd, int entryType) {
        int index = -1;
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            CapsuleRecordList recordList = (CapsuleRecordList)this.getRecordList(stInd);
            index = recordList.getLastIndex(entryType);
        }
        return index;
    }

    public E getRawestEntry(int stInd, int recordInd) {
        Capsule capsule = (Capsule)this.getRecord(stInd, recordInd);
        return capsule.getRawestEntry();
    }
}

