/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.instrument.AbstractPlatform;
import edu.uml.lgdc.list.BasicDataList;
import edu.uml.lgdc.list.ClusteredRecord;
import edu.uml.lgdc.list.ClusteredRecordList;

public abstract class ClusteredDataList<S extends AbstractPlatform, E extends TimeOrderedMetric>
extends BasicDataList<S, E> {
    @Override
    public final String getDataTypeMnemonic() {
        return "";
    }

    public boolean add(E entry, int entryType, S station) {
        ClusteredRecordList stationRecordList;
        boolean added = false;
        int index = this.getStationIndex(station);
        boolean newStation = false;
        if (index >= 0) {
            stationRecordList = (ClusteredRecordList)this.recordLists.get(index);
            Object masterCopyStation = this.getStation(index);
            if (masterCopyStation.getUniqueCode() == -1) {
                if (station.getUniqueCode() != -1) {
                    masterCopyStation.setUniqueCode(station.getUniqueCode());
                }
            } else if (station.getUniqueCode() != -1 && station.getUniqueCode() != masterCopyStation.getUniqueCode()) {
                System.out.println("The same station (" + masterCopyStation.getUrsi() + ") with different SID encountered");
            }
        } else {
            newStation = true;
            stationRecordList = (ClusteredRecordList)this.createRecordList();
        }
        added = stationRecordList.addEntry(entry, entryType);
        if (newStation) {
            this.addNewStation(station, stationRecordList);
        }
        return added;
    }

    public int getFirstIndex(int stInd, int entryType) {
        int index = -1;
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            ClusteredRecordList recordList = (ClusteredRecordList)this.getRecordList(stInd);
            index = recordList.getFirstIndex(entryType);
        }
        return index;
    }

    public int getLastIndex(int stInd, int entryType) {
        int index = -1;
        if (stInd >= 0 && stInd < this.getStationsQty()) {
            ClusteredRecordList recordList = (ClusteredRecordList)this.getRecordList(stInd);
            index = recordList.getLastIndex(entryType);
        }
        return index;
    }

    public E getRawestEntry(int stInd, int recordInd) {
        ClusteredRecord cluster = (ClusteredRecord)this.getRecord(stInd, recordInd);
        return cluster.getRawestEntry();
    }
}

