/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.list.ClusteredRecordDesc;
import java.util.ArrayList;
import java.util.List;

public abstract class ClusteredRecord<E extends TimeOrderedMetric>
extends TimeOrderedMetric {
    protected ClusteredRecordDesc dsc;
    protected List<E> entries;
    protected double timeInMin;

    protected ClusteredRecord(ClusteredRecordDesc dsc, double timeInMin) {
        this.dsc = dsc;
        this.timeInMin = timeInMin;
        int maxNumberOfEntries = dsc.getQtyOfEntryTypes();
        this.entries = new ArrayList(maxNumberOfEntries);
        int i = 0;
        while (i < maxNumberOfEntries) {
            this.entries.add(null);
            ++i;
        }
    }

    @Override
    public double getTimeInMinutes() {
        return this.timeInMin;
    }

    public ClusteredRecordDesc getClusterDesc() {
        return this.dsc;
    }

    public String getDescMnem() {
        return this.dsc.getMnem();
    }

    public boolean add(E entry, int type) {
        this.checkType(type);
        if (!this.dsc.getClass(type).isInstance(entry)) {
            throw new RuntimeException("illegal class, " + entry.getClass().getName() + ", not assignment-compatible with cluster element " + "of type " + this.dsc.getClass(type).getName() + ", of cluster index " + type);
        }
        if (this.entries.get(type) != null) {
            return false;
        }
        this.entries.set(type, entry);
        return true;
    }

    public String toString() {
        return String.valueOf(this.getTime().toString()) + " " + this.getSignStr();
    }

    protected String getSignStr() {
        int qty = this.dsc.getQtyOfEntryTypes();
        char[] sign = new char[qty];
        int i = 0;
        while (i < qty) {
            sign[i] = this.entries.get(i) == null ? 95 : this.dsc.getCharIdent(i);
            ++i;
        }
        return new String(sign);
    }

    public boolean isEntryPresent(int type) {
        this.checkType(type);
        return this.entries.get(type) != null;
    }

    public E getEntry(int type) {
        this.checkType(type);
        return (E)((TimeOrderedMetric)this.entries.get(type));
    }

    public E getRawestEntry() {
        int i = 0;
        while (i < this.dsc.getQtyOfEntryTypes()) {
            if (this.entries.get(i) != null) {
                return (E)((TimeOrderedMetric)this.entries.get(i));
            }
            ++i;
        }
        return null;
    }

    private void checkType(int type) {
        if (!this.typeOK(type)) {
            throw new RuntimeException("type is out of range, " + type);
        }
    }

    private boolean typeOK(int type) {
        return type >= 0 && type < this.dsc.getQtyOfEntryTypes();
    }
}

