/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.math.Search;
import java.util.Objects;

public abstract class ClusteredRecordDesc {
    public static final int DATA_FILE_TYPE_UNKNOWN = -1;
    public static final int DATA_TYPE_UNKNOWN = -1;
    protected final String mnem;
    protected final int qtyOfEntryTypes;
    protected final String[][] groupedDataFileExtensions;
    protected final String[] dataFileExtensions;
    protected final Class<?>[] classes;
    protected final String[] shortNames;
    protected final char[] charIdents;
    protected final int[] parentIndexes;

    public ClusteredRecordDesc(String mnem, int qtyOfEntryTypes, String[][] groupedDataFileExtensions, String[] dataFileExtensions, Class<?>[] classes, String[] shortNames, char[] charIdents, int[] parentIndexes) {
        Objects.requireNonNull(mnem, "mnem is null");
        Objects.requireNonNull(groupedDataFileExtensions, "groupedDataFileExtensions is null");
        Objects.requireNonNull(dataFileExtensions, "dataFileExtensions is null");
        Objects.requireNonNull(classes, "classes is null");
        Objects.requireNonNull(shortNames, "shortNames is null");
        Objects.requireNonNull(charIdents, "charIdents is null");
        Objects.requireNonNull(parentIndexes, "parentIndexes is null");
        if (mnem.trim().length() == 0) {
            throw new IllegalArgumentException("mnem is empty string");
        }
        if (qtyOfEntryTypes <= 0) {
            throw new IllegalArgumentException("illegal qtyOfEntryTypes, " + qtyOfEntryTypes);
        }
        if (groupedDataFileExtensions.length != qtyOfEntryTypes) {
            throw new IllegalArgumentException("groupedDataFileExtensions.length != qtyOfEntryTypes (" + groupedDataFileExtensions.length + " != " + qtyOfEntryTypes + ")");
        }
        int i = 0;
        while (i < qtyOfEntryTypes) {
            if (groupedDataFileExtensions[i] == null) {
                throw new IllegalArgumentException("groupedDataFileExtensions[" + i + "] is null");
            }
            if (groupedDataFileExtensions[i].length == 0) {
                throw new IllegalArgumentException("groupedDataFileExtensions[" + i + "].length is 0");
            }
            int j = 0;
            while (j < groupedDataFileExtensions[i].length) {
                if (groupedDataFileExtensions[i][j] == null) {
                    throw new IllegalArgumentException("groupedDataFileExtensions[" + i + "][" + j + "] is null");
                }
                if (groupedDataFileExtensions[i][j].trim().length() == 0) {
                    throw new IllegalArgumentException("groupedDataFileExtensions[" + i + "][" + j + "] is empty string");
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < dataFileExtensions.length) {
            if (dataFileExtensions[i] == null) {
                throw new IllegalArgumentException("dataFileExtensions[" + i + "] is null");
            }
            if (dataFileExtensions[i].trim().length() == 0) {
                throw new IllegalArgumentException("dataFileExtensions[" + i + "] is empty string");
            }
            ++i;
        }
        if (classes.length != qtyOfEntryTypes) {
            throw new IllegalArgumentException("classes.length != qtyOfEntryTypes (" + classes.length + " != " + qtyOfEntryTypes + ")");
        }
        i = 0;
        while (i < qtyOfEntryTypes) {
            if (classes[i] == null) {
                throw new IllegalArgumentException("classes[" + i + "] is null");
            }
            ++i;
        }
        if (shortNames.length != qtyOfEntryTypes) {
            throw new IllegalArgumentException("shortNames.length != qtyOfEntryTypes (" + shortNames.length + " != " + qtyOfEntryTypes + ")");
        }
        i = 0;
        while (i < qtyOfEntryTypes) {
            if (shortNames[i] == null) {
                throw new IllegalArgumentException("shortNames[" + i + "] is null");
            }
            if (shortNames[i].trim().length() == 0) {
                throw new IllegalArgumentException("shortNames[" + i + "] is empty string");
            }
            ++i;
        }
        if (charIdents.length != qtyOfEntryTypes) {
            throw new IllegalArgumentException("charIdents.length != qtyOfEntryTypes (" + charIdents.length + " != " + qtyOfEntryTypes + ")");
        }
        i = 0;
        while (i < qtyOfEntryTypes) {
            if (charIdents[i] == ' ') {
                throw new IllegalArgumentException("charIdents[" + i + "] is space char");
            }
            ++i;
        }
        if (parentIndexes.length != qtyOfEntryTypes) {
            throw new IllegalArgumentException("parentIndexes.length != qtyOfEntryTypes (" + parentIndexes.length + " != " + qtyOfEntryTypes + ")");
        }
        i = 0;
        while (i < qtyOfEntryTypes) {
            if (parentIndexes[i] < -1 || parentIndexes[i] >= qtyOfEntryTypes) {
                throw new IllegalArgumentException("parentIndexes[" + i + "] is illegal, " + parentIndexes);
            }
            ++i;
        }
        String errMsg = this.checkForLoops(parentIndexes);
        if (errMsg != null) {
            throw new IllegalArgumentException("Loop encountered in parentIndexes: " + errMsg);
        }
        this.mnem = mnem;
        this.qtyOfEntryTypes = qtyOfEntryTypes;
        this.groupedDataFileExtensions = groupedDataFileExtensions;
        this.dataFileExtensions = dataFileExtensions;
        this.classes = classes;
        this.shortNames = shortNames;
        this.charIdents = charIdents;
        this.parentIndexes = parentIndexes;
    }

    public String getMnem() {
        return this.mnem;
    }

    public int getQtyOfEntryTypes() {
        return this.qtyOfEntryTypes;
    }

    public String[] getGroupedDataFileExtensions(int entryType) {
        return this.groupedDataFileExtensions[entryType];
    }

    public String[] getDataFileExtensions() {
        return this.dataFileExtensions;
    }

    public Class<?> getClass(int entryType) {
        return this.classes[entryType];
    }

    public char getCharIdent(int entryType) {
        return this.charIdents[entryType];
    }

    public String getShortName(int entryType) {
        return this.shortNames[entryType];
    }

    public int getParentIndex(int entryType) {
        return this.parentIndexes[entryType];
    }

    public int getEntryIndex(String fileName) {
        int dataFileType = -1;
        String ext = FileRW.getExt(fileName);
        int i = 0;
        while (i < this.groupedDataFileExtensions.length) {
            if (Search.scanStrIgnoreCase(this.groupedDataFileExtensions[i], ext) >= 0) {
                dataFileType = i;
                break;
            }
            ++i;
        }
        return dataFileType;
    }

    public int getEntryIndex(Object entry) {
        int i = 0;
        while (i < this.qtyOfEntryTypes) {
            if (this.classes[i].isInstance(entry)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String checkForLoops(int[] parentIndexes) {
        boolean[] checked = new boolean[parentIndexes.length];
        int[] loop = new int[parentIndexes.length];
        int i = 0;
        while (i < parentIndexes.length) {
            int next = i;
            int toCheckLoop = i;
            int loopLength = 0;
            while (true) {
                if (loopLength > 0 && next == toCheckLoop) {
                    return this.createLoopMes(loop, loopLength);
                }
                if (checked[next]) break;
                checked[next] = true;
                loop[loopLength++] = next;
                if (parentIndexes[next] == -1) break;
                next = parentIndexes[next];
            }
            ++i;
        }
        return null;
    }

    private String createLoopMes(int[] loop, int length) {
        String msg = "" + loop[0];
        int i = 1;
        while (i < length) {
            msg = String.valueOf(msg) + "," + loop[i];
            ++i;
        }
        return msg;
    }
}

