/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.database.DatabaseInputOutput;
import edu.uml.lgdc.database.MeasurementQueryFilter;
import edu.uml.lgdc.fileio.ExtFilter;
import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.gui.navigation.Navigatable;
import edu.uml.lgdc.gui.navigation.NavigatableStateChangeEvent;
import edu.uml.lgdc.gui.navigation.NavigatableStateChangeListener;
import edu.uml.lgdc.gui.navigation.NavigationOwner;
import edu.uml.lgdc.gui.navigation.NavigationStateChange;
import edu.uml.lgdc.gui.navigation.NavigationStateChangeEvent;
import edu.uml.lgdc.gui.navigation.NavigationStateChangeListener;
import edu.uml.lgdc.instrument.AbstractPlatform;
import edu.uml.lgdc.list.AbstractRecordScanner;
import edu.uml.lgdc.list.BadFileException;
import edu.uml.lgdc.list.BadStationException;
import edu.uml.lgdc.list.BasicRecordList;
import edu.uml.lgdc.list.Capsule;
import edu.uml.lgdc.list.CapsuleDataList;
import edu.uml.lgdc.list.CapsuleDesc;
import edu.uml.lgdc.list.CapsuleRecordList;
import edu.uml.lgdc.list.EntryLocation;
import edu.uml.lgdc.list.EntryType;
import edu.uml.lgdc.list.OneMeasScanResult;
import edu.uml.lgdc.list.PersistentEntry;
import edu.uml.lgdc.list.PortalDataChangedEvent;
import edu.uml.lgdc.list.PortalDataChangedListener;
import edu.uml.lgdc.list.PortalFileSegmentReadEvent;
import edu.uml.lgdc.list.PortalFileSegmentReadListener;
import edu.uml.lgdc.list.PortalOneFileReadEvent;
import edu.uml.lgdc.list.PortalOneFileReadListener;
import edu.uml.lgdc.list.PortalStationChangedEvent;
import edu.uml.lgdc.list.PortalStationChangedListener;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public abstract class DataPortal<S extends AbstractPlatform>
implements Navigatable {
    public static final int APPEND_TO_LIST = 0;
    public static final int RESET_LIST = 1;
    public static final int SEARCH_COMPANIONS = 2;
    private static final int MAX_RECORD_LENGTH = 6000000;
    protected CapsuleDataList capsuleDataList;
    private List<S> allStations;
    protected AbstractRecordScanner scanner;
    protected S currentStation;
    protected int currentStationIndex;
    protected CapsuleRecordList currentStationRecordList;
    protected int currentStationCurrentRecordIndex;
    protected List<Integer> currentRecordIndexesByStation;
    private int prevStationCurrentRecordIndex;
    private CapsuleRecordList allStationsRecordList;
    protected boolean dataChanged;
    protected CapsuleDesc capsuleDesc;
    protected DatabaseInputOutput databaseReader;
    protected DatabaseInputOutput databaseWriter;
    private final List<PortalDataChangedListener> dataChangedListeners;
    private final Object syncDataChangedListeners;
    private final List<PortalStationChangedListener> stationChangedListeners;
    private final Object syncStationChangedListeners;
    private String progressDescription;
    private double progressValue;
    private final List<PortalOneFileReadListener> oneFileReadListeners;
    private final Object syncOneFileReadListeners;
    private final List<PortalFileSegmentReadListener> fileSegmentReadListeners;
    private final Object syncFileSegmentReadListeners;
    private final transient Object syncNavigationInProcessCount;
    private final transient Set<NavigationOwner> navigationOwners = new HashSet<NavigationOwner>();
    private final transient List<NavigatableStateChangeListener> navigatableStateChangeListeners = new ArrayList<NavigatableStateChangeListener>();
    private final transient Object syncNavigatableStateChangeListeners = new Object();
    private transient int navigationInProcessCount;
    private transient int totFiles = -1;
    private transient int fileCount = -1;
    private transient int fileWithError = -1;

    public DataPortal() {
        this.dataChangedListeners = new ArrayList<PortalDataChangedListener>();
        this.syncDataChangedListeners = new Object();
        this.stationChangedListeners = new ArrayList<PortalStationChangedListener>();
        this.syncStationChangedListeners = new Object();
        this.oneFileReadListeners = new ArrayList<PortalOneFileReadListener>();
        this.syncOneFileReadListeners = new Object();
        this.fileSegmentReadListeners = new ArrayList<PortalFileSegmentReadListener>();
        this.syncFileSegmentReadListeners = new Object();
        this.syncNavigationInProcessCount = new Object();
    }

    @Override
    public void addNavigationOwner(NavigationOwner owner) {
        if (!this.navigationOwners.contains(owner)) {
            this.navigationOwners.add(owner);
            owner.addNavigationStateChangeListener(new NavigationStateChangeListener(){

                @Override
                public void stateChanged(NavigationStateChangeEvent event) {
                    DataPortal.this.processNavigationStateChangeEvent(event);
                }
            });
        }
    }

    private void processNavigationStateChangeEvent(NavigationStateChangeEvent event) {
        NavigationStateChange navigationStateChange = event.getStateChange();
        if (navigationStateChange.isStart()) {
            this.incNavigationInProcessCount();
        } else if (navigationStateChange.isStop()) {
            this.decNavigationInProcessCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incNavigationInProcessCount() {
        Object object = this.syncNavigationInProcessCount;
        synchronized (object) {
            ++this.navigationInProcessCount;
            if (this.navigationInProcessCount == 1) {
                this.fireNavigatableStateChange(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decNavigationInProcessCount() {
        Object object = this.syncNavigationInProcessCount;
        synchronized (object) {
            --this.navigationInProcessCount;
            if (this.navigationInProcessCount == 0) {
                this.fireNavigatableStateChange(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNavigatableStateChangeListener(NavigatableStateChangeListener listener) {
        Object object = this.syncNavigatableStateChangeListeners;
        synchronized (object) {
            this.navigatableStateChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNavigatableStateChangeListener(NavigatableStateChangeListener listener) {
        Object object = this.syncNavigatableStateChangeListeners;
        synchronized (object) {
            this.navigatableStateChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNavigatableStateChange(boolean isNavigating) {
        Object object = this.syncNavigatableStateChangeListeners;
        synchronized (object) {
            NavigatableStateChangeEvent event = new NavigatableStateChangeEvent(this, isNavigating);
            for (NavigatableStateChangeListener listener : this.navigatableStateChangeListeners) {
                listener.stateChanged(event);
            }
        }
    }

    public MeasurementQueryFilter getFilter() {
        return null;
    }

    public void setFilter(MeasurementQueryFilter filter) {
    }

    public void removeFilter() {
    }

    public boolean isFiltered() {
        return false;
    }

    public List<S> getAllStations() {
        return this.allStations;
    }

    protected void applyFilterToChangedData() {
    }

    public S getCurrentStation() {
        return this.currentStation;
    }

    public CapsuleRecordList getAllStationsRecordList() {
        if (this.allStationsRecordList == null) {
            return null;
        }
        if (this.allStationsRecordList.totalRecords() == 0) {
            TreeMap<TimeScale, Capsule> allStationsMap = new TreeMap<TimeScale, Capsule>();
            int numberOfStations = this.capsuleDataList.getStationsQty();
            int i = 0;
            while (i < numberOfStations) {
                BasicRecordList recordList = this.capsuleDataList.getRecordList(i);
                int numberOfRecords = recordList.totalRecords();
                int j = 0;
                while (j < numberOfRecords) {
                    allStationsMap.put(recordList.getTime(j), (Capsule)recordList.getRecord(j));
                    ++j;
                }
                ++i;
            }
            for (Capsule capsule : allStationsMap.values()) {
                this.allStationsRecordList.addRecord(capsule);
            }
        }
        return this.allStationsRecordList;
    }

    public void setCurrentStation(S currentStation) {
        if (!currentStation.equals(this.currentStation)) {
            this.currentStation = currentStation;
            this.currentStationIndex = this.allStations.indexOf(currentStation);
            this.fireStationChangedEvent();
        }
    }

    public CapsuleRecordList getCurrentStationRecordList() {
        if (this.currentStationRecordList != null) {
            return this.currentStationRecordList;
        }
        return null;
    }

    public int getCurrentRecordIndex() {
        if (this.currentStationCurrentRecordIndex != -1) {
            return this.currentStationCurrentRecordIndex;
        }
        return 0;
    }

    public void setPrevStationCurrentRecordIndex(int prevStationCurrentRecordIndex) {
        this.prevStationCurrentRecordIndex = prevStationCurrentRecordIndex;
    }

    public CapsuleDataList getCapsuleDataList() {
        return this.capsuleDataList;
    }

    public boolean isEmpty() {
        return this.capsuleDataList.isTotalEmpty();
    }

    public int getTotalNumberOfCapsules() {
        return this.capsuleDataList.getTotalSize();
    }

    private void adjustStations() {
        this.allStations = new ArrayList<S>();
        this.allStations.addAll(this.capsuleDataList.getStations());
        Collections.sort(this.allStations);
        if (this.allStations.size() > 0) {
            this.currentStationIndex = 0;
            this.currentStation = (AbstractPlatform)this.allStations.get(0);
        } else {
            this.currentStation = null;
            this.currentStationIndex = -1;
        }
        this.currentRecordIndexesByStation = new ArrayList<Integer>();
        int i = 0;
        while (i < this.allStations.size()) {
            this.currentRecordIndexesByStation.add(0);
            ++i;
        }
    }

    protected abstract void adjustDataForCurrentStation();

    public void initData() {
        boolean bl = this.dataChanged = !this.capsuleDataList.isTotalEmpty();
        if (this.dataChanged) {
            this.capsuleDataList.initData();
        }
    }

    private void initDataChangedFlags() {
        this.dataChanged = false;
    }

    public void initLoad(boolean resetList) {
        if (resetList) {
            this.initData();
        } else {
            this.initDataChangedFlags();
        }
    }

    public boolean openFromFile(File file, int mode) {
        return this.openFromFile(file.getPath(), mode);
    }

    public boolean openFromFile(String filename, int mode) {
        this.initLoad((mode & 1) != 0);
        this.openFromFile_(filename, (mode & 2) != 0);
        if (this.isDataChanged()) {
            this.fireDataChangedEvent();
            return true;
        }
        return false;
    }

    private boolean openFromFile_(String filename, boolean lookupCapsuleCompanions) {
        String[] companionFilenames;
        boolean success = this.scanOneFile(filename);
        if (!lookupCapsuleCompanions) {
            return success;
        }
        File file = new File(filename);
        String[] stringArray = companionFilenames = this.capsuleDesc.findCompanions(filename);
        int n = companionFilenames.length;
        int n2 = 0;
        while (n2 < n) {
            String companionFilename = stringArray[n2];
            if (!new File(companionFilename).equals(file) && !this.scanOneFile(companionFilename)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanOneFile(String filename) {
        boolean scanComplete = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileInputStream fis = new FileInputStream(filename);
                try {
                    try (PushbackInputStream pushbackStream = new PushbackInputStream(fis, 6000000);){
                        String filenameOnly = new File(filename).getName();
                        long fileLength = FileRW.getLength(filename);
                        long startStreamPosition = 0L;
                        OneMeasScanResult oneMeasScanResult = null;
                        while ((oneMeasScanResult = this.scanner.scanNextEntry(pushbackStream, startStreamPosition, false)) != null) {
                            this.fireFileSegmentReadEvent("One Record loaded from " + filenameOnly, (double)startStreamPosition / (double)fileLength);
                            EntryLocation location = oneMeasScanResult.getLocation();
                            startStreamPosition += location.getLength() + location.getSkippedFrontBytes();
                            PersistentEntry record = oneMeasScanResult.getRecord();
                            record.setLocation(location, filename);
                            EntryType entryType = oneMeasScanResult.getEntryType();
                            AbstractPlatform station = oneMeasScanResult.getStation();
                            if (!this.capsuleDataList.addToCapsule(record, entryType.ordinal(), -1, station)) continue;
                            this.dataChanged = true;
                        }
                        scanComplete = true;
                    }
                    if (fis == null) return scanComplete;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return scanComplete;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (BadFileException | BadStationException | IOException ex) {
            this.issueErrorMessage(filename, ex);
        }
        return scanComplete;
    }

    public void setDataChanged(int opCode) {
        this.dataChanged = true;
    }

    public boolean openFromFiles(File[] files, boolean resetList, boolean searchCapsuleCompanions) {
        if (files != null && files.length > 0) {
            String[] fileNames = new String[files.length];
            int i = 0;
            while (i < files.length) {
                fileNames[i] = files[i].getPath();
                ++i;
            }
            return this.openFromFiles(fileNames, resetList, searchCapsuleCompanions);
        }
        return true;
    }

    public boolean openFromFiles(String[] filenames, boolean resetCapsuleList, boolean lookupCapsuleCompanions) {
        if (filenames == null || filenames.length == 0) {
            return true;
        }
        this.initLoad(resetCapsuleList);
        int i = 0;
        while (i < filenames.length) {
            this.fireOneFileReadEvent("Loading file: " + new File(filenames[i]).getName(), (double)i / (double)filenames.length);
            if (!this.openFromFile_(filenames[i], lookupCapsuleCompanions)) {
                System.out.println("Only " + i + " file(s) was(were) loaded (out of " + filenames.length + ") because of previous error");
                break;
            }
            ++i;
        }
        if (this.isDataChanged()) {
            this.fireDataChangedEvent();
            return true;
        }
        return false;
    }

    public boolean openFromDirectory(File dir, String[] exts, boolean resetList, boolean recursive) {
        return this.openFromDirectory(dir.getPath(), exts, resetList, recursive);
    }

    public boolean openFromDirectory(String dirname, String[] exts, boolean resetList, boolean recursive) {
        this.initLoad(resetList);
        this.fireOneFileReadEvent("Counting files in directory " + dirname, 0.0);
        this.totFiles = FileUtils.countFiles(dirname, true, true, exts, recursive);
        this.fileCount = 0;
        this.fileWithError = 0;
        this.fireOneFileReadEvent("Loading directory " + dirname + (recursive ? " recursively" : ""), 0.0);
        boolean result = this.openAllFilesFromDirectory(dirname, exts, recursive);
        if (!result) {
            System.out.println("Files with errors: " + this.fileWithError + " out of " + this.totFiles);
        }
        if (this.isDataChanged()) {
            this.fireDataChangedEvent();
            return true;
        }
        return false;
    }

    private boolean openAllFilesFromDirectory(String dir, String[] exts, boolean recursive) {
        boolean result = true;
        ExtFilter filenameFilter = new ExtFilter(exts, recursive);
        String[] inputFiles = new File(dir).list(filenameFilter);
        if (inputFiles == null) {
            System.out.println("Can't get list of files for directory " + dir);
            return false;
        }
        String[] stringArray = inputFiles;
        int n = inputFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String inputFile = stringArray[n2];
            File file = new File(dir, inputFile);
            if (!file.isDirectory()) {
                this.fireOneFileReadEvent("Loading file " + inputFile, (double)this.fileCount / (double)this.totFiles);
                if (!this.openFromFile_(file.getPath(), false)) {
                    ++this.fileWithError;
                    result = false;
                }
                ++this.fileCount;
            } else if (recursive) {
                result = this.openAllFilesFromDirectory(file.getPath(), exts, true);
            }
            ++n2;
        }
        return result;
    }

    private void issueErrorMessage(String inputFile, Exception ex) {
        String msg = "Open file " + inputFile + " I/O error";
        Console.showError(msg);
        Console.printThreadStackTrace(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataChangedListener(PortalDataChangedListener listener) {
        Object object = this.syncDataChangedListeners;
        synchronized (object) {
            this.dataChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataChangedListener(PortalDataChangedListener listener) {
        Object object = this.syncDataChangedListeners;
        synchronized (object) {
            this.dataChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStationChangedListener(PortalStationChangedListener listener) {
        Object object = this.syncStationChangedListeners;
        synchronized (object) {
            if (this.stationChangedListeners == null) {
                return;
            }
            this.stationChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStationChangedListener(PortalStationChangedListener listener) {
        Object object = this.syncStationChangedListeners;
        synchronized (object) {
            if (this.stationChangedListeners == null) {
                return;
            }
            this.stationChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOneFileReadListener(PortalOneFileReadListener listener) {
        Object object = this.syncOneFileReadListeners;
        synchronized (object) {
            this.oneFileReadListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOneFileReadListener(PortalOneFileReadListener listener) {
        Object object = this.syncOneFileReadListeners;
        synchronized (object) {
            this.oneFileReadListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileSegmentReadListener(PortalFileSegmentReadListener listener) {
        Object object = this.syncFileSegmentReadListeners;
        synchronized (object) {
            this.fileSegmentReadListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileSegmentReadListener(PortalFileSegmentReadListener listener) {
        Object object = this.syncFileSegmentReadListeners;
        synchronized (object) {
            this.fileSegmentReadListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDataChangedEvent() {
        if (!this.isDataChanged()) {
            return;
        }
        Object object = this.syncDataChangedListeners;
        synchronized (object) {
            this.initDataChangedFlags();
            this.adjustStations();
            this.prevStationCurrentRecordIndex = -1;
            this.adjustDataForCurrentStation();
            this.allStationsRecordList = null;
            this.applyFilterToChangedData();
            PortalDataChangedEvent event = new PortalDataChangedEvent(this);
            for (PortalDataChangedListener listener : this.dataChangedListeners) {
                listener.stateChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStationChangedEvent() {
        Object object = this.syncStationChangedListeners;
        synchronized (object) {
            this.prevStationCurrentRecordIndex = this.currentStationCurrentRecordIndex;
            this.adjustDataForCurrentStation();
            if (this.stationChangedListeners == null) {
                return;
            }
            PortalStationChangedEvent event = new PortalStationChangedEvent(this);
            for (PortalStationChangedListener listener : this.stationChangedListeners) {
                listener.stateChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireOneFileReadEvent(String message, double progressValue) {
        Object object = this.syncOneFileReadListeners;
        synchronized (object) {
            this.progressDescription = message;
            this.progressValue = progressValue;
            if (this.stationChangedListeners == null) {
                return;
            }
            PortalOneFileReadEvent event = new PortalOneFileReadEvent(this);
            for (PortalOneFileReadListener listener : this.oneFileReadListeners) {
                listener.stateChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFileSegmentReadEvent(String message, double progressValue) {
        Object object = this.syncFileSegmentReadListeners;
        synchronized (object) {
            this.progressDescription = message;
            this.progressValue = progressValue;
            if (this.stationChangedListeners == null) {
                return;
            }
            PortalFileSegmentReadEvent event = new PortalFileSegmentReadEvent(this);
            for (PortalFileSegmentReadListener listener : this.fileSegmentReadListeners) {
                listener.stateChanged(event);
            }
        }
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }
}

