/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.instrument.AbstractPlatform;
import edu.uml.lgdc.time.TimeScale;

public abstract class Entry
extends TimeOrderedMetric {
    protected double timeInMinutes = Double.NaN;
    protected int producerId = -1;

    public Entry() {
    }

    public Entry(TimeScale time) {
        this(time.getTimeInMinutes());
    }

    public Entry(double timeInMinutes) {
        this.setTime(timeInMinutes);
    }

    @Override
    public double getTimeInMinutes() {
        return this.timeInMinutes;
    }

    public void setTime(double timeInMinutes) {
        this.set(timeInMinutes);
    }

    public void addTime(double value) {
        this.timeInMinutes += value;
    }

    public String toString() {
        String str = null;
        if (!Double.isNaN(this.timeInMinutes)) {
            str = new TimeScale(this.timeInMinutes).toString();
        }
        return str;
    }

    public void set(Entry entry) {
        if (entry != null) {
            this.set(entry.timeInMinutes);
        } else {
            this.clear();
        }
    }

    public void set(double timeInMinutes) {
        this.timeInMinutes = timeInMinutes;
    }

    private void clear() {
        this.timeInMinutes = Double.NaN;
    }

    public String createFileName(AbstractPlatform station) {
        return this.createName(String.valueOf(station.getUrsi().toLowerCase()) + "_");
    }

    public String createTempFileName(AbstractPlatform station) {
        return this.createTempName(String.valueOf(station.getUrsi().toLowerCase()) + "_");
    }

    public String createTempFileName(AbstractPlatform station, String ext) {
        return this.createTempName(station);
    }

    @Override
    public String createFileName() {
        return super.createName();
    }

    @Override
    public String createTempFileName() {
        return super.createTempName();
    }

    public String createName(AbstractPlatform station) {
        return this.createName(String.valueOf(station.getUrsi().toLowerCase()) + "_");
    }

    public String createTempName(AbstractPlatform station) {
        return this.createTempName(String.valueOf(station.getUrsi().toLowerCase()) + "_");
    }

    public String createName(AbstractPlatform station, String format) {
        return this.createName(String.valueOf(station.getUrsi().toLowerCase()) + "_", format);
    }

    public String createTempName(AbstractPlatform station, String format) {
        return this.createTempName(String.valueOf(station.getUrsi().toLowerCase()) + "_", format);
    }

    @Override
    public final String createName(String prefix) {
        return String.valueOf(prefix) + super.createName();
    }

    @Override
    public final String createTempName(String prefix) {
        return String.valueOf(prefix) + super.createTempName();
    }

    public final String createName(String prefix, String format) {
        return String.valueOf(prefix) + super.createName(format);
    }

    public final String createTempName(String prefix, String format) {
        return String.valueOf(prefix) + super.createTempName(format);
    }

    public void setProducerIdent(int id) {
        this.producerId = id;
    }

    public int getProducerIdent() {
        return this.producerId;
    }
}

