/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.list;

import edu.uml.lgdc.datatype.StrMap;
import edu.uml.lgdc.datatype.StrMapFactory;
import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.instrument.AbstractPlatform;
import edu.uml.lgdc.list.Entry;
import edu.uml.lgdc.list.EntryLocation;
import edu.uml.lgdc.list.PersistentEntryData;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class PersistentEntry
extends Entry {
    private static final String TEMP_DIR = CommonConst.getTempDir();
    private static List<String> fileNames;
    private static StrMap<Integer> filenameToIndexMap;
    private static int qtyOfOpened;
    private static final Object fileNameSync;
    protected EntryLocation location;
    protected PersistentEntryData data;
    private int openCount;
    private boolean locked;
    private String threadName;
    private int lockCount;
    protected boolean longTermDbCache;
    private boolean debug;

    static {
        fileNameSync = new Object();
        PersistentEntry.initFileNames();
    }

    public PersistentEntry() {
    }

    public PersistentEntry(TimeScale time) {
        this(time.getTimeInMinutes());
    }

    public PersistentEntry(double timeInMinutes) {
        super(timeInMinutes);
    }

    public PersistentEntry createEmptyPersistentEntry(TimeScale time) {
        return this.createEmptyPersistentEntry(time.getTimeInMinutes());
    }

    public abstract EntryLocation createEmptyLocation();

    public abstract PersistentEntry createEmptyPersistentEntry();

    public abstract PersistentEntry createEmptyPersistentEntry(double var1);

    public abstract String getDefaultDataFileExtension();

    public PersistentEntryData getData() {
        return this.data;
    }

    public synchronized Object clone() {
        PersistentEntry entry = this.createEmptyPersistentEntry();
        entry.timeInMinutes = this.timeInMinutes;
        if (this.location != null) {
            entry.setLocation((EntryLocation)this.location.clone(), PersistentEntry.getSourceFileName(this.location.getFileID()));
        }
        if (this.data != null) {
            entry.data = (PersistentEntryData)this.data.clone(entry);
        }
        return entry;
    }

    public void close() {
        this.lock();
        try {
            this.close_();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close_() {
        Object object = fileNameSync;
        synchronized (object) {
            if (this.location != null) {
                boolean fromFile = this.location.getFileID() >= 0;
                this.closeData();
                this.clear();
                if (fromFile && --qtyOfOpened == 0) {
                    PersistentEntry.initFileNames();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeData() {
        this.lock();
        try {
            Object object = fileNameSync;
            synchronized (object) {
                block14: {
                    if (this.location != null && this.data != null) {
                        if (this.openCount > 0) {
                            --this.openCount;
                        }
                        if (this.openCount == 0) {
                            try {
                                try {
                                    this.data.close(this);
                                }
                                catch (IOException e) {
                                    System.out.println(e.toString());
                                    this.data = null;
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                this.data = null;
                                throw throwable;
                            }
                            this.data = null;
                        }
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(EntryLocation location, String fileName) {
        if (location != null && fileName != null) {
            Object object = fileNameSync;
            synchronized (object) {
                this.openCount = 0;
                this.close();
                location.setFileID(PersistentEntry.addFileName(fileName));
                ++qtyOfOpened;
                this.location = location;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(EntryLocation location) {
        Object object = fileNameSync;
        synchronized (object) {
            this.openCount = 0;
            if (location != null) {
                location.setFileID(-1);
            }
            this.location = location;
        }
    }

    public boolean isDatabase() {
        EntryLocation loc = this.location;
        return loc != null ? loc.isDatabase() : false;
    }

    private void clear() {
        if (this.location == null) {
            return;
        }
        EntryLocation location = this.location;
        this.clearLocation();
        if (location.getRecalcEntryFile() != null) {
            new File(location.getRecalcEntryFile()).delete();
            location.setRecalcEntryFile(null);
        }
        if (location.getMeasurementId() != -1) {
            if (location.isDbTempFileCreated()) {
                if (!this.longTermDbCache) {
                    new File(this.getDBTempFileName(location)).delete();
                }
                location.setDbTempFileCreated(false);
            }
            location.clearDatabaseFarm();
            location.setMeasurementId(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLocation() {
        Object object = fileNameSync;
        synchronized (object) {
            this.openCount = 0;
            this.location = null;
        }
    }

    public EntryLocation getLocation() {
        return this.location;
    }

    public String getFileName() {
        if (this.location.getRecalcEntryFile() != null) {
            return this.location.getRecalcEntryFile();
        }
        if (this.location.getFileID() >= 0) {
            return PersistentEntry.getSourceFileName(this.location.getFileID());
        }
        if (this.location.isDbTempFileCreated()) {
            return this.getDBTempFileName();
        }
        return null;
    }

    public String getDBTempFileName() {
        return this.getDBTempFileName(this.location);
    }

    public String getDBTempFileName(EntryLocation location) {
        String name = new File(TEMP_DIR, "db_" + this.createTempFileName()).getPath();
        if (location.getExpertId() > 0) {
            String ext = FileRW.getExt(name);
            if (ext.length() > 0) {
                ext = "." + ext;
            }
            name = String.valueOf(name.substring(0, name.length() - ext.length())) + "_e" + Formatter.padLeft("" + location.getExpertId(), 4, '0') + ext;
        }
        return name;
    }

    public long getOffset() {
        if (this.location.getRecalcEntryFile() != null) {
            return 0L;
        }
        if (this.location.getFileID() >= 0) {
            return this.getSourceOffset();
        }
        return 0L;
    }

    public long getLength() {
        if (this.location.getRecalcEntryFile() != null) {
            return new File(this.location.getRecalcEntryFile()).length();
        }
        if (this.location.getFileID() >= 0) {
            return this.getSourceLength();
        }
        if (this.location.isDbTempFileCreated()) {
            return new File(this.getDBTempFileName()).length();
        }
        return -1L;
    }

    public String getSourceFileName() {
        return PersistentEntry.getSourceFileName(this.location.getFileID());
    }

    public long getSourceOffset() {
        return this.location.getOffset();
    }

    public long getSourceLength() {
        return this.location.getLength();
    }

    protected void finalize() throws Throwable {
        this.close_();
    }

    protected int increaseOpenCount() {
        return this.openCount++;
    }

    @Override
    public String createFileName(AbstractPlatform station) {
        return String.valueOf(super.createFileName(station)) + "." + this.getDefaultDataFileExtension();
    }

    @Override
    public String createTempFileName(AbstractPlatform station) {
        return String.valueOf(super.createTempFileName(station)) + "." + this.getDefaultDataFileExtension();
    }

    @Override
    public String createName(AbstractPlatform station) {
        return String.valueOf(super.createName(station)) + "_" + this.getDefaultDataFileExtension();
    }

    @Override
    public String createTempName(AbstractPlatform station) {
        return String.valueOf(super.createTempName(station)) + "_" + this.getDefaultDataFileExtension();
    }

    private void lock() {
        while (!this.tryToLock()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void unlock() {
        if (this.locked && this.threadName.equals(Thread.currentThread().getName())) {
            --this.lockCount;
            if (this.lockCount == 0) {
                this.threadName = null;
                this.locked = false;
            }
            if (this.debug) {
                System.out.println("UNLOCK " + this.getTime() + ", COUNT=" + this.lockCount + ", " + Thread.currentThread().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToLock() {
        boolean result = false;
        String name = null;
        Object object = fileNameSync;
        synchronized (object) {
            name = Thread.currentThread().getName();
            if (!this.locked) {
                this.threadName = name;
                this.locked = true;
                this.lockCount = 1;
                result = true;
            } else if (name.equals(this.threadName)) {
                ++this.lockCount;
                result = true;
            }
            if (this.debug && result) {
                System.out.println("LOCK " + this.getTime() + ", COUNT=" + this.lockCount + ", " + name);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSourceFileName(int fileID) {
        Object object = fileNameSync;
        synchronized (object) {
            block4: {
                if (fileID >= 0 && fileID < fileNames.size()) break block4;
                return null;
            }
            return fileNames.get(fileID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int addFileName(String fileName) {
        Object object = fileNameSync;
        synchronized (object) {
            Integer intWrapper = filenameToIndexMap.get(fileName);
            if (intWrapper != null) {
                return intWrapper;
            }
            filenameToIndexMap.put(fileName, fileNames.size());
            fileNames.add(fileName);
            return fileNames.size() - 1;
        }
    }

    private static void initFileNames() {
        qtyOfOpened = 0;
        fileNames = new ArrayList<String>(1024);
        filenameToIndexMap = new StrMapFactory().getStrMap(!new File("a").equals("A"));
    }
}

