/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.project.Console;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class BinaryMask {
    public static long fromExpression(String maskExpression) {
        try {
            Expression e = new ExpressionBuilder(maskExpression).build();
            long maskValue = (long)e.evaluate();
            if (maskValue >= 0L) {
                return maskValue;
            }
            Console.showError("evaluated value of expression \"" + maskExpression + "\" is negative");
            return -1L;
        }
        catch (RuntimeException ex) {
            Console.showError("expression evaultaion exception: " + ex + "\nExpression = " + maskExpression);
            return -1L;
        }
    }

    public static String toExpression(long maskValue) {
        if (maskValue < 0L) {
            throw new IllegalArgumentException("maskValue is less than 0, " + maskValue);
        }
        StringBuilder maskExpression = new StringBuilder(64);
        int mask = 1;
        while (maskValue > 0L) {
            if ((maskValue & 1L) > 0L) {
                if (maskExpression.length() > 0) {
                    maskExpression.append('+');
                }
                maskExpression.append(mask);
            }
            mask += mask;
            maskValue >>= 1;
        }
        if (maskExpression.length() > 0) {
            return maskExpression.toString();
        }
        return "0";
    }
}

