/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.datatype.geom.R2;
import java.util.List;
import java.util.Vector;

public class CA
implements Cloneable {
    private double start = 0.0;
    private double length = 0.0;
    protected double offset = 0.0;

    protected CA(double length) {
        this(0.0, length);
    }

    protected CA(double start, double length) {
        this.start = start;
        this.length = length;
    }

    protected void set(double value) {
        this.offset = value - this.start;
        this.getNormalizeOffset();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof CA && ((CA)object).start == this.start && ((CA)object).length == this.length && ((CA)object).offset == this.offset;
    }

    public Object clone() {
        CA cloned = new CA(this.start, this.length);
        cloned.offset = this.offset;
        return cloned;
    }

    public boolean isBetween(double value, double first, double second) {
        boolean between = false;
        value = CA.getNormalizedOffset(value, this.length);
        first = CA.getNormalizedOffset(first, this.length);
        second = CA.getNormalizedOffset(second, this.length);
        between = value >= first ? second < first || value <= second : second < first && value <= second;
        return between;
    }

    protected double get() {
        return this.start + this.offset;
    }

    protected double length() {
        return this.length;
    }

    protected double offset() {
        return this.offset;
    }

    public void zero() {
        this.offset = 0.0;
    }

    public boolean isZero() {
        return this.offset == 0.0;
    }

    public void add(CA value) {
        this.offset += value.offset();
        this.normalizeOffset();
    }

    public void sub(CA value) {
        this.offset -= value.offset();
        this.normalizeOffset();
    }

    public void rev() {
        if (this.offset > 0.0) {
            this.offset = this.length - this.offset;
        }
    }

    public void mult(double scalar) {
        this.set(scalar * this.get());
    }

    public static CA a(CA x, CA y) {
        CA z = (CA)x.clone();
        z.add(y);
        return z;
    }

    public static CA s(CA x, CA y) {
        CA z = (CA)x.clone();
        z.sub(y);
        return z;
    }

    public static CA m(double scalar, CA x) {
        CA z = (CA)x.clone();
        z.mult(scalar);
        return z;
    }

    public static CA minus(CA x) {
        CA z = (CA)x.clone();
        z.rev();
        return z;
    }

    public static CA getMeanValue(CA[] e) {
        return CA.getMeanValue(e, 0, e.length);
    }

    public static CA getMeanValue(CA[] e, int start, int length) {
        if (e == null || e.length == 0) {
            return null;
        }
        double coeff = Math.PI * 2 / e[0].length();
        double xAvg = 0.0;
        double yAvg = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < length) {
            value = coeff * e[start + i].offset();
            xAvg += Math.cos(value);
            yAvg += Math.sin(value);
            ++i;
        }
        xAvg /= (double)length;
        yAvg /= (double)length;
        CA result = (CA)e[0].clone();
        if (Math.sqrt(xAvg * xAvg + yAvg * yAvg) >= 0.001) {
            result.set(new R2(xAvg, yAvg).phaseAngle() / coeff);
        } else {
            result.zero();
        }
        return result;
    }

    public static CA getWeghedMeanValue(CA[] e, double[] weights) {
        return CA.getWeighedMeanValue(e, weights, 0, e.length);
    }

    public static CA getWeighedMeanValue(CA[] e, double[] weights, int start, int length) {
        if (e == null || e.length == 0) {
            return null;
        }
        double coeff = Math.PI * 2 / e[0].length();
        double totWeight = 0.0;
        double xAvg = 0.0;
        double yAvg = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < length) {
            value = coeff * e[start + i].offset();
            xAvg += Math.cos(value) * weights[start + i];
            yAvg += Math.sin(value) * weights[start + i];
            totWeight += weights[start + i];
            ++i;
        }
        xAvg /= totWeight;
        yAvg /= totWeight;
        CA result = (CA)e[0].clone();
        if (Math.sqrt(xAvg * xAvg + yAvg * yAvg) >= 0.001) {
            result.set(new R2(xAvg, yAvg).phaseAngle() / coeff);
        } else {
            result.zero();
        }
        return result;
    }

    public double getMeanValue(double[] val) {
        return this.getMeanValue(val, 0, val.length);
    }

    public double getMeanValue(double[] val, int start, int length) {
        double result = this.start;
        if (val == null || val.length == 0) {
            return this.start;
        }
        double coeff = Math.PI * 2 / this.length;
        double xAvg = 0.0;
        double yAvg = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < length) {
            value = coeff * this.getNormalizedOffset(val[start + i] - this.start);
            xAvg += Math.cos(value);
            yAvg += Math.sin(value);
            ++i;
        }
        if (Math.sqrt((xAvg /= (double)length) * xAvg + (yAvg /= (double)length) * yAvg) >= 0.001) {
            result = this.start + new R2(xAvg, yAvg).phaseAngle() / coeff;
        }
        return result;
    }

    public double getMeanValue(Vector<Double> val) {
        return this.getMeanValue(val, 0, val.size());
    }

    public double getMeanValue(Vector<Double> val, int start, int length) {
        double result = this.start;
        if (val == null || val.size() == 0) {
            return this.start;
        }
        double coeff = Math.PI * 2 / this.length;
        double xAvg = 0.0;
        double yAvg = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < length) {
            value = coeff * this.getNormalizedOffset(val.get(start + i) - this.start);
            xAvg += Math.cos(value);
            yAvg += Math.sin(value);
            ++i;
        }
        if (Math.sqrt((xAvg /= (double)length) * xAvg + (yAvg /= (double)length) * yAvg) >= 0.001) {
            result = this.start + new R2(xAvg, yAvg).phaseAngle() / coeff;
        }
        return result;
    }

    public double getMeanValue(List<Double> val) {
        return this.getMeanValue(val, 0, val.size());
    }

    public double getMeanValue(List<Double> val, int start, int length) {
        double result = this.start;
        if (val == null || val.size() == 0) {
            return this.start;
        }
        double coeff = Math.PI * 2 / this.length;
        double xAvg = 0.0;
        double yAvg = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < length) {
            value = coeff * this.getNormalizedOffset(val.get(start + i) - this.start);
            xAvg += Math.cos(value);
            yAvg += Math.sin(value);
            ++i;
        }
        if (Math.sqrt((xAvg /= (double)length) * xAvg + (yAvg /= (double)length) * yAvg) >= 0.001) {
            result = this.start + new R2(xAvg, yAvg).phaseAngle() / coeff;
        }
        return result;
    }

    public double getWeighedMeanValue(double[] val, double[] weights) {
        return this.getWeighedMeanValue(val, weights, 0, val.length);
    }

    public double getWeighedMeanValue(double[] val, double[] weights, int start, int length) {
        double result = this.start;
        if (val == null || val.length == 0) {
            return this.start;
        }
        double coeff = Math.PI * 2 / this.length;
        double totWeight = 0.0;
        double xAvg = 0.0;
        double yAvg = 0.0;
        double value = 0.0;
        int i = 0;
        while (i < length) {
            value = coeff * this.getNormalizedOffset(val[start + i] - this.start);
            xAvg += Math.cos(value) * weights[start + i];
            yAvg += Math.sin(value) * weights[start + i];
            totWeight += weights[start + i];
            ++i;
        }
        if (Math.sqrt((xAvg /= totWeight) * xAvg + (yAvg /= totWeight) * yAvg) >= 0.001) {
            result = this.start + new R2(xAvg, yAvg).phaseAngle() / coeff;
        }
        return result;
    }

    public double getWeighedMeanValue(Vector<Double> val, Vector<Double> weights) {
        return this.getWeighedMeanValue(val, weights, 0, val.size());
    }

    public double getWeighedMeanValue(Vector<Double> val, Vector<Double> weights, int start, int length) {
        double result = this.start;
        if (val == null || val.size() == 0) {
            return this.start;
        }
        double coeff = Math.PI * 2 / this.length;
        double totWeight = 0.0;
        double xAvg = 0.0;
        double yAvg = 0.0;
        double value = 0.0;
        double weight = 0.0;
        int i = 0;
        while (i < length) {
            value = val.get(start + i);
            value = coeff * this.getNormalizedOffset(value - this.start);
            weight = weights.get(start + i);
            xAvg += Math.cos(value) * weight;
            yAvg += Math.sin(value) * weight;
            totWeight += weight;
            ++i;
        }
        if (Math.sqrt((xAvg /= totWeight) * xAvg + (yAvg /= totWeight) * yAvg) >= 0.001) {
            result = this.start + new R2(xAvg, yAvg).phaseAngle() / coeff;
        }
        return result;
    }

    public double getDeviation(double[] val) {
        return this.getDeviation(val, 0, val.length);
    }

    public double getDeviation(double[] val, double avg) {
        return this.getDeviation(val, 0, val.length, avg);
    }

    public double getDeviation(double[] val, int startInd, int qty) {
        return this.getDeviation(val, startInd, qty, this.getMeanValue(val, startInd, qty));
    }

    public double getDeviation(double[] val, int startInd, int qty, double avg) {
        double deviation = 0.0;
        if (qty > 0) {
            avg = this.getNormalizedOffset(avg - this.start);
            int i = startInd;
            while (i < startInd + qty) {
                double devSingle = this.getDistance(val[i], avg);
                deviation += devSingle * devSingle;
                ++i;
            }
            deviation = Math.sqrt(deviation / this.length);
        }
        return deviation;
    }

    public double getDistance(double val1, double val2) {
        double distance = Math.abs(this.getNormalizedOffset(val1 - this.start) - this.getNormalizedOffset(val2 - this.start));
        if (distance > this.length / 2.0) {
            distance = this.length - distance;
        }
        return distance;
    }

    private void normalizeOffset() {
        if (this.offset >= this.length) {
            this.offset -= this.length;
        } else if (this.offset < 0.0) {
            this.offset += this.length;
        }
    }

    private void getNormalizeOffset() {
        this.offset = this.getNormalizedOffset(this.offset);
    }

    private double getNormalizedOffset(double offset) {
        return CA.getNormalizedOffset(offset, this.length);
    }

    public static double getNormalizedOffset(double offset, double length) {
        if (offset >= 0.0) {
            if (offset >= length) {
                offset %= length;
            }
        } else {
            if ((offset = -offset) >= length) {
                offset %= length;
            }
            if ((offset = length - offset) >= length) {
                offset = 0.0;
            }
        }
        return offset;
    }
}

