/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.datatype.geom.Line2D;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.math.QuadPathIterator;
import java.awt.geom.GeneralPath;

public class CurveBuilder {
    public static GeneralPath buildClosedCurve(double[] x, double[] y, int takeEveryNth) {
        R2[] p = CurveBuilder.buildClosedCurveArray(x, y, takeEveryNth);
        QuadPathIterator iterator = new QuadPathIterator(p, true);
        GeneralPath path = new GeneralPath();
        path.append(iterator, true);
        return path;
    }

    private static R2[] buildClosedCurveArray(double[] x, double[] y, int takeEveryNth) {
        int k;
        int n;
        int arrLen = x.length;
        if (takeEveryNth <= 1) {
            throw new IllegalArgumentException("takeEveryNth should be greater than 1");
        }
        if (arrLen % takeEveryNth != 0) {
            throw new IllegalArgumentException("array length should be multiple to takeEveryNth");
        }
        int qtyOfGroups = arrLen / takeEveryNth;
        R2[] p = new R2[2 * qtyOfGroups + 1];
        Line2D[] tangent = new Line2D[qtyOfGroups];
        int nG = 0;
        while (nG < qtyOfGroups) {
            n = takeEveryNth * nG;
            k = nG > 0 ? n - 1 : arrLen - 1;
            R2 dir = new R2(x[k], y[k]).subtract(new R2(x[n + 1], y[n + 1]));
            tangent[nG] = new Line2D(new R2(x[n], y[n]), new R2(x[n], y[n]).add(dir));
            ++nG;
        }
        nG = 0;
        while (nG < qtyOfGroups) {
            n = takeEveryNth * nG;
            k = 2 * nG;
            p[k] = new R2(x[n], y[n]);
            Line2D otherLine = nG < qtyOfGroups - 1 ? tangent[nG + 1] : tangent[0];
            Object intersection = tangent[nG].intersection(otherLine);
            if (!(intersection instanceof R2)) {
                if (intersection == null) {
                    throw new RuntimeException("tangent lines do not intersect!");
                }
                throw new RuntimeException("tangent lines coincide (nG = " + nG + ")");
            }
            p[k + 1] = (R2)intersection;
            ++nG;
        }
        p[2 * qtyOfGroups] = p[0];
        return p;
    }
}

