/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.math.Complex;
import edu.uml.lgdc.math.ExtMath;
import jnt.FFT.ComplexDoubleFFT;
import jnt.FFT.ComplexDoubleFFT_Mixed;
import jnt.FFT.ComplexDoubleFFT_Radix2;

public class DFTcalc {
    public static Complex[] compute(Complex[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        if (data.length == 0) {
            throw new IllegalArgumentException("data.length == 0");
        }
        if (data.length == 1) {
            return new Complex[]{new Complex(data[0])};
        }
        double[] reIm = DFTcalc.toReIm(data);
        DFTcalc.transform1(reIm);
        return DFTcalc.toComplex(reIm);
    }

    public static void transform(double[] reIm) {
        if (reIm == null) {
            throw new IllegalArgumentException("reIm == null");
        }
        if (reIm.length == 0) {
            throw new IllegalArgumentException("reIm.length == 0");
        }
        if (reIm.length % 2 == 1) {
            throw new IllegalArgumentException("reIm.length is odd number");
        }
        if (reIm.length == 2) {
            return;
        }
        DFTcalc.transform1(reIm);
    }

    private static void transform1(double[] reIm) {
        int numberOfSamples = reIm.length / 2;
        int log2 = ExtMath.getExactLogOf2(numberOfSamples);
        ComplexDoubleFFT complexFFT = log2 >= 0 ? new ComplexDoubleFFT_Radix2(numberOfSamples) : new ComplexDoubleFFT_Mixed(numberOfSamples);
        complexFFT.transform(reIm);
    }

    private static double[] toReIm(Complex[] data) {
        double[] reIm = new double[2 * data.length];
        int i = 0;
        int k = 0;
        while (i < data.length) {
            reIm[k] = data[i].getRe();
            reIm[k + 1] = data[i].getIm();
            ++i;
            k += 2;
        }
        return reIm;
    }

    private static Complex[] toComplex(double[] reIm) {
        Complex[] data = new Complex[reIm.length / 2];
        int i = 0;
        int k = 0;
        while (i < data.length) {
            data[i] = new Complex(reIm[k], reIm[k + 1]);
            ++i;
            k += 2;
        }
        return data;
    }
}

