/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.math.Sort;

public class Distribution {
    private static final int DEFAULT_HISTOGRAM_LEVELS = 32;
    private static final int MAX_BINS_IN_HISTOGRAM = 16;
    private static final int MIN_BIN_SIZE = 8;
    private static final int DYNAMIC_RANGE_CALC_MODE = 0;
    private static final int FIXED_RANGE_CALC_MODE = 1;
    private static final int AUTO_BIN_QTY_CALC_MODE = 2;
    private double fillValue = Double.NaN;
    private boolean cutTrailingFillValues = true;
    public double mode;
    public double max;
    public double min;
    public double mean;
    public double sum;
    public double step;
    private int calcMode = 0;
    private int histogramLevels = 32;
    private int maxBinsInHistogram = 16;
    private int minBinSize = 8;
    private double minRangeValue;
    private double maxRangeValue;

    public Distribution() {
        this.setHistogramLevels(32);
    }

    public Distribution(int hl) {
        this.setHistogramLevels(hl);
    }

    public Distribution(boolean autoBinQtyCalc) {
        this(autoBinQtyCalc, 8, 16);
    }

    public Distribution(boolean autoBinQtyCalc, int minBinSize, int maxBinsInHistogram) {
        this.setAutoBinQtyCalc(autoBinQtyCalc, minBinSize, maxBinsInHistogram);
    }

    public void setHistogramLevels(int i) {
        this.histogramLevels = Math.max(i, 1);
    }

    public void setAutoBinQtyCalc(boolean autoBinQtyCalc) {
        this.setAutoBinQtyCalc(autoBinQtyCalc, this.minBinSize, this.maxBinsInHistogram);
    }

    public void setAutoBinQtyCalc(boolean autoBinQtyCalc, int minBinSize, int maxBinsInHistogram) {
        this.minBinSize = minBinSize;
        this.maxBinsInHistogram = maxBinsInHistogram;
        this.calcMode = autoBinQtyCalc ? 2 : 0;
    }

    public void setFixedRangeCalc(double minRangeValue, double maxRangeValue) {
        this.minRangeValue = minRangeValue;
        this.maxRangeValue = maxRangeValue;
        this.calcMode = 1;
    }

    public void setDynamicRangeCalc(int histogramLevels) {
        this.setHistogramLevels(histogramLevels);
        this.calcMode = 0;
    }

    public void setFillValue(double fill) {
        this.fillValue = fill;
    }

    public void setCutTrailingFillValues(boolean flag) {
        this.cutTrailingFillValues = flag;
    }

    public void calculate(double[] a) {
        this.calculate(a, a.length);
    }

    public void calculate(double[] a, int len) {
        int last_index = this.getLastIndex(a, len);
        int count = 0;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        this.sum = 0.0;
        boolean checkFillValue = !Double.isNaN(this.fillValue);
        int i = 0;
        while (i <= last_index) {
            if (!checkFillValue || a[i] != this.fillValue) {
                ++count;
                this.sum += a[i];
                if (a[i] > this.max) {
                    this.max = a[i];
                }
                if (a[i] < this.min) {
                    this.min = a[i];
                }
            }
            ++i;
        }
        this.mean = (float)(this.sum / (double)count);
        if (this.max == Double.NEGATIVE_INFINITY) {
            this.mode = Double.NEGATIVE_INFINITY;
        } else {
            int histLevels = this.histogramLevels;
            double minValue = this.min;
            double maxValue = this.max;
            if (this.calcMode == 1) {
                minValue = this.minRangeValue;
                maxValue = this.maxRangeValue;
            } else if (this.calcMode == 2 && (histLevels = Math.min(this.maxBinsInHistogram, (int)((this.max - this.min) / (double)this.minBinSize))) == 0) {
                histLevels = 1;
            }
            if (this.histogramLevels == 1) {
                this.mode = this.mean;
            } else {
                this.step = (maxValue - minValue) / (double)histLevels;
                int[] histogram = new int[histLevels];
                i = 0;
                while (i <= last_index) {
                    if (!checkFillValue || a[i] != this.fillValue) {
                        int index = (int)Math.round((a[i] - minValue) / this.step);
                        if (index > histLevels - 1) {
                            index = histLevels - 1;
                        }
                        if (index < 0) {
                            index = 0;
                        }
                        int n = index;
                        histogram[n] = histogram[n] + 1;
                    }
                    ++i;
                }
                int bestIndex = 0;
                i = 1;
                while (i < histLevels) {
                    if (histogram[i] >= histogram[bestIndex]) {
                        bestIndex = i;
                    }
                    ++i;
                }
                this.mode = minValue + (double)bestIndex * this.step;
            }
        }
    }

    public double findPercentile(double[] a, int perc) {
        double[] temp = this.fillTempArray(a);
        Sort.qsort(temp);
        int theIndex = (int)((double)(temp.length * perc) / 100.0 - 1.0);
        if (theIndex > temp.length - 1) {
            theIndex = temp.length - 1;
        } else if (theIndex < 0) {
            theIndex = 0;
        }
        return temp[theIndex];
    }

    private double[] fillTempArray(double[] a) {
        int last_index = this.getLastIndex(a, a.length);
        boolean checkFillValue = !Double.isNaN(this.fillValue);
        int realQty = Distribution.getRealQty(a, last_index, this.fillValue);
        double[] temp = new double[realQty];
        if (checkFillValue) {
            int j = 0;
            int i = 0;
            while (i <= last_index) {
                if (a[i] != this.fillValue) {
                    temp[j++] = a[i];
                }
                ++i;
            }
        } else {
            System.arraycopy(a, 0, temp, 0, temp.length);
        }
        return temp;
    }

    private int getLastIndex(double[] a, int length) {
        boolean checkFillValue;
        int last_index = Math.min(a.length - 1, length - 1);
        boolean bl = checkFillValue = !Double.isNaN(this.fillValue);
        if (this.cutTrailingFillValues && checkFillValue) {
            boolean found = false;
            int i = a.length - 1;
            while (i > 0) {
                if (a[i] != this.fillValue) {
                    last_index = i;
                    found = true;
                    break;
                }
                --i;
            }
            if (!found) {
                last_index = 0;
            }
        }
        return last_index;
    }

    private static int getRealQty(double[] a, int last_index, double fillValue) {
        boolean checkFillValue;
        boolean bl = checkFillValue = !Double.isNaN(fillValue);
        if (!checkFillValue) {
            return last_index + 1;
        }
        int qty = 0;
        int i = 0;
        while (i <= last_index) {
            if (a[i] != fillValue) {
                ++qty;
            }
            ++i;
        }
        return qty;
    }
}

