/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.datatype.TimeOrderedMetric;
import edu.uml.lgdc.math.Distribution;
import edu.uml.lgdc.math.ExtMath;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.math.Sort;
import edu.uml.lgdc.time.TimeScale;
import java.util.List;
import java.util.Vector;

public class Statistic {
    private static final int HIST_LEN_IN_MIN = 60;
    private static final double HIST_INT_IN_MIN = 1.0;

    public static double mean(double[] values) {
        return Statistic.mean(values, values.length);
    }

    public static double mean(double[] values, int length) {
        return Statistic.mean(values, 0, length);
    }

    public static double mean(double[] values, int start, int length) {
        double avg = 0.0;
        if (length > 0) {
            int i = start;
            while (i < start + length) {
                avg += values[i];
                ++i;
            }
            avg /= (double)length;
        }
        return avg;
    }

    public static <T extends Number> double mean(List<T> values) {
        return Statistic.mean(values, values.size());
    }

    public static <T extends Number> double mean(List<T> values, int length) {
        return Statistic.mean(values, 0, length);
    }

    public static <T extends Number> double mean(List<T> values, int start, int length) {
        double avg = 0.0;
        int i = start;
        while (i < start + length) {
            avg += ((Number)values.get(i)).doubleValue();
            ++i;
        }
        return avg / (double)length;
    }

    public static double weighedMean(double[] values, double[] weights) {
        return Statistic.weighedMean(values, weights, 0, values.length);
    }

    public static double weighedMean(double[] values, double[] weights, int start, int length) {
        double weighedAvg = 0.0;
        double totWeight = 0.0;
        int i = start;
        while (i < start + length) {
            weighedAvg += weights[i] * values[i];
            totWeight += weights[i];
            ++i;
        }
        return weighedAvg /= totWeight;
    }

    public static double weighedMean(Vector<Double> values, Vector<Double> weights) {
        return Statistic.weighedMean(values, weights, 0, values.size());
    }

    public static double weighedMean(Vector<Double> values, Vector<Double> weights, int start, int length) {
        double weighedAvg = 0.0;
        double totWeight = 0.0;
        double value = 0.0;
        double weight = 0.0;
        int i = start;
        while (i < start + length) {
            value = values.elementAt(i);
            weight = weights.elementAt(i);
            weighedAvg += weight * value;
            totWeight += weight;
            ++i;
        }
        return weighedAvg /= totWeight;
    }

    public static double deviation(double[] values) {
        return Statistic.deviation(values, Statistic.mean(values));
    }

    public static double deviation(double[] values, int start, int length) {
        return Statistic.deviation(values, start, length, Statistic.mean(values, start, length));
    }

    public static double deviation(double[] values, double avg) {
        return Statistic.deviation(values, 0, values.length, avg);
    }

    public static double deviation(double[] values, int start, int length, double avg) {
        double deviation = 0.0;
        int i = start;
        while (i < start + length) {
            deviation += (values[i] - avg) * (values[i] - avg);
            ++i;
        }
        deviation = Math.sqrt(deviation / (double)length);
        return deviation;
    }

    public static double median(double[] array) {
        return Statistic.median(array, array.length);
    }

    public static double median(double[] array, int len) {
        Sort.qsort(array, 0, len - 1);
        return Statistic.midPointOfArray(array, 0, len - 1);
    }

    public static float median(float[] array) {
        return Statistic.median(array, array.length);
    }

    public static float median(float[] array, int len) {
        Sort.qsort(array, 0, len - 1);
        return Statistic.midPointOfArray(array, 0, len - 1);
    }

    public static float median(int[] array) {
        return Statistic.median(array, array.length);
    }

    public static int median(int[] array, int len) {
        Sort.qsort(array, 0, len - 1);
        return Statistic.midPointOfArray(array, 0, len - 1);
    }

    public static double min(double[] array, int len) {
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < len) {
            if (array[i] < min) {
                min = array[i];
            }
            ++i;
        }
        return min;
    }

    public static double max(double[] array, int len) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < len) {
            if (array[i] > max) {
                max = array[i];
            }
            ++i;
        }
        return max;
    }

    public static double mode(double[] array, int len, int levels) {
        Distribution d = new Distribution(levels);
        d.calculate(array, len);
        return d.mode;
    }

    public static double mpa(double[] array, int len, int levels) {
        Distribution d = new Distribution(levels);
        d.setFixedRangeCalc(0.0, 93.0);
        d.calculate(array, len);
        return d.mode;
    }

    public static double midPointOfArray(double[] array, int first, int last) {
        int len = last - first + 1;
        if (len % 2 == 1) {
            return array[first + len / 2];
        }
        return (array[first + len / 2 - 1] + array[first + len / 2]) / 2.0;
    }

    public static float midPointOfArray(float[] array, int first, int last) {
        int len = last - first + 1;
        if (len % 2 == 1) {
            return array[first + len / 2];
        }
        return (array[first + len / 2 - 1] + array[first + len / 2]) / 2.0f;
    }

    public static int midPointOfArray(int[] array, int first, int last) {
        int len = last - first + 1;
        if (len % 2 == 1) {
            return array[first + len / 2];
        }
        return (array[first + len / 2 - 1] + array[first + len / 2]) / 2;
    }

    public static <T extends TimeOrderedMetric> double getMostProbableInterval(List<T> list) {
        if (list.size() <= 1) {
            return 0.0;
        }
        return Statistic.getMostProbableInterval(list, 0, list.size() - 1);
    }

    public static <T extends TimeOrderedMetric> double getMostProbableInterval(List<T> list, T time1, T time2) {
        int ind2;
        if (time2.compareTo(time1) < 0) {
            throw new IllegalArgumentException("time1 > time2");
        }
        int ind1 = Search.rightNearest(list, time1);
        if (ind1 >= (ind2 = Search.leftNearest(list, time2))) {
            return 0.0;
        }
        return Statistic.getMostProbableInterval(list, ind1, ind2);
    }

    public static <T extends TimeOrderedMetric> double getMostProbableInterval(List<T> list, int ind1, int ind2) {
        if (ind1 < 0 || ind2 >= list.size() || ind1 > ind2) {
            throw new IllegalArgumentException("indexes ind1/ind2 incorrect");
        }
        int[] hist = new int[60];
        double[] avg = new double[60];
        int i = 0;
        while (i < 60) {
            hist[i] = 0;
            ++i;
        }
        int i2 = ind1;
        while (i2 < ind2) {
            int index;
            TimeOrderedMetric tom1 = (TimeOrderedMetric)list.get(i2);
            TimeOrderedMetric tom2 = (TimeOrderedMetric)list.get(i2 + 1);
            if (tom2.compareTo(tom1) < 0) {
                System.out.println("i = " + i2 + ", " + new TimeScale(tom1.getTimeInMinutes()).toHumanUT());
                System.out.println("i+1 = " + (i2 + 1) + ", " + new TimeScale(tom2.getTimeInMinutes()).toHumanUT());
                throw new IllegalArgumentException("elements are not increasing");
            }
            double diff = tom1.dist(tom2);
            int n = index = Math.min((int)Math.round(diff / 1.0), 59);
            hist[n] = hist[n] + 1;
            int n2 = index;
            avg[n2] = avg[n2] + diff;
            ++i2;
        }
        int hitIndex = 0;
        double hitValue = hist[0];
        int i3 = 1;
        while (i3 < 60) {
            if ((double)hist[i3] > hitValue) {
                hitIndex = i3;
                hitValue = hist[i3];
            }
            ++i3;
        }
        return avg[hitIndex] / hitValue;
    }

    public static double percentile(double[] array, int len, int percent) {
        Sort.qsort(array, 0, len - 1);
        int i = (int)((double)len * (double)percent / 100.0) - 1;
        i = ExtMath.greaterOf(i, 0);
        i = ExtMath.smallerOf(i, len - 1);
        return array[i];
    }
}

