/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math;

import edu.uml.lgdc.datatype.geom.R2;

public class WholeGridLineInterpolation {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private boolean xDirection;
    private int step;
    private double tangent;
    private int firstIntegerArgumentForInterpolation;
    private int lastIntegerArgumentForInterpolation;
    private int interpolationLength;

    public WholeGridLineInterpolation() {
    }

    public WholeGridLineInterpolation(double x1, double y1, double x2, double y2) {
        this.setEndPoints(x1, y1, x2, y2);
    }

    public void setEndPoints(double x1, double y1, double x2, double y2) {
        double last;
        double first;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        if (Math.abs(x2 - x1) >= Math.abs(y2 - y1)) {
            this.xDirection = true;
            this.tangent = (y2 - y1) / (x2 - x1);
            this.step = x2 > x1 ? 1 : -1;
            double d = first = this.step == 1 ? Math.ceil(x1) : Math.floor(x1);
            if (first == x1) {
                first += (double)this.step;
            }
            this.firstIntegerArgumentForInterpolation = (int)first;
            double d2 = last = this.step == 1 ? Math.floor(x2) : Math.ceil(x2);
            if (last == x2) {
                last -= (double)this.step;
            }
        } else {
            this.xDirection = false;
            this.tangent = (x2 - x1) / (y2 - y1);
            this.step = y2 > y1 ? 1 : -1;
            double d = first = this.step == 1 ? Math.ceil(y1) : Math.floor(y1);
            if (first == y1) {
                first += (double)this.step;
            }
            double d3 = last = this.step == 1 ? Math.floor(y2) : Math.ceil(y2);
            if (last == y2) {
                last -= (double)this.step;
            }
        }
        this.firstIntegerArgumentForInterpolation = (int)first;
        this.lastIntegerArgumentForInterpolation = (int)last;
        this.interpolationLength = this.step == 1 ? this.lastIntegerArgumentForInterpolation - this.firstIntegerArgumentForInterpolation + 1 : this.firstIntegerArgumentForInterpolation - this.lastIntegerArgumentForInterpolation + 1;
        this.interpolationLength = Math.max(this.interpolationLength, 0);
    }

    public int getInterpolationLength() {
        return this.interpolationLength;
    }

    public void fillLineArray(R2[] line, int start) {
        if (this.xDirection) {
            int i = 0;
            int arg = this.firstIntegerArgumentForInterpolation;
            while (i < this.interpolationLength) {
                line[start++] = new R2((double)arg, this.y2 - this.tangent * (this.x2 - (double)arg));
                ++i;
                arg += this.step;
            }
        } else {
            int i = 0;
            int arg = this.firstIntegerArgumentForInterpolation;
            while (i < this.interpolationLength) {
                line[start++] = new R2(this.x2 - this.tangent * (this.y2 - (double)arg), (double)arg);
                ++i;
                arg += this.step;
            }
        }
    }

    public static R2[] getInterpolated(R2[] polyline) {
        return WholeGridLineInterpolation.getInterpolated(polyline, 0, polyline.length);
    }

    public static R2[] getInterpolated(R2[] polyline, int start, int length) {
        int numberOfInterpolationPoints = WholeGridLineInterpolation.getumberOfInterpolationPoints(polyline, start, length);
        R2[] interpolated = new R2[length + numberOfInterpolationPoints];
        int outIndex = 0;
        WholeGridLineInterpolation line = new WholeGridLineInterpolation();
        int i = start;
        while (i < start + length - 1) {
            interpolated[outIndex++] = new R2(polyline[i].getX(), polyline[i].getY());
            double currentX = polyline[i].getX();
            double nextX = polyline[i + 1].getX();
            double currentY = polyline[i].getY();
            double nextY = polyline[i + 1].getY();
            line.setEndPoints(currentX, currentY, nextX, nextY);
            line.fillLineArray(interpolated, outIndex);
            outIndex += line.getInterpolationLength();
            ++i;
        }
        interpolated[outIndex] = new R2(polyline[length - 1].getX(), polyline[length - 1].getY());
        return interpolated;
    }

    public static int getNumberOfInterpolationPoints(R2[] polyline) {
        return WholeGridLineInterpolation.getumberOfInterpolationPoints(polyline, 0, polyline.length);
    }

    public static int getumberOfInterpolationPoints(R2[] polyline, int start, int length) {
        int numberOfInterpolationPoints = 0;
        WholeGridLineInterpolation wholeGridLineInterpolation = new WholeGridLineInterpolation();
        int i = start + 1;
        while (i < start + length) {
            wholeGridLineInterpolation.setEndPoints(polyline[i - 1].getX(), polyline[i - 1].getY(), polyline[i].getX(), polyline[i].getY());
            numberOfInterpolationPoints += wholeGridLineInterpolation.getInterpolationLength();
            ++i;
        }
        return numberOfInterpolationPoints;
    }
}

