/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.math.test;

import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.math.WholeGridLineInterpolation;
import java.util.Arrays;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestWholeGridLineInterpolation {
    private static final double[][][][] ALL_TEST_DATA = new double[][][][]{new double[][][]{new double[][]{{0.0, 0.0}, {3.0, 3.0}, {5.0, 5.0}}, new double[][]{{0.0, 0.0}, {1.0, 1.0}, {2.0, 2.0}, {3.0, 3.0}, {4.0, 4.0}, {5.0, 5.0}}}, new double[][][]{new double[][]{{5.0, 5.0}, {3.0, 3.0}, {0.0, 0.0}}, new double[][]{{5.0, 5.0}, {4.0, 4.0}, {3.0, 3.0}, {2.0, 2.0}, {1.0, 1.0}, {0.0, 0.0}}}, new double[][][]{new double[][]{{0.9, 0.9}, {3.0, 3.0}, {5.0, 5.0}}, new double[][]{{0.9, 0.9}, {1.0, 1.0}, {2.0, 2.0}, {3.0, 3.0}, {4.0, 4.0}, {5.0, 5.0}}}, new double[][][]{new double[][]{{5.0, 5.0}, {3.0, 3.0}, {0.9, 0.9}}, new double[][]{{5.0, 5.0}, {4.0, 4.0}, {3.0, 3.0}, {2.0, 2.0}, {1.0, 1.0}, {0.9, 0.9}}}, new double[][][]{new double[][]{{0.9, 0.9}, {3.0, 3.0}, {4.5, 4.5}}, new double[][]{{0.9, 0.9}, {1.0, 1.0}, {2.0, 2.0}, {3.0, 3.0}, {4.0, 4.0}, {4.5, 4.5}}}, new double[][][]{new double[][]{{4.5, 4.5}, {3.0, 3.0}, {0.9, 0.9}}, new double[][]{{4.5, 4.5}, {4.0, 4.0}, {3.0, 3.0}, {2.0, 2.0}, {1.0, 1.0}, {0.9, 0.9}}}, new double[][][]{new double[][]{{0.0, 0.0}, {2.0, 1.0}, {6.0, 3.0}}, new double[][]{{0.0, 0.0}, {1.0, 0.5}, {2.0, 1.0}, {3.0, 1.5}, {4.0, 2.0}, {5.0, 2.5}, {6.0, 3.0}}}, new double[][][]{new double[][]{{6.0, 3.0}, {2.0, 1.0}, {0.0, 0.0}}, new double[][]{{6.0, 3.0}, {5.0, 2.5}, {4.0, 2.0}, {3.0, 1.5}, {2.0, 1.0}, {1.0, 0.5}, {0.0, 0.0}}}, new double[][][]{new double[][]{{0.9, 0.45}, {2.0, 1.0}, {6.0, 3.0}}, new double[][]{{0.9, 0.45}, {1.0, 0.5}, {2.0, 1.0}, {3.0, 1.5}, {4.0, 2.0}, {5.0, 2.5}, {6.0, 3.0}}}, new double[][][]{new double[][]{{6.0, 3.0}, {2.0, 1.0}, {0.9, 0.45}}, new double[][]{{6.0, 3.0}, {5.0, 2.5}, {4.0, 2.0}, {3.0, 1.5}, {2.0, 1.0}, {1.0, 0.5}, {0.9, 0.45}}}, new double[][][]{new double[][]{{0.9, 0.45}, {2.0, 1.0}, {5.5, 2.75}}, new double[][]{{0.9, 0.45}, {1.0, 0.5}, {2.0, 1.0}, {3.0, 1.5}, {4.0, 2.0}, {5.0, 2.5}, {5.5, 2.75}}}, new double[][][]{new double[][]{{5.5, 2.75}, {2.0, 1.0}, {0.9, 0.45}}, new double[][]{{5.5, 2.75}, {5.0, 2.5}, {4.0, 2.0}, {3.0, 1.5}, {2.0, 1.0}, {1.0, 0.5}, {0.9, 0.45}}}, new double[][][]{new double[][]{{0.0, 0.0}, {4.0, 4.0}, {0.0, 6.0}}, new double[][]{{0.0, 0.0}, {1.0, 1.0}, {2.0, 2.0}, {3.0, 3.0}, {4.0, 4.0}, {3.0, 4.5}, {2.0, 5.0}, {1.0, 5.5}, {0.0, 6.0}}}, new double[][][]{new double[][]{{0.0, 6.0}, {4.0, 4.0}, {0.0, 0.0}}, new double[][]{{0.0, 6.0}, {1.0, 5.5}, {2.0, 5.0}, {3.0, 4.5}, {4.0, 4.0}, {3.0, 3.0}, {2.0, 2.0}, {1.0, 1.0}, {0.0, 0.0}}}};

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test() {
        int i = 0;
        while (i < ALL_TEST_DATA.length) {
            double[][][] testData = ALL_TEST_DATA[i];
            R2[] input = TestWholeGridLineInterpolation.toR2(testData[0]);
            R2[] expectedResult = TestWholeGridLineInterpolation.toR2(testData[1]);
            R2[] result = WholeGridLineInterpolation.getInterpolated(input);
            if (!TestWholeGridLineInterpolation.compare(result, expectedResult)) {
                TestWholeGridLineInterpolation.printNotEqual(result, expectedResult);
                Assert.fail();
            } else {
                System.out.println("test #" + i + " passed");
            }
            ++i;
        }
    }

    private static R2[] toR2(double[][] data) {
        R2[] points = new R2[data.length];
        int i = 0;
        while (i < points.length) {
            points[i] = new R2(data[i][0], data[i][1]);
            ++i;
        }
        return points;
    }

    private static boolean compare(R2[] result, R2[] expectedResult) {
        if (result.length != expectedResult.length) {
            return false;
        }
        int i = 0;
        while (i < result.length) {
            if (result[i].dist(expectedResult[i]) > 1.0E-10) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void printNotEqual(R2[] result, R2[] expectedResult) {
        System.out.println("Wrong result:");
        System.out.println(Arrays.asList(result));
        System.out.println("Expected:");
        System.out.println(Arrays.asList(expectedResult));
    }
}

