/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project;

public class BeamData {
    protected final double[][] antCoords;
    protected double lambda;
    protected double speedOfLight_km_s = 299792.458;

    public BeamData(double[][] antCoords) {
        assert (antCoords != null);
        assert (antCoords.length > 0);
        this.antCoords = antCoords;
    }

    public void setRoundedSpeedOfLight() {
        this.speedOfLight_km_s = 300000.0;
    }

    public void setFrequency_Hz(double frequency_Hz) {
        assert (frequency_Hz >= 1000.0);
        this.lambda = 1000.0 * this.speedOfLight_km_s / frequency_Hz;
    }

    public double[] getPhasesForAllAntennas(double zenith_Deg, double azimuth_Deg) {
        double[] phases = new double[this.antCoords.length];
        int antennaIndex = 0;
        while (antennaIndex < this.antCoords.length) {
            phases[antennaIndex] = this.getPhaseForOneAntenna(zenith_Deg, azimuth_Deg, antennaIndex);
            ++antennaIndex;
        }
        return phases;
    }

    public double[][] getDataForAllAntennas(double zenith_Deg, double azimuth_Deg) {
        double[][] data = new double[this.antCoords.length][];
        int antennaIndex = 0;
        while (antennaIndex < this.antCoords.length) {
            data[antennaIndex] = this.getDataForOneAntenna(zenith_Deg, azimuth_Deg, antennaIndex);
            ++antennaIndex;
        }
        return data;
    }

    public double getPhaseForOneAntenna(double zenith_Deg, double azimuth_Deg, int antennaIndex) {
        assert (this.lambda != 0.0) : "frequency was not set";
        double const1 = Math.PI * 2 * Math.sin(Math.toRadians(zenith_Deg)) / this.lambda;
        return this.getPhaseForOneAntenna(const1, Math.cos(Math.toRadians(azimuth_Deg)), Math.sin(Math.toRadians(azimuth_Deg)), antennaIndex);
    }

    public double[] getDataForOneAntenna(double zenith_Deg, double azimuth_Deg, int antennaIndex) {
        assert (this.lambda != 0.0) : "frequency was not set";
        double const1 = Math.PI * 2 * Math.sin(Math.toRadians(zenith_Deg)) / this.lambda;
        double phase = this.getPhaseForOneAntenna(const1, Math.cos(Math.toRadians(azimuth_Deg)), Math.sin(Math.toRadians(azimuth_Deg)), antennaIndex);
        return BeamData.getReImByPhase(phase);
    }

    protected double getPhaseForOneAntenna(double const1, double cosAzimuth, double sinAzimuth, int antennaIndex) {
        return const1 * (this.antCoords[antennaIndex][0] * cosAzimuth + this.antCoords[antennaIndex][1] * sinAzimuth);
    }

    protected static double[] getReImByPhase(double phase) {
        return new double[]{Math.cos(phase), Math.sin(phase)};
    }
}

