/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.project.Console;
import java.util.ArrayList;

public class CStyleFormat {
    public static final String PLACE_HOLDER_TERMINATORS_INT = "dxX";
    private String lastErrorText;

    public String encode(String format, int[] values) {
        String encodedStr = "";
        this.lastErrorText = null;
        int[][] infoPlaceHolders = CStyleFormat.getInfoPlaceHoldersPositions(format, PLACE_HOLDER_TERMINATORS_INT);
        if (values.length != infoPlaceHolders.length) {
            this.lastErrorText = "Number of items, " + values.length + ", not equal to number of place holders, " + infoPlaceHolders.length;
            return null;
        }
        if (values.length == 0) {
            encodedStr = format;
        } else {
            encodedStr = format.substring(0, infoPlaceHolders[0][0]);
            int i = 0;
            while (i < values.length) {
                String valStr;
                if (i > 0) {
                    encodedStr = String.valueOf(encodedStr) + format.substring(infoPlaceHolders[i - 1][1] + 1, infoPlaceHolders[i][0]);
                }
                if ((valStr = this.encode(format.substring(infoPlaceHolders[i][0], infoPlaceHolders[i][1] + 1), values[i])) == null) {
                    return null;
                }
                encodedStr = String.valueOf(encodedStr) + valStr;
                ++i;
            }
            encodedStr = String.valueOf(encodedStr) + format.substring(infoPlaceHolders[values.length - 1][1] + 1);
        }
        return encodedStr;
    }

    private String encode(String placeHolder, int value) {
        String encodedValue = "";
        char type = placeHolder.charAt(placeHolder.length() - 1);
        if (!StrUtil.isOnlyDigits(placeHolder = placeHolder.substring(1, placeHolder.length() - 1))) {
            this.lastErrorText = "non-digit encountered in width-part of format, " + placeHolder;
            return null;
        }
        if (PLACE_HOLDER_TERMINATORS_INT.indexOf(type) < 0) {
            this.lastErrorText = "illegal format symbol, " + type;
            return null;
        }
        int length = 0;
        if (placeHolder.length() > 0) {
            length = Integer.parseInt(placeHolder);
        }
        boolean leadingZeroes = false;
        if (placeHolder.length() > 0 && placeHolder.charAt(0) == '0') {
            leadingZeroes = true;
        }
        char padChar = leadingZeroes ? (char)'0' : ' ';
        switch (type) {
            case 'd': {
                if (length == 0) {
                    encodedValue = "" + value;
                    break;
                }
                encodedValue = Formatter.padLeft("" + value, length, padChar);
                break;
            }
            case 'X': 
            case 'x': {
                encodedValue = Integer.toHexString(value);
                if (length > 0) {
                    encodedValue = Formatter.padLeft(encodedValue, length, padChar);
                }
                if (type != 'X') break;
                encodedValue = encodedValue.toUpperCase();
                break;
            }
            default: {
                Console.showError("encode: method *encode* is not consistent with PLACE_HOLDERS_TERMINATORS");
            }
        }
        return encodedValue;
    }

    public static int[][] getInfoPlaceHoldersPositions(String pattern, String placeHolderTerminators) {
        ArrayList<int[]> lstPositions = new ArrayList<int[]>();
        int startPos = -1;
        int endPos = -1;
        while (endPos < pattern.length() - 2) {
            startPos = pattern.indexOf(37, endPos + 1);
            if (startPos < 0) break;
            endPos = startPos + 1;
            while (endPos < pattern.length()) {
                char c = pattern.charAt(endPos);
                if (placeHolderTerminators.indexOf(c) >= 0) break;
                ++endPos;
            }
            if (endPos >= pattern.length()) break;
            lstPositions.add(new int[]{startPos, endPos});
        }
        return (int[][])lstPositions.toArray((T[])new int[lstPositions.size()][]);
    }

    public String getLastError() {
        return this.lastErrorText;
    }
}

